import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;


/**
 * Actual implementation of the Adventurer.
 * Is supposed to contain really smart code for parsing commands.  
 */

public class IntrepidAdventurer implements Adventurer {

	/** the sack to store the adventurers stuff in */
	private Container mySack;
	/** the current location the adventurer is in. */
	private Room      myCurrentLocation;

	/** constructs a new IntrepidAdventurer with a sack to store his object in. */
	public IntrepidAdventurer(Container sack) {
		mySack=sack;
	}
	
	/** indicates the IntrepidAdventurer enters a room. */
	public void enter(Room room) {
		myCurrentLocation=room;
	}
	
	/** 
	 * utility method to cut a string into separate words.
	 * @param command the string to cut
	 * @return String[] the separate words. Words are delimited by spaces or comma's.  
	 */
	protected String[] cut(String command) {
		List l=new ArrayList();
		StringTokenizer st=new StringTokenizer(command," ,");
		while (st.hasMoreElements()) l.add(st.nextToken());
		return (String[])l.toArray(new String[l.size()]);
	}

	/**
	 * returns true if the specified word is contains in the array. 
	 */	
	protected boolean contains(String[] words,String word) {
		 for (int t=0;t<words.length;t++) {
		 	if (words[t].equalsIgnoreCase(word)) {
		 		return true;
		 	}
		 }
		 return false;
	}

	/**
	 * returns true if there is a match between the words and other array. 
	 */	
	protected boolean contains(String[] words,String[] other) {
		 for (int t=0;t<words.length;t++) {
		 	for (int y=0;y<other.length;y++) {
				if (words[t].equalsIgnoreCase(other[y])) {
					return true;
				}
			}
		 }
		 return false;
	}

	public String performTakeOrDrop(String command) {
		//
		// Analyse the command and act to it.
		//
		return Adventurer.RESPONSE_NOTUNDERSTAND;
	}

}
