
/**
 * Implements the game of Paper Scissors Stone. 
 */
public enum PaperScissorsStoneImpl {

    /** represents Paper. */
    PAPER(1),
    /** represents Scissors. */
    SCISSORS(2),
    /** represents Stone. */
    STONE(0);

    int r;

    private PaperScissorsStoneImpl(int r) {
    this.r=r;
    }
    
    /**
     * returns the outcome of a battle between this opponent and the other.
     * @param other the other opponent. 
     * @return the outcome of the battle, WIN, LOSE or TIE.
     */
    public Outcome battles(PaperScissorsStoneImpl other) {
        if(this.equals(other)) return Outcome.TIE;
        //
        // TODO: Implement.
        //
        return this.ordinal()==other.r?Outcome.WIN:Outcome.LOSE; 
    }
    

}
