package nl.moj.test.gremlin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

import nl.ctrlaltdev.util.Tool;
import nl.moj.client.codecompletion.SourceCodeParser;
import nl.moj.client.codecompletion.statement.AbstractStatement;
import nl.moj.client.codecompletion.statement.EnumStatement;
import nl.moj.client.codecompletion.statement.FieldStatement;
import nl.moj.client.codecompletion.statement.StatementVisitor;
import nl.moj.mgmt.TeamProfileList;

public class SmartGremlinClient extends GremlinClient {

	private static final class CodeSegment {
		private String code;
		private  boolean mandatory;
		public CodeSegment(String code,boolean mandatory) { 
			this.code=code;
			this.mandatory=mandatory;
		}
		public boolean isMandatory() { return mandatory; }
		public String getCode() { return code; }
		public String toString() {
			return mandatory+" '"+code+"'";
		}
	}
	
	private CodeSegment[] segments;
	
	public SmartGremlinClient(String name,String server,int interval,String team,String pass,CodeSegment[] codeSegments) throws NoSuchAlgorithmException {
		super(name,server,interval,team,pass);
		this.segments=codeSegments;
		if (segments.length<=2) throw new RuntimeException("2 or less code segments to choose from.");
		int mnd=0;
		for (int t=0;t<segments.length;t++) {
			if (segments[t].isMandatory()) mnd++;
		}
	}
	
	public String generateSource() {
		StringBuffer sb=new StringBuffer();
		//
		int cnt=0;
		//
		for (int t=0;t<segments.length;t++) {
			if (segments[t].isMandatory()) {sb.append(segments[t].getCode());cnt++;}
			else if (Math.random()>0.25) {sb.append(segments[t].getCode());cnt++;}
		}
		//
		System.out.println("Generated source using "+cnt+" out of "+segments.length+" code segments.");		
		//
		return sb.toString();
	}
	
	
	public static List dissectSource(String source) {
		//
		final List codeSegments=new ArrayList();
		//
		SourceCodeParser parser=new SourceCodeParser(source,false);
		//
		// Dissect source and make code segments out of it.
		//
		parser.visit(new StatementVisitor() {
			StringBuffer current=new StringBuffer();
			StringBuffer enumFields=new StringBuffer();
			public void begin() {
			}
			public void beginStatement(AbstractStatement st, int indent, boolean isLast) {
			    checkEnumField(indent);
				for (int t=0;t<indent;t++) current.append(" ");
				current.append(st.getStatement());
				current.append("{");
				current.append("\n");
			}
			public void onStatement(AbstractStatement st, int indent, boolean isLast) {
				//
                if (st.getParent().isEnumStatement()&&st.isFieldStatement()) {
                        FieldStatement fst=(FieldStatement)st;
                        if (fst.getType().equals(((EnumStatement)st.getParent()).getName())) {
                            if (enumFields.length()==0) {
                                enumFields.append(fst.getName());
                            } else {
                                enumFields.append(",");
                                enumFields.append(fst.getName());
                            }
                        } else {
                            //
                            endSegment(true);
                            //
                            checkEnumField(indent);
                            //
                            current.append(st.getStatement());
                            current.append(";");
                            current.append("\n");
                            //
                        }
                } else {
                    //
                    endSegment(true);
                    //
                    checkEnumField(indent);
                    //
                    current.append(st.getStatement());
                    current.append(";");
                    current.append("\n");
                    //
                }
				//
				//
				if ((st.getParent().isMethodStatement()&&
				    (!st.isVariableDeclarationStatement())&&
				    (!st.isReturnStatement()))||(st.isIfStatement())) endSegment(false);
				//				
			}
			public void endStatement(AbstractStatement st, int indent, boolean isLast) {
				//
			    checkEnumField(indent);
			    //
				for (int t=0;t<indent;t++) current.append(" ");
				current.append("}\n");
				//
			}
			protected void checkEnumField(int indent){ 
                if (enumFields.length()>0) {
                    for (int t=0;t<indent;t++) current.append(" ");
                    current.append(enumFields.toString());
                    current.append(";");
                    current.append("\n");
                    enumFields.delete(0, enumFields.length());
                }
			}
			public void end() {
				endSegment(true);
			}
			public void endSegment(boolean mandatory) {
				if (current.length()==0) return;
				CodeSegment cs=new CodeSegment(current.toString(),mandatory);
				codeSegments.add(cs);
				current.delete(0,current.length()-1);
			}
		});
		//
		return codeSegments;
	}
	
	protected static String readSolutionOutOfJar(String jarFile) throws IOException {
		//
		JarFile assignmentJar=new JarFile(new File(jarFile));
		String solution=assignmentJar.getManifest().getMainAttributes().getValue("Solution");
		if (solution==null) {
			System.out.println("Jar File '"+jarFile+"' does not contain a 'Solution' manifest entry.");
			System.exit(1);
		}
		//
		ZipEntry ze=assignmentJar.getEntry(solution);
		if (ze==null) {
			System.out.println("Jar File '"+jarFile+"' does not contain the file '"+solution+"' as indicated by the Manifest.");
			System.exit(1);
		}
		//
		String source=Tool.read(new BufferedReader(new InputStreamReader(assignmentJar.getInputStream(ze))),true);
		//
		return source;
	}

	public static void main(String[] args) throws Throwable {
		if (args.length!=4) {
			System.out.println("SmartGremlinClient : A LoadTesting client for the MOJ Server. ");
			System.out.println("Usage : SmartGremlinClient [server ip address] [interval] [team.properties] [assignment.jar]]");
			System.exit(1);
		}
		//
		String source=readSolutionOutOfJar(args[3]);
		//
		List codeSegments=dissectSource(source);
		//
		TeamProfileList tpl=new TeamProfileList(new File(args[2]));
		//
		for (int t=0;t<tpl.getNumberOfTeams();t++) {
			GremlinClient gc=new SmartGremlinClient("Gremlin#"+t,args[0],Integer.parseInt(args[1]),tpl.getTeamName(t),"Welkom",(CodeSegment[])codeSegments.toArray(new CodeSegment[codeSegments.size()]));
			new Thread(gc).start();
		}
		//		
	}
	
}
