package nl.moj.test.gremlin;

import java.security.NoSuchAlgorithmException;

import nl.ctrlaltdev.util.Tool;

public class HaikuGremlinClient extends GremlinClient {

	public HaikuGremlinClient(String name,String server,int interval,String team,String pass) throws NoSuchAlgorithmException {
		super(name,server,interval,team,pass);
	}
	
	public String generateSource() {
		StringBuffer sb=new StringBuffer();
		//
		sb.append("import java.util.ArrayList;\n");
		sb.append("import java.util.List;\n");
		sb.append("import java.util.StringTokenizer;\n");
		//
		sb.append("public class HaikuCheckerImpl implements HaikuChecker {\n");
		//
		sb.append(" ");
		//
		// Add utility methods in 95 % of the cases.
		//
		if (Math.random()>0.05) {
			//
			sb.append("private static String[] cut(String s) {\n");
			sb.append("	List l=new ArrayList();\n");
			sb.append("	//\n");
			sb.append("	StringTokenizer st=new StringTokenizer(s,\" ,.;!?\");\n");
			sb.append("	while (st.hasMoreTokens()) {\n");
			sb.append("		l.add(st.nextToken());\n");
			sb.append("	}\n");
			sb.append("	//\n");
			sb.append("	return (String[])l.toArray(new String[l.size()]);\n");
			sb.append("}\n");
			//
			sb.append("public int count(String[] words) {\n");
			sb.append("	int r=0;\n");
			sb.append("	for (int t=0;t<words.length;t++) {\n");
			sb.append("		r+=count(words[t]);\n");
			sb.append("	}\n");
			sb.append("	return r;\n");
			sb.append("}\n");
			//
			sb.append("public int count(String word) {\n");
			sb.append("	word=word.toLowerCase();\n");
			sb.append("	String syl=\"aeiou\";\n");
			sb.append("	boolean in=false;\n");
			sb.append("	int cnt=0;\n");
			sb.append("	for (int t=0;t<word.length();t++) {\n");
			sb.append("		if (syl.indexOf(word.charAt(t))>=0) {\n");
			sb.append("			if (!in) {\n");
			sb.append("				in=true;\n");
			sb.append("				cnt++;\n");
			sb.append("			}\n");
			sb.append("		} else {\n");
			sb.append("			in=false;\n");
			sb.append("		}\n");
			sb.append("	}\n");
			sb.append("	//\n");
			sb.append("	if ((cnt==0)&&(word.length()>0)) cnt=1;\n");
			sb.append("	//\n");
			sb.append("	return cnt;\n");
			sb.append("}\n");
			//
			sb.append("public boolean isSeason(String[] words) {\n");
			sb.append("	for (int t=0;t<words.length;t++) {\n");
			sb.append("					for (int s=0;s<SEASONS.length;s++) {\n");
			sb.append("			if (words[t].toLowerCase().indexOf(SEASONS[s])>=0) return true;\n");
			sb.append("		}\n");
			sb.append("	}\n");
			sb.append("	return false;\n");
			sb.append("}\n");
			//
		}
		//
		sb.append("public void check(String[] haiku) throws InvalidHaikuException {\n");
		sb.append("	//\n");
		if (Math.random()>0.5) {
			sb.append("	if (haiku==null) throw new InvalidHaikuException(\"NULL Array.\");\n");
		}
		if (Math.random()>0.5) {
			sb.append("	if (haiku.length!=3) throw new InvalidHaikuException(\"Not 3 lines.\");\n");
		}
		if (Math.random()>0.5) {
			sb.append("	if (haiku[0]==null) throw new InvalidHaikuException(\"NULL Element.\");\n");
			sb.append("	if (haiku[1]==null) throw new InvalidHaikuException(\"NULL Element.\");\n");
			sb.append("	if (haiku[2]==null) throw new InvalidHaikuException(\"NULL Element.\");\n");
		}
		//
		sb.append("	int l1=count(cut(haiku[0]));\n");
		sb.append("	int l2=count(cut(haiku[1]));\n");
		sb.append("	int l3=count(cut(haiku[2]));\n");
		//
		sb.append("	if (l1!=5) throw new InvalidHaikuException(\"First line does not contain 5 syllables\");\n");
		sb.append("	if (l2!=7) throw new InvalidHaikuException(\"Second line does not contain 7 syllables\");\n");
		sb.append("	if (l3!=5) throw new InvalidHaikuException(\"Last line does not contain 5 syllables\");\n");
		//
		if (Math.random()>0.5) {
			sb.append("	if (isSeason(cut(haiku[0]))) return;\n");
			sb.append("	if (isSeason(cut(haiku[1]))) return;\n");
			sb.append("	if (isSeason(cut(haiku[2]))) return;\n");
		}
		//
		sb.append("	throw new InvalidHaikuException(\"No season reference.\");\n");
		sb.append("}\n");
		//
		//
		//
		sb.append(" ");
		//
		sb.append("}\n");
		//
		return sb.toString();
	}
	
	public static void main(String[] args) throws Throwable {
		if (args.length!=4) {
			System.out.println("HaikuGremlinClient : A LoadTesting client for the MOJ Server. ");
			System.out.println("Usage : HaikuGremlinClient [server ip address] [interval] [UserName] [PassWord]");
			System.out.println("        Note : for use with the Haiku Case only.");
			System.exit(0);
		}
		//
		if (args[2].indexOf(',')>=0) {
			String[] names=Tool.cut(args[2],",");
			String[] pwds=Tool.cut(args[3],",");
			if (names.length!=pwds.length) throw new RuntimeException("# of names and passwords dont match : "+names.length+" "+pwds.length);
			for (int t=0;t<names.length;t++) {
				GremlinClient gc=new HaikuGremlinClient("Gremlin#"+t,args[0],Integer.parseInt(args[1]),names[t],pwds[t]);
				new Thread(gc).start();
			}
		} else {
			GremlinClient gc=new HaikuGremlinClient("Gremlin",args[0],Integer.parseInt(args[1]),args[2],args[3]);
			gc.run();
		}
		//		
	}	
	
	
}
