/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.server;

import java.awt.Color;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.net.server.Log;
import nl.ctrlaltdev.net.server.SimpleSocketServer;
import nl.ctrlaltdev.net.server.SocketHandlerFactory;
import nl.ctrlaltdev.util.SimpleLogFormatter;
import nl.moj.process.ProcessPool;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.workspace.WorkspaceClientServerImpl;
import nl.moj.workspace.server.WorkspaceMessageHandler;

public class WorkspaceServer
implements SocketHandlerFactory {
    private SimpleSocketServer mySSS;
    private ProcessPool pool;
    private ApplicationBuilder builder = new ApplicationBuilder();

    public WorkspaceServer(ThreadGroup group, int poolsize) {
        this(group, Integer.parseInt(System.getProperty("MOJ.WORKSPACESERVER.PORT", "8081")), poolsize);
    }

    public WorkspaceServer(ThreadGroup group, int port, int poolsize) {
        try {
            this.pool = new ProcessPool(poolsize);
            this.mySSS = new SimpleSocketServer(port, new Log.JavaUtilLoggerAdapter("WorkspaceServer"), this);
        }
        catch (IOException ex) {
            Logger.getLogger("").log(Level.SEVERE, "Failed opening server socket." + ex);
            throw new RuntimeException("Failed starting Server.");
        }
        new Thread(group, this.mySSS).start();
    }

    @Override
    public Runnable createHandler(Socket s, Log l) {
        return new WorkspaceMessageHandler(s, l, new WorkspaceClientServerImpl(this.pool, this.builder));
    }

    public static void main(String[] args) throws IOException {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8081;
        int poolsize = args.length > 1 ? Integer.parseInt(args[1]) : 32;
        SimpleLogFormatter.clearLogConfig();
        SimpleLogFormatter.addConsoleLogging();
        SimpleLogFormatter.addFileLogging("./WorkspaceServer%u.log");
        SimpleLogFormatter.verbose();
        SimpleLogFormatter.info("java");
        SimpleLogFormatter.info("javax");
        SimpleLogFormatter.info("sun");
        new Color(255, 255, 255);
        ThreadGroup tmp = new ThreadGroup("Tester-ThreadGroup");
        SandboxSecurityManager ssm = new SandboxSecurityManager(tmp);
        System.setSecurityManager(ssm);
        Logger.getLogger("").info("Starting Workspace Server.");
        ThreadGroup group = new ThreadGroup("Server");
        new WorkspaceServer(group, port, poolsize);
    }
}

