/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.anim.Anim;
import nl.moj.client.anim.LayeredAnim;
import nl.moj.model.Tester;
import nl.moj.test.TesterImpl;
import nl.moj.workspace.io.AbstractWorkspaceMessage;
import nl.moj.workspace.io.Message;

public class ProcessStateMessage
extends AbstractWorkspaceMessage
implements Message.ProcessState {
    private int state;
    private String operationName;
    private boolean success;
    private Tester.TestResult tst;

    public ProcessStateMessage(int state, String operationName, boolean success, Tester.TestResult testResults) {
        super(5);
        this.state = state;
        this.operationName = operationName;
        this.success = success;
        this.tst = testResults;
    }

    public ProcessStateMessage(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 5) {
            throw new IOException("Incorrect Type");
        }
        this.state = in.readInt();
        this.operationName = in.readUTF();
        this.success = in.readBoolean();
        if (in.readBoolean()) {
            int rs = in.readInt();
            int[] results = new int[rs];
            for (int t = 0; t < results.length; ++t) {
                results[t] = in.readInt();
            }
            Anim[] anim = null;
            if (in.readBoolean()) {
                int as = in.readInt();
                anim = new Anim[as];
                for (int t = 0; t < anim.length; ++t) {
                    if (in.readBoolean()) {
                        anim[t] = new LayeredAnim();
                        anim[t].read(in);
                        continue;
                    }
                    anim[t] = null;
                }
            }
            this.tst = new TesterImpl.TestResultImpl(results, anim);
        } else {
            this.tst = null;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.state);
        out.writeUTF(this.operationName);
        out.writeBoolean(this.success);
        if (this.tst == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            int[] r = this.tst.getResults();
            out.writeInt(r.length);
            for (int t = 0; t < r.length; ++t) {
                out.writeInt(r[t]);
            }
            Anim[] anim = this.tst.getAnimationOutput();
            if (anim == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(anim.length);
                for (int t = 0; t < anim.length; ++t) {
                    if (anim[t] != null) {
                        out.writeBoolean(true);
                        anim[t].write(out);
                        continue;
                    }
                    out.writeBoolean(false);
                }
            }
        }
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public boolean isQueued() {
        return this.state == 0;
    }

    @Override
    public boolean isExecuting() {
        return this.state == 1;
    }

    @Override
    public boolean isFinished() {
        return this.state == 2;
    }

    @Override
    public boolean wasSuccess() {
        return this.success;
    }

    @Override
    public Tester.TestResult getTestResults() {
        return this.tst;
    }
}

