/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.workspace.io.AbstractWorkspaceMessage;
import nl.moj.workspace.io.Message;

public class ConsoleMessage
extends AbstractWorkspaceMessage
implements Message.Console {
    private String myConsole;
    private String myContent;

    public ConsoleMessage(String console, String content) {
        super(4);
        this.myConsole = console;
        this.myContent = content;
    }

    public ConsoleMessage(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 4) {
            throw new IOException("Incorrect Type");
        }
        this.myConsole = in.readUTF();
        this.myContent = in.readUTF();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myConsole);
        out.writeUTF(this.myContent);
    }

    @Override
    public String getContext() {
        return this.myConsole;
    }

    @Override
    public String getContent() {
        return this.myContent;
    }
}

