/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.workspace.io.AbstractWorkspaceMessage;
import nl.moj.workspace.io.Message;

public class AssignmentMessage
extends AbstractWorkspaceMessage
implements Message.Assignment {
    private String teamName;
    private boolean resumeMode;
    private byte[] jarData;

    public AssignmentMessage(String team, boolean resume, JarFileAssignment jar) throws IOException {
        super(0);
        this.teamName = team;
        this.resumeMode = resume;
        this.jarData = jar.getJarFileData();
    }

    public AssignmentMessage(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 0) {
            throw new IOException("Incorrect Type");
        }
        this.teamName = in.readUTF();
        this.resumeMode = in.readBoolean();
        int ln = in.readInt();
        this.jarData = new byte[ln];
        in.readFully(this.jarData);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.teamName);
        out.writeBoolean(this.resumeMode);
        out.writeInt(this.jarData.length);
        out.write(this.jarData);
    }

    @Override
    public byte[] getJarAssignment() {
        return this.jarData;
    }

    @Override
    public String getTeamName() {
        return this.teamName;
    }

    @Override
    public boolean isResumeMode() {
        return this.resumeMode;
    }
}

