/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.model.Operation;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.process.ProcessPool;
import nl.moj.workspace.LocalWorkspace;
import nl.moj.workspace.WorkspaceClientServer;
import nl.moj.workspace.io.ConsoleMessage;
import nl.moj.workspace.io.ContentsReply;
import nl.moj.workspace.io.Message;
import nl.moj.workspace.io.ProcessStateMessage;

public class WorkspaceClientServerImpl
implements WorkspaceClientServer,
OutputRedirector.Target,
ProcessPool.ProcessListener {
    private static Logger log = Logger.getLogger("WorkspaceCS");
    private ProcessPool processPool;
    private ApplicationBuilder applicationBuilder;
    private LocalWorkspace ws;
    private List msgs = new ArrayList();

    public WorkspaceClientServerImpl(ProcessPool p, ApplicationBuilder b) {
        this.processPool = p;
        this.applicationBuilder = b;
    }

    @Override
    public boolean isInitial() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] onAssignment(Message.Assignment msg) throws Exception {
        log.fine("Copying assignment..");
        File tmp = File.createTempFile("moj", ".jar");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
        try {
            ((OutputStream)out).write(msg.getJarAssignment());
        }
        finally {
            ((OutputStream)out).close();
        }
        log.fine("Reading assignment..");
        JarFileAssignment assignment = new JarFileAssignment(tmp, this.processPool, this.applicationBuilder);
        log.fine("Creating local Workspace..");
        this.ws = new LocalWorkspace(msg.getTeamName(), this, this);
        log.fine("Loading assignment into workspace..");
        this.ws.loadAssignment(assignment, msg.isResumeMode());
        log.info("Workspace created (resume=" + msg.isResumeMode() + ")");
        return this.getAllMsgs();
    }

    @Override
    public Message[] onGoodbye(Message.Goodbye msg) {
        if (msg.isDispose()) {
            log.info("Goodbye - Disposing Workspace.");
        } else {
            log.info("Goodbye - Suspending Workspace.");
        }
        if (msg.isDispose()) {
            this.ws.dispose();
        } else {
            this.ws.suspend();
        }
        return this.getAllMsgs();
    }

    @Override
    public Message[] onNoOp() {
        return this.getAllMsgs();
    }

    @Override
    public Message[] onPerform(Message.Perform msg) {
        Operation op;
        if (!this.ws.isPerforming() && (op = this.ws.getOperationByName(msg.getOperationName())) != null) {
            this.ws.perform(op, msg.getContext());
        }
        return this.getAllMsgs();
    }

    @Override
    public Message[] onRequestContents(Message.ContentsRequest req) throws IOException {
        this.add(new ContentsReply(req.getName(), this.ws.getContents(req.getName())));
        return this.getAllMsgs();
    }

    private synchronized void add(Message msg) {
        this.msgs.add(msg);
    }

    private synchronized Message[] getAllMsgs() {
        Message[] result = this.msgs.toArray(new Message[this.msgs.size()]);
        this.msgs.clear();
        return result;
    }

    @Override
    public void append(String console, String content) {
        this.add(new ConsoleMessage(console == null ? "Output" : console, content));
    }

    @Override
    public void complete(Runnable r) {
        String name = "Unknown";
        boolean success = false;
        Tester.TestResult testResults = null;
        if (r instanceof Team.CompileResults) {
            Team.CompileResults cr = (Team.CompileResults)((Object)r);
            name = cr.getOperation().getName();
            success = cr.wasSuccess();
        } else if (r instanceof Team.TestResults) {
            Team.TestResults tr = (Team.TestResults)((Object)r);
            name = tr.getOperation().getName();
            testResults = tr.getTestResults();
            success = testResults == null ? false : testResults.isOk();
        } else if (r instanceof Team.Results) {
            Team.Results tr = (Team.Results)((Object)r);
            name = tr.getOperation().getName();
        }
        this.add(new ProcessStateMessage(2, name, success, testResults));
    }

    @Override
    public void executing(Runnable r) {
        String name = "Unknown";
        if (r instanceof Team.Results) {
            Team.Results cr = (Team.Results)((Object)r);
            name = cr.getOperation().getName();
        }
        this.add(new ProcessStateMessage(1, name, false, null));
    }

    @Override
    public void queued(Runnable r) {
        String name = "Unknown";
        if (r instanceof Team.Results) {
            Team.Results cr = (Team.Results)((Object)r);
            name = cr.getOperation().getName();
        }
        this.add(new ProcessStateMessage(0, name, false, null));
    }
}

