/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.operation.ContextImpl;
import nl.moj.process.ProcessPool;
import nl.moj.workspace.LoadBalancer;
import nl.moj.workspace.OperationFailedException;
import nl.moj.workspace.io.AssignmentMessage;
import nl.moj.workspace.io.ContentsRequest;
import nl.moj.workspace.io.GoodbyeMessage;
import nl.moj.workspace.io.Message;
import nl.moj.workspace.io.PerformMessage;
import nl.moj.workspace.io.WorkspaceMessageFactory;

public class RemoteWorkspaceClient
implements Workspace {
    private Assignment assignment;
    private Operation[] ops;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private LoadBalancer loadBalancer;
    private String team;
    private WorkspaceMessageFactory factory = new WorkspaceMessageFactory();
    private OutputRedirector.Target target;
    private ProcessPool.ProcessListener pListener;
    private Map localCache = new HashMap();

    public RemoteWorkspaceClient(String team, LoadBalancer lb, OutputRedirector.Target target, ProcessPool.ProcessListener pListener) {
        if (lb == null) {
            throw new NullPointerException("NULL LoadBalancer");
        }
        if (team == null) {
            throw new NullPointerException("NULL Team Name");
        }
        if (target == null) {
            throw new NullPointerException("NULL OutputRedirector.Target");
        }
        if (pListener == null) {
            throw new NullPointerException("NULL ProcessListener");
        }
        this.team = team;
        this.target = target;
        this.pListener = pListener;
        this.loadBalancer = lb;
    }

    public synchronized void connect() throws IOException {
        this.connect(false);
    }

    public synchronized void connect(boolean resume) throws IOException {
        if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
            this.socket = this.loadBalancer.getWorkspaceServerConnection(this.team, resume);
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.target.append(null, "(re)Connected to '" + this.socket.getRemoteSocketAddress() + "'\n");
            if (this.assignment != null) {
                this.target.append(null, "Loading assignment\n");
                this.loadAssignment(this.assignment, true);
                this.target.append(null, "Restoring previous state\n");
                this.performBlocked(this.getOperationByName("Save"), this.getCachedContext());
                this.target.append(null, "Ready.\n");
            }
        }
    }

    public synchronized void forceClose() {
        if (this.socket != null) {
            try {
                this.target.append(null, "Connection closed.\n");
                this.loadBalancer.reportClosing(this.socket);
                this.socket.close();
                this.socket = null;
            }
            catch (IOException ex) {
                throw new OperationFailedException("Error closing Socket", ex);
            }
        }
    }

    @Override
    public String getName() {
        return this.team;
    }

    @Override
    public void loadAssignment(Assignment a, boolean resume) throws IOException {
        if (a == null) {
            throw new NullPointerException("Assignment is NULL");
        }
        this.connect(resume);
        this.assignment = a;
        this.ops = this.assignment.getOperations();
        try {
            new AssignmentMessage(this.team, resume, (JarFileAssignment)a).write(this.out);
            this.out.flush();
        }
        catch (IOException ex) {
            this.loadBalancer.reportFailure(this.socket);
            this.forceClose();
        }
    }

    @Override
    public void perform(Operation op, Operation.Context ctx) {
        try {
            this.connect();
            this.storeInCache(ctx);
            new PerformMessage(op.getName(), ctx).write(this.out);
            this.out.flush();
        }
        catch (IOException ex) {
            this.loadBalancer.reportFailure(this.socket);
            this.forceClose();
            throw new OperationFailedException("Failed sending perform-msg", ex);
        }
    }

    public synchronized void performBlocked(Operation op, Operation.Context ctx) {
        try {
            this.connect();
            this.storeInCache(ctx);
            new PerformMessage(op.getName(), ctx).write(this.out);
            this.out.flush();
            Message.ProcessState result = null;
            while (result == null) {
                try {
                    Message msg = this.factory.createMessage(this.in);
                    if (msg instanceof Message.ProcessState) {
                        result = (Message.ProcessState)msg;
                        if (result.isFinished()) continue;
                        result = null;
                        continue;
                    }
                    this.dispatch(msg);
                }
                catch (SocketTimeoutException ex) {}
            }
        }
        catch (IOException ex) {
            this.loadBalancer.reportFailure(this.socket);
            this.forceClose();
            throw new OperationFailedException("Failed sending perform-msg", ex);
        }
    }

    @Override
    public synchronized String getContents(String file) throws IOException {
        try {
            this.connect();
            new ContentsRequest(file).write(this.out);
            this.out.flush();
            Message.ContentsReply result = null;
            while (result == null) {
                try {
                    Message msg = this.factory.createMessage(this.in);
                    if (msg instanceof Message.ContentsReply) {
                        result = (Message.ContentsReply)msg;
                        if (this.isReadOnly(file)) continue;
                        this.storeInCache(file, result.getContents());
                        continue;
                    }
                    this.dispatch(msg);
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
            return result.getContents();
        }
        catch (IOException ex) {
            this.loadBalancer.reportFailure(this.socket);
            this.forceClose();
            throw new OperationFailedException("Failed sending getContents-msg", ex);
        }
    }

    @Override
    public void dispose() {
        try {
            this.connect();
            new GoodbyeMessage(true).write(this.out);
            this.out.flush();
        }
        catch (IOException ex) {
            this.loadBalancer.reportFailure(this.socket);
            this.forceClose();
            throw new OperationFailedException("Failed disposing of workspace.");
        }
    }

    @Override
    public void suspend() {
        try {
            this.connect();
            new GoodbyeMessage(false).write(this.out);
            this.out.flush();
        }
        catch (IOException ex) {
            this.loadBalancer.reportFailure(this.socket);
            this.forceClose();
            throw new OperationFailedException("Failed suspending of workspace.");
        }
    }

    @Override
    public synchronized void update() throws IOException {
        try {
            this.connect();
            while (this.in.available() > 0) {
                Message msg = this.factory.createMessage(this.in);
                this.dispatch(msg);
            }
        }
        catch (SocketTimeoutException ex) {
        }
        catch (IOException ex) {
            this.loadBalancer.reportFailure(this.socket);
            this.forceClose();
        }
    }

    protected void dispatch(Message msg) {
        switch (msg.getType()) {
            case 4: {
                this.target.append(((Message.Console)msg).getContext(), ((Message.Console)msg).getContent());
                break;
            }
            case 5: {
                Message.ProcessState pst = (Message.ProcessState)msg;
                Operation op = this.getOperationByName(pst.getOperationName());
                ProcessResults r = null;
                r = op != null ? (pst.getTestResults() != null ? new TestResults(op, pst.getTestResults()) : new CompileResults(op, pst.wasSuccess())) : new ProcessResults(op);
                if (pst.isQueued()) {
                    this.pListener.queued(r);
                    break;
                }
                if (pst.isExecuting()) {
                    this.pListener.executing(r);
                    break;
                }
                if (!pst.isFinished()) break;
                this.pListener.complete(r);
            }
        }
    }

    @Override
    public Operation[] getAllOperations() {
        return this.ops;
    }

    @Override
    public Operation getOperationByName(String name) {
        for (int t = 0; t < this.ops.length; ++t) {
            if (!this.ops[t].getName().equals(name)) continue;
            return this.ops[t];
        }
        return null;
    }

    @Override
    public boolean isJava(String file) {
        if (file == null) {
            return false;
        }
        return file.endsWith(".java");
    }

    @Override
    public boolean isMonospaced(String file) {
        if (file == null) {
            return false;
        }
        if (!file.endsWith(".txt")) {
            return false;
        }
        return this.assignment.isDescriptionRenderedInMonospaceFont();
    }

    @Override
    public boolean isReadOnly(String file) {
        String[] names = this.assignment.getEditableFileNames();
        for (int t = 0; t < names.length; ++t) {
            if (!names[t].equals(file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] getEditorFiles() {
        ArrayList<String> r = new ArrayList<String>();
        r.addAll(Arrays.asList(this.assignment.getDescriptionFileNames()));
        r.addAll(Arrays.asList(this.assignment.getSourceCodeFileNames()));
        return r.toArray(new String[r.size()]);
    }

    protected synchronized void storeInCache(String file, String contents) {
        this.localCache.put(file, contents);
    }

    protected synchronized void storeInCache(Operation.Context ctx) {
        String[] names = ctx.getNames();
        for (int t = 0; t < names.length; ++t) {
            String content = ctx.getContents(names[t]);
            this.storeInCache(names[t], content);
        }
    }

    protected synchronized Operation.Context getCachedContext() {
        String[] names = new String[this.localCache.size()];
        String[] values = new String[this.localCache.size()];
        names = this.localCache.keySet().toArray(names);
        for (int t = 0; t < names.length; ++t) {
            values[t] = (String)this.localCache.get(names[t]);
        }
        return new ContextImpl(names, values, -1);
    }

    public static class CompileResults
    extends ProcessResults
    implements Team.CompileResults {
        private boolean success;

        public CompileResults(Operation op, boolean success) {
            super(op);
            this.success = success;
        }

        @Override
        public boolean wasSuccess() {
            return this.success;
        }

        @Override
        public void run() {
        }
    }

    public static class TestResults
    extends ProcessResults
    implements Team.TestResults {
        private Tester.TestResult tr;

        public TestResults(Operation op, Tester.TestResult tr) {
            super(op);
            this.tr = tr;
        }

        @Override
        public Tester.TestResult getTestResults() {
            return this.tr;
        }

        @Override
        public void run() {
        }
    }

    public static class ProcessResults
    implements Runnable,
    Team.Results {
        private Operation op;

        public ProcessResults(Operation op) {
            this.op = op;
        }

        @Override
        public Operation getOperation() {
            return this.op;
        }

        @Override
        public void run() {
        }
    }
}

