/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.test.gremlin;

import java.security.NoSuchAlgorithmException;
import nl.ctrlaltdev.util.Tool;
import nl.moj.test.gremlin.GremlinClient;

public class HaikuGremlinClient
extends GremlinClient {
    public HaikuGremlinClient(String name, String server, int interval, String team, String pass) throws NoSuchAlgorithmException {
        super(name, server, interval, team, pass);
    }

    @Override
    public String generateSource() {
        StringBuffer sb = new StringBuffer();
        sb.append("import java.util.ArrayList;\n");
        sb.append("import java.util.List;\n");
        sb.append("import java.util.StringTokenizer;\n");
        sb.append("public class HaikuCheckerImpl implements HaikuChecker {\n");
        sb.append(" ");
        if (Math.random() > 0.05) {
            sb.append("private static String[] cut(String s) {\n");
            sb.append("\tList l=new ArrayList();\n");
            sb.append("\t//\n");
            sb.append("\tStringTokenizer st=new StringTokenizer(s,\" ,.;!?\");\n");
            sb.append("\twhile (st.hasMoreTokens()) {\n");
            sb.append("\t\tl.add(st.nextToken());\n");
            sb.append("\t}\n");
            sb.append("\t//\n");
            sb.append("\treturn (String[])l.toArray(new String[l.size()]);\n");
            sb.append("}\n");
            sb.append("public int count(String[] words) {\n");
            sb.append("\tint r=0;\n");
            sb.append("\tfor (int t=0;t<words.length;t++) {\n");
            sb.append("\t\tr+=count(words[t]);\n");
            sb.append("\t}\n");
            sb.append("\treturn r;\n");
            sb.append("}\n");
            sb.append("public int count(String word) {\n");
            sb.append("\tword=word.toLowerCase();\n");
            sb.append("\tString syl=\"aeiou\";\n");
            sb.append("\tboolean in=false;\n");
            sb.append("\tint cnt=0;\n");
            sb.append("\tfor (int t=0;t<word.length();t++) {\n");
            sb.append("\t\tif (syl.indexOf(word.charAt(t))>=0) {\n");
            sb.append("\t\t\tif (!in) {\n");
            sb.append("\t\t\t\tin=true;\n");
            sb.append("\t\t\t\tcnt++;\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t} else {\n");
            sb.append("\t\t\tin=false;\n");
            sb.append("\t\t}\n");
            sb.append("\t}\n");
            sb.append("\t//\n");
            sb.append("\tif ((cnt==0)&&(word.length()>0)) cnt=1;\n");
            sb.append("\t//\n");
            sb.append("\treturn cnt;\n");
            sb.append("}\n");
            sb.append("public boolean isSeason(String[] words) {\n");
            sb.append("\tfor (int t=0;t<words.length;t++) {\n");
            sb.append("\t\t\t\t\tfor (int s=0;s<SEASONS.length;s++) {\n");
            sb.append("\t\t\tif (words[t].toLowerCase().indexOf(SEASONS[s])>=0) return true;\n");
            sb.append("\t\t}\n");
            sb.append("\t}\n");
            sb.append("\treturn false;\n");
            sb.append("}\n");
        }
        sb.append("public void check(String[] haiku) throws InvalidHaikuException {\n");
        sb.append("\t//\n");
        if (Math.random() > 0.5) {
            sb.append("\tif (haiku==null) throw new InvalidHaikuException(\"NULL Array.\");\n");
        }
        if (Math.random() > 0.5) {
            sb.append("\tif (haiku.length!=3) throw new InvalidHaikuException(\"Not 3 lines.\");\n");
        }
        if (Math.random() > 0.5) {
            sb.append("\tif (haiku[0]==null) throw new InvalidHaikuException(\"NULL Element.\");\n");
            sb.append("\tif (haiku[1]==null) throw new InvalidHaikuException(\"NULL Element.\");\n");
            sb.append("\tif (haiku[2]==null) throw new InvalidHaikuException(\"NULL Element.\");\n");
        }
        sb.append("\tint l1=count(cut(haiku[0]));\n");
        sb.append("\tint l2=count(cut(haiku[1]));\n");
        sb.append("\tint l3=count(cut(haiku[2]));\n");
        sb.append("\tif (l1!=5) throw new InvalidHaikuException(\"First line does not contain 5 syllables\");\n");
        sb.append("\tif (l2!=7) throw new InvalidHaikuException(\"Second line does not contain 7 syllables\");\n");
        sb.append("\tif (l3!=5) throw new InvalidHaikuException(\"Last line does not contain 5 syllables\");\n");
        if (Math.random() > 0.5) {
            sb.append("\tif (isSeason(cut(haiku[0]))) return;\n");
            sb.append("\tif (isSeason(cut(haiku[1]))) return;\n");
            sb.append("\tif (isSeason(cut(haiku[2]))) return;\n");
        }
        sb.append("\tthrow new InvalidHaikuException(\"No season reference.\");\n");
        sb.append("}\n");
        sb.append(" ");
        sb.append("}\n");
        return sb.toString();
    }

    public static void main(String[] args) throws Throwable {
        if (args.length != 4) {
            System.out.println("HaikuGremlinClient : A LoadTesting client for the MOJ Server. ");
            System.out.println("Usage : HaikuGremlinClient [server ip address] [interval] [UserName] [PassWord]");
            System.out.println("        Note : for use with the Haiku Case only.");
            System.exit(0);
        }
        if (args[2].indexOf(44) >= 0) {
            String[] pwds;
            String[] names = Tool.cut(args[2], ",");
            if (names.length != (pwds = Tool.cut(args[3], ",")).length) {
                throw new RuntimeException("# of names and passwords dont match : " + names.length + " " + pwds.length);
            }
            for (int t = 0; t < names.length; ++t) {
                HaikuGremlinClient gc = new HaikuGremlinClient("Gremlin#" + t, args[0], Integer.parseInt(args[1]), names[t], pwds[t]);
                new Thread(gc).start();
            }
        } else {
            HaikuGremlinClient gc = new HaikuGremlinClient("Gremlin", args[0], Integer.parseInt(args[1]), args[2], args[3]);
            gc.run();
        }
    }
}

