/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.test.gremlin;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import nl.ctrlaltdev.util.Encoder;
import nl.moj.client.io.ActionMessageImpl;
import nl.moj.client.io.HelloMessageImpl;
import nl.moj.client.io.Message;
import nl.moj.client.io.MessageFactory;

public abstract class GremlinClient
implements Runnable {
    private static double CHANCETEST = 0.4;
    private static double CHANCEINDIVIDUALTESTSET = 0.5;
    private Socket mySocket;
    private DataInput myDataInput;
    private DataOutput myDataOutput;
    private String myServer;
    private String myTeam;
    private String myPass;
    private String myName;
    private MessageFactory myFactory = new MessageFactory();
    private int testSetCount = 0;
    private double myInterval;
    private String theFile;

    public GremlinClient(String name, String server, int interval, String team, String pass) throws NoSuchAlgorithmException {
        this.myName = name;
        this.myServer = server;
        this.myTeam = team;
        this.myPass = Encoder.hash(pass);
        this.myInterval = interval;
        System.out.println("** Do not Fear, " + name + " is here! **");
    }

    protected synchronized void newConnection() throws IOException {
        this.mySocket = new Socket(this.myServer, 8080);
        this.myDataInput = new DataInputStream(this.mySocket.getInputStream());
        this.myDataOutput = new DataOutputStream(this.mySocket.getOutputStream());
        new HelloMessageImpl(this.myTeam, this.myPass).write(this.myDataOutput);
    }

    protected synchronized DataInput getDataInput() throws IOException {
        if (this.mySocket == null || !this.mySocket.isConnected()) {
            this.newConnection();
        }
        return this.myDataInput;
    }

    protected synchronized DataOutput getDataOutput() throws IOException {
        if (this.mySocket == null || !this.mySocket.isConnected()) {
            this.newConnection();
        }
        return this.myDataOutput;
    }

    public abstract String generateSource();

    @Override
    public void run() {
        int time = 0;
        int lastTime = 0;
        int nextTime = 0;
        try {
            Thread.sleep((int)(500.0 * Math.random()));
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        boolean goOn = true;
        block15: while (goOn) {
            try {
                DataInput in = this.getDataInput();
                if (time <= nextTime && time != lastTime && this.testSetCount >= 0 && this.theFile != null) {
                    String action;
                    nextTime = time - (5 + (int)(this.myInterval * Math.random()));
                    lastTime = time;
                    String data = this.generateSource();
                    int idx = -1;
                    if (Math.random() > CHANCETEST) {
                        action = "Compile";
                    } else if ((double)time < 60.0 * Math.random()) {
                        action = "Submit";
                    } else {
                        action = "Test";
                        if (Math.random() < CHANCEINDIVIDUALTESTSET && (idx = (int)(Math.random() * (double)this.testSetCount)) == this.testSetCount) {
                            --idx;
                        }
                    }
                    DataOutput out = this.getDataOutput();
                    System.out.println(this.myName + " Performing " + action + " " + idx);
                    new ActionMessageImpl(this.theFile, data, action, idx, 64).write(out);
                    ((DataOutputStream)out).flush();
                }
                Message msg = this.myFactory.createMessage(in);
                switch (msg.getType()) {
                    case 2: {
                        Message.Console con = (Message.Console)msg;
                        System.out.println(this.myName + " Console : " + con.getContent());
                        continue block15;
                    }
                    case 1: {
                        Message.Editor ed = (Message.Editor)msg;
                        if (!ed.isReadOnly()) {
                            this.theFile = ed.getFileName();
                        }
                        System.out.println(this.myName + " Editor : " + ed.getFileName());
                        continue block15;
                    }
                    case 6: {
                        Message.AddAction add = (Message.AddAction)msg;
                        System.out.println(this.myName + " Add action : " + add.getAction());
                        continue block15;
                    }
                    case 4: {
                        Message.UpdateClientStatistics upd = (Message.UpdateClientStatistics)msg;
                        System.out.println(this.myName + " Update : " + upd.getSecondsRemaining());
                        time = upd.getSecondsRemaining();
                        if (nextTime != 0) continue block15;
                        nextTime = time - 10 - (int)(this.myInterval * Math.random());
                        continue block15;
                    }
                    case 8: {
                        Message.TestSet tstset = (Message.TestSet)msg;
                        this.testSetCount = tstset.getCount();
                        continue block15;
                    }
                    case 7: {
                        System.out.println(this.myName + " Unknown user or password");
                        goOn = false;
                        continue block15;
                    }
                    case 9: {
                        System.out.println(this.myName + " Protocol version mismatch.");
                        goOn = false;
                        continue block15;
                    }
                    case 10: {
                        continue block15;
                    }
                    case 13: {
                        continue block15;
                    }
                }
                throw new IOException(this.myName + " UnExcpected Message : " + msg.getType());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                goOn = false;
            }
        }
    }
}

