/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.test;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.ctrlaltdev.util.Tool;
import nl.moj.client.anim.Anim;
import nl.moj.model.Assignment;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.security.SandboxClassLoader;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.FileArrayClassLoader;
import nl.moj.test.JarClassLoader;

public class TesterImpl
implements Tester {
    private static final Logger log = Logger.getLogger("Tester");
    private static final int[] TESTFAILED = new int[]{-1};
    public static final int TESTTIMEOUT = 1000;
    private Assignment myAssignment;
    private ThreadGroup myTesterThreadGroup;
    private File myTesterJarFile;
    private File[] myTesterClassFiles;
    private String myTesterClassName;
    private int myTimeout;
    private String[] myPrefetchNames;
    private String[] myPrefetchDescriptions;

    public TesterImpl(Assignment a, String testerClassName, File jarFile, int timeout) throws IOException, ClassNotFoundException {
        if (a == null) {
            throw new NullPointerException("NULL assingment.");
        }
        if (jarFile == null) {
            throw new NullPointerException("jarFile is null.");
        }
        if (testerClassName == null) {
            throw new NullPointerException("testerClassName is null.");
        }
        if (!jarFile.exists()) {
            throw new IOException("The jarFile " + jarFile.getAbsolutePath() + " does not exist.");
        }
        this.myAssignment = a;
        this.myTimeout = timeout;
        this.myTesterClassName = testerClassName;
        this.myTesterJarFile = jarFile;
        this.prepare();
        this.prefetch();
    }

    public TesterImpl(Assignment a, String testerClassName, File[] classFiles, int timeout) throws IOException, ClassNotFoundException {
        if (a == null) {
            throw new NullPointerException("NULL assingment.");
        }
        if (classFiles == null) {
            throw new NullPointerException("classFiles are null.");
        }
        if (testerClassName == null) {
            throw new NullPointerException("testerClassName is null.");
        }
        this.myAssignment = a;
        this.myTimeout = timeout;
        this.myTesterClassName = testerClassName;
        this.myTesterJarFile = null;
        this.myTesterClassFiles = classFiles;
        this.prepare();
        this.prefetch();
    }

    private void prepare() {
        if (!(System.getSecurityManager() instanceof SandboxSecurityManager)) {
            throw new RuntimeException("SandboxSecurityManager not installed.");
        }
        this.myTesterThreadGroup = ((SandboxSecurityManager)System.getSecurityManager()).getEvilThreadGroup(this.myAssignment);
    }

    private ClassLoader createTesterClassLoader(ClassLoader parent) throws IOException {
        if (this.myTesterJarFile != null) {
            return new JarClassLoader(new JarFile(this.myTesterJarFile), parent);
        }
        if (this.myTesterClassFiles != null) {
            return new FileArrayClassLoader(this.myTesterClassFiles, parent, true);
        }
        throw new RuntimeException("Unable to createTesterClassloader.");
    }

    private void prefetch() {
        try {
            ClassLoader myTesterClassLoader = this.createTesterClassLoader(this.getClass().getClassLoader());
            Class<?> myTesterClass = myTesterClassLoader.loadClass(this.myTesterClassName);
            Tester.Testable tst = (Tester.Testable)myTesterClass.newInstance();
            int nr = tst.getTestCount();
            this.myPrefetchNames = new String[nr];
            this.myPrefetchDescriptions = new String[nr];
            for (int t = 0; t < nr; ++t) {
                this.myPrefetchNames[t] = tst.getTestName(t);
                if (this.myPrefetchNames[t] == null) {
                    throw new NullPointerException("Name of TestCase #" + t + " is NULL.");
                }
                this.myPrefetchDescriptions[t] = tst.getTestDescription(t);
                if (this.myPrefetchDescriptions[t] != null) continue;
                throw new NullPointerException("Description of TestCase #" + t + " is NULL.");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error prefetching test names and descriptions.", ex);
        }
    }

    @Override
    public String[] getTestDescriptions() {
        return (String[])Tool.copy(this.myPrefetchDescriptions);
    }

    @Override
    public String[] getTestNames() {
        return (String[])Tool.copy(this.myPrefetchNames);
    }

    @Override
    public Tester.TestResult performTest(Workspace.Internal workspace, int idx) throws Exception {
        if (workspace == null) {
            throw new NullPointerException("Workspace is NULL.");
        }
        String workspaceName = workspace.getName();
        SandboxClassLoader mySubjectClassLoader = new SandboxClassLoader(workspace, this.myTesterThreadGroup, Boolean.getBoolean("MOJ.ECLIPSEPLUGIN"));
        ClassLoader myTesterClassLoader = this.createTesterClassLoader(mySubjectClassLoader);
        Class<?> myTesterClass = myTesterClassLoader.loadClass(this.myTesterClassName);
        TestRunner runner = new TestRunner(myTesterClass, idx);
        Thread thread = new Thread(this.myTesterThreadGroup, runner, workspaceName + "-Tester");
        OutputRedirector.getSingleton().redirect(thread, workspace.getTarget());
        log.log(Level.INFO, "Starting test : " + workspaceName);
        thread.start();
        int tmo = 0;
        while (thread.isAlive()) {
            try {
                if (tmo > this.myTimeout) break;
                ++tmo;
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {}
        }
        if (thread.isAlive()) {
            ((TestResultImpl)runner.getResult()).setScore(TESTFAILED);
            log.log(Level.INFO, "Test TimedOut : " + workspaceName);
            thread.stop();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        } else {
            log.log(Level.INFO, "Test Ended : " + workspaceName);
        }
        OutputRedirector.getSingleton().cancel(thread);
        return runner.getResult();
    }

    @Override
    public Tester.TestResult performTest(Workspace.Internal tm) throws Exception {
        return this.performTest(tm, -1);
    }

    private static class TestRunner
    implements Runnable {
        private boolean done;
        private TestResultImpl result = new TestResultImpl();
        private Tester.Testable myTestable;
        private int idx;

        TestRunner(Class c, int idx) {
            Class myTesterClass = c;
            this.idx = idx;
            if (myTesterClass == null) {
                throw new NullPointerException("Tester class is null.");
            }
            try {
                this.myTestable = (Tester.Testable)myTesterClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to instantiate tester : ", ex);
            }
            if (idx >= 0 && idx >= this.myTestable.getTestCount()) {
                throw new RuntimeException("Incorrect test #" + idx);
            }
        }

        private void redirectOutput(int testNr) {
            OutputRedirector.getSingleton().setContext(String.valueOf(testNr));
        }

        private void cancelRedirection() {
            OutputRedirector.getSingleton().setContext(null);
        }

        private void performAllTests(Tester.Testable tst, int[] results, Anim[] output) throws Throwable {
            Random rnd = new Random();
            boolean[] did = new boolean[tst.getTestCount()];
            for (int t = 0; t < did.length; ++t) {
                int nxt = -1;
                while (did[nxt = rnd.nextInt(did.length)]) {
                }
                this.redirectOutput(nxt);
                this.performSingleTest(tst, nxt, results, output);
                did[nxt] = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performSingleTest(Tester.Testable tst, int idx, int[] results, Anim[] output) throws Throwable {
            this.redirectOutput(idx);
            try {
                results[idx] = tst instanceof Tester.AnimatedTestable ? (((Tester.AnimatedTestable)tst).performTest(idx, output) ? 1 : -1) : (tst.performTest(idx) ? 1 : -1);
            }
            finally {
                this.cancelRedirection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Anim[] output = new Anim[this.myTestable.getTestCount()];
                int[] results = new int[this.myTestable.getTestCount()];
                if (this.idx < 0) {
                    this.performAllTests(this.myTestable, results, output);
                } else {
                    this.performSingleTest(this.myTestable, this.idx, results, output);
                }
                this.result.setScore(results, output);
            }
            catch (Throwable t) {
                this.result.setScore(TESTFAILED);
                System.out.println("Test Aborted because of : " + t.getClass().getName());
                t.printStackTrace(System.out);
            }
            finally {
                this.done = true;
            }
        }

        public Tester.TestResult getResult() {
            return this.result;
        }

        boolean isDone() {
            return this.done;
        }
    }

    public static class TestResultImpl
    implements Tester.TestResult {
        private int[] score = null;
        private Anim[] output = null;

        public TestResultImpl() {
        }

        public TestResultImpl(int[] score, Anim[] anim) {
            this();
            this.setScore(score, anim);
        }

        void setScore(int[] score) {
            if (this.score == null) {
                this.score = score;
            }
        }

        void setScore(int[] score, Anim[] anim) {
            if (this.score == null) {
                this.score = score;
                if (this.output == null) {
                    this.output = anim;
                }
            }
        }

        @Override
        public Anim[] getAnimationOutput() {
            if (this.output == null) {
                return new Anim[0];
            }
            return this.output;
        }

        @Override
        public boolean[] getScore() {
            if (this.score == null) {
                return new boolean[0];
            }
            boolean[] copy = new boolean[this.score.length];
            for (int t = 0; t < this.score.length; ++t) {
                copy[t] = this.score[t] == 1;
            }
            return copy;
        }

        @Override
        public int[] getResults() {
            if (this.score == null) {
                return new int[0];
            }
            int[] copy = new int[this.score.length];
            for (int t = 0; t < this.score.length; ++t) {
                copy[t] = this.score[t];
            }
            return copy;
        }

        @Override
        public boolean isUnknown() {
            return this.score == null;
        }

        @Override
        public boolean isFaulty() {
            if (this.score == null) {
                return false;
            }
            for (int t = 0; t < this.score.length; ++t) {
                if (this.score[t] != -1) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isOk() {
            if (this.score == null) {
                return false;
            }
            for (int t = 0; t < this.score.length; ++t) {
                if (this.score[t] != -1) continue;
                return false;
            }
            return true;
        }
    }
}

