/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileArrayClassLoader
extends ClassLoader {
    private File[] myFiles;
    private byte[][] prefetchData;

    public FileArrayClassLoader(File[] f) {
        this.myFiles = f;
    }

    public FileArrayClassLoader(File[] f, ClassLoader parent) {
        super(parent);
        this.myFiles = f;
    }

    public FileArrayClassLoader(File[] f, ClassLoader parent, boolean prefetch) {
        super(parent);
        this.myFiles = f;
        if (prefetch) {
            this.prefetch();
        }
    }

    protected void prefetch() {
        this.prefetchData = new byte[this.myFiles.length][];
        for (int t = 0; t < this.myFiles.length; ++t) {
            try {
                if (this.myFiles[t] == null) continue;
                this.prefetchData[t] = this.loadClassData(this.myFiles[t]);
                continue;
            }
            catch (IOException ex) {
                throw new RuntimeException("Prefetch Failed for : " + this.myFiles[t]);
            }
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        try {
            File f = this.findFileEntry(name);
            if (f == null) {
                throw new ClassNotFoundException(name);
            }
            byte[] b = this.loadClassData(f);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(name);
        }
    }

    private File findFileEntry(String name) {
        name = name.replace('.', '/') + ".class";
        for (int t = 0; t < this.myFiles.length; ++t) {
            if (this.myFiles[t] == null || !this.myFiles[t].getAbsolutePath().endsWith(name)) continue;
            return this.myFiles[t];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(File f) throws IOException {
        if (this.prefetchData != null) {
            for (int t = 0; t < this.myFiles.length; ++t) {
                if (!f.equals(this.myFiles[t]) || this.prefetchData[t] == null) continue;
                return this.prefetchData[t];
            }
        }
        byte[] data = new byte[(int)f.length()];
        FileInputStream in = new FileInputStream(f);
        try {
            int cnt;
            int pos = 0;
            do {
                if ((cnt = ((InputStream)in).read(data, pos, data.length - pos)) >= 0) continue;
                throw new IOException("Not enough bytes.");
            } while ((pos += cnt) < data.length);
        }
        finally {
            ((InputStream)in).close();
        }
        return data;
    }
}

