/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.sfx;

import java.io.File;
import nl.ctrlaltdev.sound.SoundPlayer;
import nl.moj.model.Clock;

public class SoundEffects
implements Clock.Notification {
    private SoundPlayer myPlayer;

    public SoundEffects() {
        try {
            this.myPlayer = new SoundPlayer(200L);
        }
        catch (SoundPlayer.SoundPlayerException ex) {
            this.myPlayer = null;
        }
    }

    @Override
    public void clockStarted() {
        if (this.myPlayer != null) {
            try {
                this.myPlayer.play(new File("./data/sfx/gong.wav"));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    @Override
    public void clockStopped() {
        if (this.myPlayer != null) {
            try {
                this.myPlayer.play(new File("./data/sfx/gong.wav"));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    @Override
    public void minutePassed(int remaining) {
        if (this.myPlayer != null) {
            try {
                if (remaining <= 5 && remaining != 0) {
                    this.myPlayer.play(new File("./data/sfx/alarm.wav"));
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    public void submitFailed() {
        if (this.myPlayer != null) {
            try {
                this.myPlayer.play(new File("./data/sfx/buzzer.wav"));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    public void submitSuccess() {
        if (this.myPlayer != null) {
            try {
                this.myPlayer.play(new File("./data/sfx/dowah.wav"));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    @Override
    public void clockReset() {
    }

    @Override
    public void clockFinished() {
    }
}

