/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.server;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nl.ctrlaltdev.net.server.Log;
import nl.moj.client.anim.Anim;
import nl.moj.client.io.AddActionMessageImpl;
import nl.moj.client.io.AnimationMessageImpl;
import nl.moj.client.io.ConsoleMessageImpl;
import nl.moj.client.io.EditorMessageImpl;
import nl.moj.client.io.LogonFailureMessageImpl;
import nl.moj.client.io.Message;
import nl.moj.client.io.MessageFactory;
import nl.moj.client.io.ProtocolVersionMismatchMessageImpl;
import nl.moj.client.io.TestSetMessageImpl;
import nl.moj.client.io.UpdateClientStatisticsMessageImpl;
import nl.moj.model.Operation;
import nl.moj.model.Round;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.operation.ContextImpl;
import nl.moj.operation.Test;

public class MessageHandler
implements Runnable {
    private MessageFactory factory = new MessageFactory();
    private Socket mySocket;
    private DataOutputStream out;
    private DataInputStream in;
    private Log myLog;
    private Round myRound;
    private Team myTeam;

    public MessageHandler(Socket s, Log l, Round rnd) {
        try {
            this.mySocket = s;
            this.myLog = l;
            this.myRound = rnd;
            s.setSoTimeout(1000);
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.in = new DataInputStream(s.getInputStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean loginOk = false;
        try {
            Team t;
            UpdateClientStatisticsMessageImpl up = new UpdateClientStatisticsMessageImpl(0, 3600, 3600, 0, this.myRound.getTeamsOnline(), this.myRound.getTeamCount(), null);
            up.write(this.out);
            Message msg = this.factory.createMessage(this.in);
            if (msg.getType() == 0) {
                Message.Hello hello = (Message.Hello)msg;
                if (hello.getProtocolVersion() != 2007111001) {
                    new ProtocolVersionMismatchMessageImpl().write(this.out);
                    this.out.flush();
                    throw new IOException("Protocol version mismatch for Team " + hello.getTeamName());
                }
                t = this.myRound.getTeamByName(hello.getTeamName());
                if (t != null && t.isOnline()) {
                    return;
                }
                if (t == null || !t.isValidPassword(hello.getPassword())) {
                    this.myLog.warn("Logon Failure for Team " + hello.getTeamName());
                    new ConsoleMessageImpl("ERROR", "Invalid username and password combination.").write(this.out);
                    new LogonFailureMessageImpl().write(this.out);
                    this.out.flush();
                    throw new IOException("Authentication Failed.");
                }
            } else {
                throw new IOException("No Hello, No Game.");
            }
            this.myTeam = t;
            loginOk = true;
            this.out.flush();
            while (this.myTeam.isWaiting()) {
                msg = new UpdateClientStatisticsMessageImpl(0, this.myTeam.getClock().getDuration(), this.myTeam.getClock().getSecondsRemaining(), 0, this.myRound.getTeamsOnline(), this.myRound.getTeamCount(), null);
                msg.write(this.out);
                this.out.flush();
                try {
                    msg = this.factory.createMessage(this.in);
                }
                catch (SocketTimeoutException ex) {}
            }
            if (!this.myTeam.isFinished()) {
                int t2;
                Workspace ws = this.myTeam.getWorkspace();
                String[] editorFiles = ws.getEditorFiles();
                for (int t3 = 0; t3 < editorFiles.length; ++t3) {
                    String current = editorFiles[t3];
                    if (ws.isJava(current)) continue;
                    EditorMessageImpl ed = new EditorMessageImpl(current, ws.getContents(current), ws.isJava(current), ws.isReadOnly(current), ws.isMonospaced(current));
                    ed.write(this.out);
                }
                Tester tester = null;
                Operation[] ops = this.myRound.getAssignment().getOperations();
                for (t2 = 0; t2 < ops.length; ++t2) {
                    msg = new AddActionMessageImpl(ops[t2].getName(), ops[t2].needsConfirm(), ops[t2].getTooltip());
                    msg.write(this.out);
                    if (!(ops[t2] instanceof Test)) continue;
                    tester = ((Test)ops[t2]).getTester();
                }
                if (tester != null) {
                    msg = new TestSetMessageImpl(tester.getTestNames(), tester.getTestDescriptions());
                    msg.write(this.out);
                }
                for (t2 = 0; t2 < editorFiles.length; ++t2) {
                    String current = editorFiles[t2];
                    if (!ws.isJava(current)) continue;
                    EditorMessageImpl ed = new EditorMessageImpl(current, ws.getContents(current), ws.isJava(current), ws.isReadOnly(current), ws.isMonospaced(current));
                    ed.write(this.out);
                }
                msg = new ConsoleMessageImpl("Output", "The game has begun.");
                msg.write(this.out);
                this.out.flush();
                block27: while (!this.myTeam.isFinished()) {
                    int[] testResults = this.myTeam.getTestResults();
                    Anim[] testAnimResults = this.myTeam.getAnimatedTestResults();
                    msg = new UpdateClientStatisticsMessageImpl(0, this.myTeam.getClock().getDuration(), this.myTeam.getClock().getSecondsRemaining(), 1, this.myRound.getTeamsOnline(), this.myRound.getTeamCount(), testResults);
                    msg.write(this.out);
                    if (testResults != null && testAnimResults != null) {
                        for (int t4 = 0; t4 < testAnimResults.length; ++t4) {
                            if (testAnimResults[t4] == null) continue;
                            msg = new AnimationMessageImpl(t4, testAnimResults[t4]);
                            msg.write(this.out);
                        }
                    }
                    String[][] l = this.myTeam.getLines();
                    for (int t5 = 0; t5 < l.length; ++t5) {
                        msg = new ConsoleMessageImpl(l[t5][0] == null ? "Output" : l[t5][0], l[t5][1]);
                        msg.write(this.out);
                    }
                    this.out.flush();
                    try {
                        msg = this.factory.createMessage(this.in);
                        switch (msg.getType()) {
                            case 3: {
                                Message.Action action = (Message.Action)msg;
                                ops = this.myRound.getAssignment().getOperations();
                                for (int t6 = 0; t6 < ops.length; ++t6) {
                                    if (!ops[t6].getName().equals(action.getAction())) continue;
                                    this.myTeam.doOperation(ops[t6], new ContextImpl(action.getFileName(), action.getContents(), action.getIndex()));
                                    this.myTeam.addStatistics(action.getKeyStrokes(), action.getAction(), action.getContents().length());
                                }
                                continue block27;
                            }
                            default: {
                                throw new IOException("Unknown message type : " + msg.getType());
                            }
                        }
                    }
                    catch (SocketTimeoutException ex) {
                    }
                }
            }
            while (this.myTeam.isFinished()) {
                msg = new UpdateClientStatisticsMessageImpl(this.myTeam.isScoreAvailable() ? this.myTeam.getFinalScore() : this.myTeam.getTheoreticalScore(), this.myTeam.getClock().getDuration(), this.myTeam.getClock().getSecondsRemaining(), 2, this.myRound.getTeamsOnline(), this.myRound.getTeamCount(), null);
                msg.write(this.out);
                String[][] l = this.myTeam.getLines();
                for (int t7 = 0; t7 < l.length; ++t7) {
                    msg = new ConsoleMessageImpl(l[t7][0] == null ? "Output" : l[t7][0], l[t7][1]);
                    msg.write(this.out);
                }
                this.out.flush();
                try {
                    msg = this.factory.createMessage(this.in);
                }
                catch (SocketTimeoutException ex) {}
            }
        }
        catch (IOException ex) {
            this.myLog.error("Error in MessageHandler : " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                if (loginOk) {
                    this.myTeam.isValidPassword(null);
                }
                this.myLog.info("Closing connection.");
                this.mySocket.close();
            }
            catch (IOException ex) {
                this.myLog.error("Error closing Socket : " + ex.getMessage());
            }
        }
    }
}

