/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nl.moj.client.anim.Anim;
import nl.moj.client.io.AddActionMessageImpl;
import nl.moj.client.io.AnimationMessageImpl;
import nl.moj.client.io.AssignmentMessageImpl;
import nl.moj.client.io.ConsoleMessageImpl;
import nl.moj.client.io.EditorMessageImpl;
import nl.moj.client.io.LogonFailureMessageImpl;
import nl.moj.client.io.Message;
import nl.moj.client.io.ProtocolVersionMismatchMessageImpl;
import nl.moj.client.io.TestSetMessageImpl;
import nl.moj.client.io.UpdateClientStatisticsMessageImpl;
import nl.moj.model.Operation;
import nl.moj.model.Round;
import nl.moj.model.Scheduler;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.operation.ContextImpl;
import nl.moj.operation.Test;
import nl.moj.server.ClientServerInterface;

public class ClientServerImpl
implements ClientServerInterface {
    private Scheduler scheduler;
    private Round round;
    private Team team;
    private int lastState = -1;

    public ClientServerImpl(Scheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("Cannot function without a Scheduler.");
        }
        this.scheduler = scheduler;
    }

    public boolean isStateChanged() {
        if (this.isInitial()) {
            if (this.lastState != -1) {
                this.lastState = -1;
                return true;
            }
        } else if (this.isWaiting()) {
            if (this.lastState != 0) {
                this.lastState = 0;
                return true;
            }
        } else if (this.isPlaying()) {
            if (this.lastState != 1) {
                this.lastState = 1;
                return true;
            }
        } else if (this.isFinished() && this.lastState != 2) {
            this.lastState = 2;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInitial() {
        return this.team == null;
    }

    @Override
    public boolean isScoreAvailable() {
        if (this.team == null) {
            return false;
        }
        return this.team.isScoreAvailable();
    }

    @Override
    public boolean isFinished() {
        if (this.team == null) {
            return false;
        }
        return this.team.isFinished();
    }

    @Override
    public boolean isPlaying() {
        if (this.team == null) {
            return false;
        }
        return this.team.isPlaying();
    }

    @Override
    public boolean isWaiting() {
        if (this.team == null) {
            return false;
        }
        return this.team.isWaiting();
    }

    @Override
    public Message[] onHello(Message.Hello msg) throws ClientServerInterface.InvalidStateException {
        if (!this.isInitial()) {
            throw new ClientServerInterface.InvalidStateException("State is not Initial. Cannot say Hello.");
        }
        Round tmpRound = null;
        Team tmpTeam = null;
        Round[] rnd = this.scheduler.getActiveRounds();
        for (int t = 0; t < rnd.length; ++t) {
            Team tmp = rnd[t].getTeamByName(msg.getTeamName());
            if (tmp == null) continue;
            tmpRound = rnd[t];
            tmpTeam = tmp;
        }
        if (!this.isOnline(tmpTeam)) {
            if (this.isCorrectPassword(tmpTeam, msg)) {
                if (this.isCorrectProtocolVersion(msg)) {
                    this.team = tmpTeam;
                    this.round = tmpRound;
                    return this.onNoOp(null, new AssignmentMessageImpl(tmpTeam.getAssignment()));
                }
                return new Message[]{new ProtocolVersionMismatchMessageImpl()};
            }
            return new Message[]{new LogonFailureMessageImpl()};
        }
        return new Message[]{new LogonFailureMessageImpl()};
    }

    @Override
    public Message[] onAction(Message.Action action) throws ClientServerInterface.InvalidStateException {
        if (!this.isPlaying()) {
            throw new ClientServerInterface.InvalidStateException("State is not Playing. Cannot perform an Action.");
        }
        Operation[] ops = this.round.getAssignment().getOperations();
        for (int t = 0; t < ops.length; ++t) {
            if (!ops[t].getName().equals(action.getAction())) continue;
            this.team.doOperation(ops[t], new ContextImpl(action.getFileName(), action.getContents(), action.getIndex()));
            this.team.addStatistics(action.getKeyStrokes(), action.getAction(), action.getContents().length());
        }
        return this.onNoOp(null);
    }

    @Override
    public Message[] onNoOp(Message.NoOp msg) throws ClientServerInterface.InvalidStateException {
        return this.onNoOp(msg, null);
    }

    protected Message[] onNoOp(Message.NoOp msg, Message additionalMsg) throws ClientServerInterface.InvalidStateException {
        if (this.isInitial()) {
            throw new ClientServerInterface.InvalidStateException("State is Initial. First say Hello, then do a NoOp.");
        }
        ArrayList<Message> results = new ArrayList<Message>();
        if (additionalMsg != null) {
            results.add(additionalMsg);
        }
        if (this.isStateChanged() && this.isPlaying()) {
            try {
                this.getWaitingToPlayingTransitionMessages(results);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.isWaiting()) {
            this.getWaitingMessages(results);
        } else if (this.isPlaying()) {
            this.getPlayingMessages(results);
        } else if (this.isFinished()) {
            this.getFinishedMessages(results);
        } else {
            throw new ClientServerInterface.InvalidStateException();
        }
        return results.toArray(new Message[results.size()]);
    }

    @Override
    public Message[] onGoodBye(Message.GoodBye msg) throws ClientServerInterface.InvalidStateException {
        if (this.isInitial()) {
            throw new ClientServerInterface.InvalidStateException("State is Initial. First say Hello, then do a Goodbye.");
        }
        this.logout(this.team);
        this.team = null;
        this.round = null;
        return new Message[0];
    }

    protected boolean isCorrectProtocolVersion(Message.Hello msg) {
        return msg.getProtocolVersion() == 2007111001;
    }

    protected boolean isOnline(Team tm) {
        return tm.isOnline();
    }

    protected boolean isCorrectPassword(Team tm, Message.Hello msg) {
        if (tm == null) {
            return false;
        }
        return tm.isValidPassword(msg.getPassword());
    }

    protected void logout(Team tm) {
        tm.isValidPassword(null);
    }

    @Override
    public void update() {
        try {
            if (this.team != null) {
                this.team.getWorkspace().update();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Workspace update failed", ex);
        }
    }

    protected void getWaitingMessages(List results) {
        results.add(new UpdateClientStatisticsMessageImpl(0, this.team.getClock().getDuration(), this.team.getClock().getSecondsRemaining(), 0, this.round.getTeamsOnline(), this.round.getTeamCount(), null));
    }

    protected void getWaitingToPlayingTransitionMessages(List results) throws IOException {
        int t;
        Workspace ws = this.team.getWorkspace();
        String[] editorFiles = ws.getEditorFiles();
        for (int t2 = 0; t2 < editorFiles.length; ++t2) {
            String current = editorFiles[t2];
            if (ws.isJava(current)) continue;
            results.add(new EditorMessageImpl(current, ws.getContents(current), ws.isJava(current), ws.isReadOnly(current), ws.isMonospaced(current)));
        }
        Tester tester = null;
        Operation[] ops = this.round.getAssignment().getOperations();
        for (t = 0; t < ops.length; ++t) {
            results.add(new AddActionMessageImpl(ops[t].getName(), ops[t].needsConfirm(), ops[t].getTooltip()));
            if (!(ops[t] instanceof Test)) continue;
            tester = ((Test)ops[t]).getTester();
        }
        if (tester != null) {
            results.add(new TestSetMessageImpl(tester.getTestNames(), tester.getTestDescriptions()));
        }
        for (t = 0; t < editorFiles.length; ++t) {
            String current = editorFiles[t];
            if (!ws.isJava(current)) continue;
            results.add(new EditorMessageImpl(current, ws.getContents(current), ws.isJava(current), ws.isReadOnly(current), ws.isMonospaced(current)));
        }
    }

    protected void getPlayingMessages(List results) {
        int[] testResults = this.team.getTestResults();
        Anim[] testAnimResults = this.team.getAnimatedTestResults();
        results.add(new UpdateClientStatisticsMessageImpl(0, this.team.getClock().getDuration(), this.team.getClock().getSecondsRemaining(), 1, this.round.getTeamsOnline(), this.round.getTeamCount(), testResults));
        if (testResults != null && testAnimResults != null) {
            for (int t = 0; t < testAnimResults.length; ++t) {
                if (testAnimResults[t] == null) continue;
                results.add(new AnimationMessageImpl(t, testAnimResults[t]));
            }
        }
        String[][] l = this.team.getLines();
        for (int t = 0; t < l.length; ++t) {
            results.add(new ConsoleMessageImpl(l[t][0] == null ? "Output" : l[t][0], l[t][1]));
        }
    }

    protected void getFinishedMessages(List results) {
        results.add(new UpdateClientStatisticsMessageImpl(this.team.isScoreAvailable() ? this.team.getFinalScore() : this.team.getTheoreticalScore(), this.team.getClock().getDuration(), this.team.getClock().getSecondsRemaining(), 2, this.round.getTeamsOnline(), this.round.getTeamCount(), null));
        String[][] l = this.team.getLines();
        for (int t = 0; t < l.length; ++t) {
            results.add(new ConsoleMessageImpl(l[t][0] == null ? "Output" : l[t][0], l[t][1]));
        }
    }
}

