/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.security;

import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import nl.moj.model.Assignment;
import nl.moj.model.Tester;
import nl.moj.security.DefaultSecurityDelegate;

public class SandboxSecurityManager
extends SecurityManager {
    private static Logger log = Logger.getLogger("Sandbox");
    private ThreadGroup myUntrusted;
    private Map<String, Tester.SecurityDelegate> securityDelegates;
    private Map<String, ThreadGroup> threadGroups;

    public SandboxSecurityManager(ThreadGroup untrusted) {
        this.myUntrusted = untrusted;
        this.securityDelegates = new HashMap<String, Tester.SecurityDelegate>();
        this.threadGroups = new HashMap<String, ThreadGroup>();
    }

    public ThreadGroup getEvilThreadGroupRoot() {
        return this.myUntrusted;
    }

    public synchronized void registerAssignment(Assignment assignment) {
        String tgName = assignment.getName() + "-securityCtx";
        if (this.securityDelegates.containsKey(tgName)) {
            return;
        }
        ThreadGroup assignmentThreadGroup = new ThreadGroup(this.myUntrusted, tgName);
        this.securityDelegates.put(tgName, assignment.getSecurityDelegate());
        this.threadGroups.put(tgName, assignmentThreadGroup);
    }

    public synchronized ThreadGroup getEvilThreadGroup(Assignment assignment) {
        String tgName = assignment.getName() + "-securityCtx";
        ThreadGroup tg = this.threadGroups.get(tgName);
        if (tg == null) {
            log.warning("No ThreadGroup set for '" + tgName + "'. Using root.");
            tg = this.myUntrusted;
        }
        return tg;
    }

    protected synchronized Tester.SecurityDelegate getSecurityDelegate(ThreadGroup tg) {
        String name = tg.getName();
        Tester.SecurityDelegate tsd = this.securityDelegates.get(name);
        if (tsd == null) {
            log.warning("No SecurityDelegate set for '" + name + "'. Using default.");
            tsd = new DefaultSecurityDelegate();
        }
        return tsd;
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (g == null) {
            throw new NullPointerException("NULL ThreadGroup.");
        }
        if (g.equals(this.myUntrusted)) {
            return;
        }
        if (Thread.currentThread().getThreadGroup() == this.myUntrusted) {
            throw new SecurityException("Not allowed to modify ThreadGroups");
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        this.check(perm, null);
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        this.check(perm, null);
    }

    private void check(Permission perm, Object context) {
        boolean evil = false;
        Thread[] tr = new Thread[this.myUntrusted.activeCount()];
        this.myUntrusted.enumerate(tr, true);
        String current = Thread.currentThread().getName();
        for (int t = 0; t < tr.length; ++t) {
            if (tr[t] == null || !tr[t].getName().equals(current)) continue;
            evil = true;
        }
        if (evil) {
            this.getSecurityDelegate(Thread.currentThread().getThreadGroup()).checkPermission(perm, context);
        }
    }
}

