/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.security;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.Permission;
import java.util.PropertyPermission;
import java.util.logging.Level;
import nl.moj.model.Tester;
import nl.moj.security.AbstractSecurityDelegate;

public class FriendlySecurityDelegate
extends AbstractSecurityDelegate
implements Tester.SecurityDelegate {
    @Override
    protected void setAllowedClasses() {
    }

    @Override
    protected void setIllegalClasses() {
    }

    @Override
    public void checkPermission(Permission perm, Object context) throws SecurityException {
        boolean fail = false;
        if (perm instanceof RuntimePermission) {
            if (perm.getName().startsWith("exitVM")) {
                fail = true;
            }
            if ("setSecurityManager".equals(perm.getName())) {
                fail = true;
            }
            if ("createClassLoader".equals(perm.getName())) {
                fail = true;
            }
        } else if (perm instanceof FilePermission) {
            if (perm.getActions().equals("read")) {
                if (perm.getName().toLowerCase().endsWith(".java")) {
                    fail = true;
                }
                if (perm.getName().toLowerCase().endsWith(".class")) {
                    if (perm.getName().indexOf("workspace") < 0) {
                        fail = true;
                    }
                    if (perm.getName().indexOf("bin") < 0) {
                        fail = true;
                    }
                }
            } else {
                fail = true;
            }
        } else if (perm instanceof SocketPermission) {
            fail = true;
        } else if (perm instanceof PropertyPermission) {
            if (!perm.getActions().equals("read")) {
                fail = true;
            }
        } else if (perm instanceof AWTPermission && "accessEventQueue".equals(perm.getName())) {
            fail = true;
        }
        if (fail) {
            log.log(Level.SEVERE, Thread.currentThread().getName() + " : Permission Denied : " + perm);
            throw new SecurityException("Permission Denied : " + perm);
        }
    }
}

