/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.security;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSecurityDelegate {
    protected static final Logger log = Logger.getLogger("SecurityDelegate");
    private List<String> myIllegalClasses = new ArrayList<String>();
    private List<String> myAllowedClasses = new ArrayList<String>();

    public AbstractSecurityDelegate() {
        this.setIllegalClasses();
        this.setAllowedClasses();
    }

    protected abstract void setIllegalClasses();

    protected abstract void setAllowedClasses();

    protected void addAllowedClass(String className) {
        this.myAllowedClasses.add(className);
    }

    protected void addIllegalClass(String className) {
        if (className == null) {
            throw new NullPointerException("Cannot add a NULL illegal class.");
        }
        if (className.indexOf("*") > 0 && !className.endsWith("*")) {
            throw new RuntimeException("Wildcards are only allowed as last character.");
        }
        this.myIllegalClasses.add(className);
    }

    public void checkClassLoading(String className) throws SecurityException {
        String tmp;
        int t;
        for (t = 0; t < this.myAllowedClasses.size(); ++t) {
            tmp = this.myAllowedClasses.get(t);
            if (!tmp.equals(className)) continue;
            return;
        }
        for (t = 0; t < this.myIllegalClasses.size(); ++t) {
            tmp = this.myIllegalClasses.get(t);
            if (tmp.endsWith("*")) {
                if (!className.startsWith(tmp = tmp.substring(0, tmp.length() - 1))) continue;
                log.log(Level.SEVERE, Thread.currentThread().getName() + " : Disallowed : " + className);
                throw new SecurityException("Loading of Class " + className + " is not allowed.");
            }
            if (!className.equals(tmp)) continue;
            log.log(Level.SEVERE, Thread.currentThread().getName() + " : Disallowed : " + className);
            throw new SecurityException("Loading of Class " + className + " is not allowed.");
        }
    }
}

