/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.scoreboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import nl.ctrlaltdev.ui.Build;
import nl.ctrlaltdev.ui.PowerBarPanel;
import nl.ctrlaltdev.util.Tool;
import nl.moj.banner.BannerPanel;
import nl.moj.round.StateImpl;

public class ScoreBoardToo
extends JPanel {
    private static final Font bigFont = new Font("Verdana", 0, 42);
    private static final Color backgroundBlue = new Color(64, 64, 128);
    private static final Color darkBlue = new Color(32, 32, 64);
    private static final Color foregroundWhite = new Color(255, 255, 255);
    private BannerPanel[] bmp;
    private JScrollBar scrollBar;
    private int scrollDirection;
    private int pause;

    public ScoreBoardToo(String[] columns) throws IOException {
        super(new GridLayout(0, columns.length));
        this.buildGui(columns);
        this.pause = 20;
    }

    protected JComponent buildBigLabel(String txt) {
        JLabel lbl = new JLabel(txt);
        lbl.setFont(bigFont);
        lbl.setForeground(foregroundWhite);
        return new Build.CFP((JComponent)lbl, backgroundBlue);
    }

    protected PowerBarPanel.Entry makeEntry(StateImpl state, String team, String[] rounds) {
        int sum = 0;
        int[] rnd = new int[rounds.length];
        String[] lbl = new String[rounds.length];
        for (int t = 0; t < rounds.length; ++t) {
            rnd[t] = state.getScore(rounds[t], team);
            if (rnd[t] >= 0) {
                sum += rnd[t];
            } else {
                rnd[t] = 0;
            }
            lbl[t] = "" + rnd[t];
        }
        return new PowerBarPanel.SimpleEntry(team, sum + " pts", rnd, rounds, lbl);
    }

    protected JComponent buildScorePanel(StateImpl state) {
        int t;
        String[] teams = state.getKnownTeams();
        String[] rounds = state.getKnownRoundNames();
        PowerBarPanel pbp = new PowerBarPanel();
        pbp.setBackground(darkBlue);
        PowerBarPanel.Entry[] e = new PowerBarPanel.Entry[teams.length];
        for (t = 0; t < e.length; ++t) {
            e[t] = this.makeEntry(state, teams[t], rounds);
        }
        Arrays.sort(e, new Comparator(){

            public int compare(Object o1, Object o2) {
                int t;
                PowerBarPanel.Entry e1 = (PowerBarPanel.Entry)o1;
                PowerBarPanel.Entry e2 = (PowerBarPanel.Entry)o2;
                int sum1 = 0;
                int sum2 = 0;
                for (t = 0; t < e1.getLength(); ++t) {
                    sum1 += e1.getValue(t);
                }
                for (t = 0; t < e2.getLength(); ++t) {
                    sum2 += e2.getValue(t);
                }
                return sum2 - sum1;
            }
        });
        for (t = 0; t < teams.length; ++t) {
            pbp.addEntry(e[t]);
        }
        return pbp;
    }

    protected void buildGui(String[] columns) throws IOException {
        this.bmp = new BannerPanel[columns.length];
        for (int t = 0; t < columns.length; ++t) {
            this.bmp[t] = new BannerPanel(new File("./data/banners/"));
            for (int y = 0; y < t; ++y) {
                this.bmp[t].nextImage();
            }
            this.bmp[t].setPreferredSize(new Dimension(256, 128));
            StateImpl state = new StateImpl(new File(columns[t]));
            JScrollPane scrollPane = new JScrollPane(this.buildScorePanel(state));
            this.scrollBar = scrollPane.getVerticalScrollBar();
            Build.NCS p = new Build.NCS(this.buildBigLabel("" + (char)(65 + t)), scrollPane, this.bmp[t]);
            this.add(p);
        }
    }

    public void updateBannerPanels() {
        if (this.bmp == null) {
            return;
        }
        for (int t = 0; t < this.bmp.length; ++t) {
            this.bmp[t].nextImage();
        }
    }

    public void updateScrollBar() {
        int max = this.scrollBar.getModel().getMaximum();
        int min = this.scrollBar.getModel().getMinimum();
        int pos = this.scrollBar.getModel().getValue();
        int ext = this.scrollBar.getModel().getExtent();
        if (max == ext) {
            return;
        }
        if (this.scrollBar.getValueIsAdjusting()) {
            return;
        }
        if (this.scrollDirection == 0 && this.pause == 0) {
            this.scrollDirection = pos == min ? 1 : -1;
        } else {
            --this.pause;
        }
        if (this.scrollDirection > 0) {
            if ((pos += 4) + ext > max) {
                pos = max - ext;
                this.scrollDirection = 0;
                this.pause = 20;
            }
            this.scrollBar.setValue(pos);
        } else if (this.scrollDirection < 0) {
            if ((pos -= 4) < min) {
                pos = min;
                this.scrollDirection = 0;
                this.pause = 20;
            }
            this.scrollBar.setValue(pos);
        }
    }

    public static void main(String[] args) throws Throwable {
        if ((args = Tool.parseArgs(args)).length == 0) {
            System.out.println("Usage : ScoreBoard [filename] <filename> ..");
            System.exit(0);
        }
        JFrame f = new JFrame("Masters Of Java - Scoreboard");
        final ScoreBoardToo sbt = new ScoreBoardToo(args);
        f.getContentPane().add((Component)sbt, "Center");
        f.setSize(1024, 768);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                int cnt = 0;
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    final boolean update = ++cnt % 100 == 0;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            sbt.updateScrollBar();
                            if (update) {
                                sbt.updateBannerPanels();
                            }
                        }
                    });
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }
}

