/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.scoreboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import nl.ctrlaltdev.util.Tool;
import nl.moj.mgmt.TeamProfileList;
import nl.moj.model.State;
import nl.moj.round.StateImpl;
import nl.moj.scoreboard.PillarPanel;
import nl.moj.scoreboard.ScoringRules;
import nl.moj.scoreboard.scoringrules.MoJ2006ScoringRules;

public class DukeScoreBoard
extends JPanel {
    private State state;
    private TeamProfileList teamList;
    private PillarPanel[] panels;
    private JScrollBar scrollBar;
    private int scrollDirection;
    private int pause = 80;

    public DukeScoreBoard(File stateFile, File teamFile, ScoringRules rules) throws IOException {
        super(new BorderLayout());
        int t;
        this.state = new StateImpl(stateFile);
        this.teamList = new TeamProfileList(teamFile);
        JPanel content = new JPanel();
        JScrollPane sp = new JScrollPane(content);
        this.scrollBar = sp.getHorizontalScrollBar();
        this.add(sp);
        String[] rounds = this.state.getKnownRoundNames();
        JPanel pillars = new JPanel();
        LabelPanel labelPanel = new LabelPanel(rounds);
        content.setLayout(new BorderLayout());
        content.add((Component)pillars, "Center");
        content.add((Component)labelPanel, "South");
        labelPanel.setBackground(new Color(255, 160, 64));
        labelPanel.setPreferredSize(new Dimension(512, 128));
        String[] teams = this.state.getKnownTeams();
        this.panels = new PillarPanel[teams.length];
        pillars.setLayout(new BoxLayout(pillars, 0));
        for (int t2 = 0; t2 < teams.length; ++t2) {
            this.panels[t2] = new PillarPanel(teams[t2], rules.getMaxScorePerRound());
        }
        Image duke = DukeScoreBoard.loadImage("/client/duke_winner1.jpg");
        Image dukeToo = DukeScoreBoard.loadImage("/client/duke_winner2.jpg");
        Image dukeLoser = DukeScoreBoard.loadImage("/client/duke_loser.jpg");
        boolean[] checkSkip = new boolean[teams.length];
        int[][] rounds_times = new int[rounds.length][teams.length];
        double[][] rounds_scores = new double[rounds.length][teams.length];
        for (t = 0; t < rounds.length; ++t) {
            int y;
            for (y = 0; y < teams.length; ++y) {
                int idx = this.teamList.getIndexOfTeam(teams[y]);
                if (idx >= 0) {
                    String ex = this.teamList.getExcludeAssignment(idx);
                    if (!rounds[t].equalsIgnoreCase(ex)) {
                        rounds_times[t][y] = this.state.getScore(rounds[t], teams[y]);
                        continue;
                    }
                    if (checkSkip[y]) {
                        System.out.println("Warning : Team " + teams[y] + " skips twice.");
                    }
                    checkSkip[y] = true;
                    rounds_times[t][y] = 0;
                    continue;
                }
                rounds_times[t][y] = this.state.getScore(rounds[t], teams[y]);
            }
            rounds_scores[t] = rules.assignScores((int[])rounds_times[t].clone());
            for (y = 0; y < teams.length; ++y) {
                this.panels[y].addSegment(t, rounds_scores[t][y]);
            }
        }
        for (t = 0; t < checkSkip.length; ++t) {
            String skip;
            int idx = this.teamList.getIndexOfTeam(teams[t]);
            String string = skip = idx >= 0 ? this.teamList.getExcludeAssignment(idx) : "Team not in team.properties";
            if (checkSkip[t]) continue;
            System.out.println("Warning : Team " + teams[t] + " did not skip any assignment. (" + skip + ")");
        }
        for (int r = 0; r < 16; ++r) {
            System.out.print(" ");
        }
        for (t = 0; t < rounds.length; ++t) {
            System.out.print(DukeScoreBoard.fix(rounds[t], 16));
        }
        System.out.println();
        for (int y = 0; y < teams.length; ++y) {
            System.out.print(DukeScoreBoard.fix(teams[y], 16));
            for (int t3 = 0; t3 < rounds.length; ++t3) {
                System.out.print(DukeScoreBoard.fix(DukeScoreBoard.prefix(String.valueOf(rounds_times[t3][y]), 5) + "->" + DukeScoreBoard.prefix(String.valueOf(rounds_scores[t3][y]), 5), 16));
            }
            System.out.println();
        }
        Arrays.sort(this.panels, new Comparator(){

            public int compare(Object a, Object b) {
                double s2;
                double s1 = ((PillarPanel)a).totalScore();
                if (s1 > (s2 = ((PillarPanel)b).totalScore())) {
                    return -1;
                }
                if (s1 < s2) {
                    return 1;
                }
                return 0;
            }
        });
        for (t = 0; t < this.panels.length; ++t) {
            this.panels[t].setMaxScore(this.panels[0].totalScore() + this.panels[0].totalScore() * 0.1);
        }
        if (this.panels.length > 0) {
            this.panels[0].setDuke(duke);
        }
        if (this.panels.length > 1) {
            this.panels[1].setDuke(dukeToo);
        }
        if (this.panels.length > 2) {
            this.panels[2].setDuke(dukeToo);
        }
        if (this.panels.length > 3) {
            this.panels[this.panels.length - 1].setDuke(dukeLoser);
        }
        System.out.println();
        for (t = 0; t < teams.length; ++t) {
            pillars.add(this.panels[t]);
            if (t >= 3) continue;
            System.out.println("#" + (t + 1) + " : " + this.panels[t].getName());
        }
    }

    private static String fix(String s, int l) {
        if (s.length() >= l) {
            return s.substring(0, l - 1) + " ";
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < l) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String prefix(String s, int l) {
        if (s.length() > l) {
            return s.substring(0, l - 1);
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < l) {
            sb.insert(0, " ");
        }
        return sb.toString();
    }

    static Image loadImage(String fileName) throws IOException {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL myURL = DukeScoreBoard.class.getResource(fileName);
        if (myURL == null) {
            throw new IOException("Resource " + fileName + " not found. Does it start with / ?");
        }
        return tk.createImage(myURL);
    }

    public void updateScrollBar() {
        int max = this.scrollBar.getModel().getMaximum();
        int min = this.scrollBar.getModel().getMinimum();
        int pos = this.scrollBar.getModel().getValue();
        int ext = this.scrollBar.getModel().getExtent();
        if (max == ext) {
            return;
        }
        if (this.scrollBar.getValueIsAdjusting()) {
            return;
        }
        if (this.scrollDirection == 0 && this.pause == 0) {
            this.scrollDirection = pos == min ? 1 : -1;
        } else {
            --this.pause;
        }
        if (this.scrollDirection > 0) {
            if ((pos += 4) + ext > max) {
                pos = max - ext;
                this.scrollDirection = 0;
                this.pause = 20;
            }
            this.scrollBar.setValue(pos);
        } else if (this.scrollDirection < 0) {
            if ((pos -= 4) < min) {
                pos = min;
                this.scrollDirection = 0;
                this.pause = 20;
            }
            this.scrollBar.setValue(pos);
        }
    }

    public static void main(String[] args) throws IOException {
        if ((args = Tool.parseArgs(args)).length != 2) {
            System.out.println("Usage : DukeScoreBoard [state.csv] [team.properties]");
            System.exit(0);
        }
        File state = new File(args[0]);
        File team = new File(args[1]);
        if (state.exists() && team.exists()) {
            JFrame f = new JFrame("Masters Of Java - Scoreboard");
            final DukeScoreBoard dsc = new DukeScoreBoard(state, team, new MoJ2006ScoringRules());
            f.getContentPane().add((Component)dsc, "Center");
            f.setSize(1024, 768);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            f.setVisible(true);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dsc.updateScrollBar();
                            }
                        });
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        } else {
            if (!state.exists()) {
                System.err.println("File '" + state + "' does not exist.");
            }
            if (!team.exists()) {
                System.err.println("File '" + team + "' does not exist.");
            }
        }
    }

    private static final class LabelPanel
    extends JPanel {
        private Font font = new Font("Verdana", 1, 72);
        private Font small = new Font("Verdana", 1, 10);
        private String[] names;
        private String year;

        public LabelPanel(String[] assignments) {
            this.names = assignments;
            this.year = String.valueOf(Calendar.getInstance().get(1));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Color.black);
            g2d.setFont(this.font);
            String s = "Masters of Java " + this.year;
            double sw = g2d.getFontMetrics().getStringBounds(s, 0, s.length(), (Graphics)g2d).getWidth();
            g2d.drawString(s, this.getWidth() / 2 - (int)sw / 2, this.getHeight() - this.getHeight() / 3);
            for (int t = 0; t < this.names.length; ++t) {
                int n = this.names.length - t - 1;
                g2d.setColor(PillarPanel.PILLARHILIGHT[n % PillarPanel.PILLARHILIGHT.length]);
                g2d.fillRect(16, 8 + 16 * t, 256, 16);
                g2d.setColor(Color.BLACK);
                g2d.drawRect(16, 8 + 16 * t, 256, 16);
                s = this.names[n];
                g2d.setFont(this.small);
                sw = g2d.getFontMetrics().getStringBounds(s, 0, s.length(), (Graphics)g2d).getWidth();
                g2d.drawString(s, 144 - (int)sw / 2, 8 + 16 * t + 12);
            }
        }
    }
}

