/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.moj.model.Round;
import nl.moj.model.Scheduler;
import nl.moj.scheduler.ScheduledRoundImpl;
import nl.moj.workspace.factory.WorkspaceFactory;

public class ContinuousScheduler
implements Scheduler {
    private static final Logger log = Logger.getLogger("Scheduler");
    private static final Timer timer = new Timer("Continuous-Scheduler");
    private List scheduledRounds = new ArrayList();
    private WorkspaceFactory factory;

    public ContinuousScheduler(WorkspaceFactory wf) {
        this.factory = wf;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ContinuousScheduler.this.update();
            }
        }, 250L, 250L);
    }

    protected synchronized Scheduler.ScheduledRound[] getAllScheduledRounds() {
        return this.scheduledRounds.toArray(new Scheduler.ScheduledRound[this.scheduledRounds.size()]);
    }

    @Override
    public synchronized Scheduler.ScheduledRound addToSchedule(Round r, Date startTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(startTime);
        c.add(12, -5);
        ScheduledRoundImpl sr = new ScheduledRoundImpl(c.getTime(), startTime, r);
        this.scheduledRounds.add(sr);
        log.info("Round for " + r.getAssignment().getName() + " and " + r.getTeamCount() + " teams added to schedule. Starts at " + startTime);
        return sr;
    }

    @Override
    public Scheduler.ScheduledRound[] getSchedule(Date startTime, Date endTime) {
        ArrayList<Scheduler.ScheduledRound> results = new ArrayList<Scheduler.ScheduledRound>();
        Scheduler.ScheduledRound[] rnd = this.getAllScheduledRounds();
        for (int t = 0; t < rnd.length; ++t) {
            if (!rnd[t].activeIn(startTime, endTime)) continue;
            results.add(rnd[t]);
        }
        return results.toArray(new Scheduler.ScheduledRound[results.size()]);
    }

    @Override
    public synchronized void removeFromSchedule(Scheduler.ScheduledRound r) {
        this.scheduledRounds.remove(r);
    }

    @Override
    public Round[] getActiveRounds() {
        Date now = new Date();
        ArrayList<Round> results = new ArrayList<Round>();
        Scheduler.ScheduledRound[] rnd = this.getAllScheduledRounds();
        for (int t = 0; t < rnd.length; ++t) {
            if (!rnd[t].activeIn(now, null)) continue;
            results.add(rnd[t].getRound());
        }
        return results.toArray(new Round[results.size()]);
    }

    @Override
    public Round[] getFinishedRounds() {
        ArrayList<Round> results = new ArrayList<Round>();
        Scheduler.ScheduledRound[] rnd = this.getAllScheduledRounds();
        for (int t = 0; t < rnd.length; ++t) {
            if (!rnd[t].isFinished()) continue;
            results.add(rnd[t].getRound());
        }
        return results.toArray(new Round[results.size()]);
    }

    protected void update() {
        Date now = new Date();
        Scheduler.ScheduledRound[] rnd = this.getAllScheduledRounds();
        for (int t = 0; t < rnd.length; ++t) {
            if (!rnd[t].activeIn(now, null) || !rnd[t].getStartTime().before(now) || rnd[t].isStarted() || rnd[t].isFailed()) continue;
            try {
                log.info("Started " + rnd[t].getRound().getAssignment().getName());
                rnd[t].getRound().start(this.factory, false);
                continue;
            }
            catch (IOException ex) {
                rnd[t].setFailure("Failed to Start : " + ex.getMessage());
                log.log(Level.SEVERE, "Failed starting round ", ex);
            }
        }
        Date yesterday = new Date(now.getTime() - 86400000L);
        for (int t = 0; t < rnd.length; ++t) {
            Date s = rnd[t].getStartTime();
            if (!s.before(yesterday)) continue;
            this.removeFromSchedule(rnd[t]);
            log.info("Removed " + rnd[t].getRound().getAssignment().getName());
        }
    }
}

