/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.round;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.ctrlaltdev.util.Tool;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;

public class StateImpl
implements State,
State.Writer {
    private static final String OPENED = "OPEN";
    private static final String STARTED = "START";
    private static final String PAUSED = "PAUSE";
    private static final String RESUMED = "RESUME";
    private static final String FINISHED = "FINISH";
    private static final String SUBMITTED = "SUBMITTED";
    private static final String CLOSED = "CLOSE";
    private static final String TIME = "TIME";
    private static final String SCORE = "SCORE";
    private static final String KEYSTROKE = "KEYSTROKE";
    private static final String OPERATION = "OPERATION";
    private static final String SOLUTIONSIZE = "SOLUTIONSIZE";
    private static final String COMPILESUCCESS = "COMPSUCCESS";
    private static final String COMPILEFAILURE = "COMPFAILURE";
    private static final String TESTSUCCESS = "TESTSUCCESS";
    private static final String TESTFAILURE = "TESTFAILURE";
    private static final String LASTHOST = "LASTHOST";
    private FileWriter myWriter;
    private Map roundData;
    private List knownRounds;
    private List knownTeams;
    private List myBuffer;
    private Map workspaceHosts;

    public StateImpl(File stateFile) throws IOException {
        if (stateFile == null) {
            throw new IOException("NULL State File.");
        }
        this.roundData = new HashMap();
        this.knownTeams = new ArrayList();
        this.knownRounds = new ArrayList();
        this.myBuffer = new ArrayList();
        this.workspaceHosts = new HashMap();
        if (stateFile.exists()) {
            this.readState(stateFile);
        } else {
            stateFile.createNewFile();
        }
        this.myWriter = new FileWriter(stateFile, true);
    }

    protected RoundData getRoundData(String round) {
        RoundData rd = (RoundData)this.roundData.get(round);
        if (rd == null) {
            rd = new RoundData();
            this.roundData.put(round, rd);
            this.knownRounds.add(round);
        }
        return rd;
    }

    protected void readState(File in) throws IOException {
        BufferedReader fin = new BufferedReader(new FileReader(in));
        int cnt = 1;
        try {
            String s = fin.readLine();
            while (s != null) {
                this.parseLine(s);
                s = fin.readLine();
                ++cnt;
            }
        }
        catch (IOException ex) {
            System.out.println("Error in line : " + cnt);
            throw ex;
        }
        catch (NumberFormatException ex) {
            System.out.println("Error in line : " + cnt);
            throw ex;
        }
        finally {
            fin.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseLine(String s) throws IOException {
        String[] elem = Tool.cutForEach(s, ";");
        if (elem.length != 4) {
            throw new IOException("Invalid number of cells.");
        }
        String round = elem[0];
        String team = elem[1];
        String what = elem[2];
        String value = elem[3];
        if (LASTHOST.equals(what)) {
            this.workspaceHosts.put(round, team + ":" + value);
            return;
        }
        RoundData rd = this.getRoundData(round);
        if (team.length() <= 0) throw new IOException("State : Missing Team value (1.0 state file ??)");
        TeamData tm = rd.getTeam(team);
        if (SUBMITTED.equals(what)) {
            if (tm.submitted) {
                throw new IOException("Cannot submit twice in a round ?!");
            }
            tm.submitted = true;
            tm.submitTime = Integer.parseInt(value);
            return;
        } else if (SCORE.equals(what)) {
            if (!tm.submitted) {
                throw new IOException("Cannot have a SCORE before a SUBMITTED.");
            }
            tm.score = Integer.parseInt(value);
            return;
        } else if (KEYSTROKE.equals(what)) {
            tm.nrOfKeyStrokes += Integer.parseInt(value);
            return;
        } else if (OPERATION.equals(what)) {
            Integer i = (Integer)tm.operationCount.get(what);
            if (i == null) {
                tm.operationCount.put(what, new Integer(1));
                return;
            } else {
                tm.operationCount.put(what, new Integer(i));
            }
            return;
        } else if (SOLUTIONSIZE.equals(what)) {
            tm.lastSize = Integer.parseInt(value);
            return;
        } else if (COMPILEFAILURE.equals(what)) {
            ++tm.compileFailure;
            return;
        } else if (COMPILESUCCESS.equals(what)) {
            ++tm.compileSuccess;
            return;
        } else if (TESTFAILURE.equals(what)) {
            ++tm.testFailure;
            return;
        } else if (TESTSUCCESS.equals(what)) {
            ++tm.testSuccess;
            return;
        } else if (TIME.equals(what)) {
            tm.timeRemaining = Integer.parseInt(value);
            if (tm.timeRemaining % 60 != 0) {
                throw new IOException("Not a complete minute : " + tm.timeRemaining);
            }
            tm.solutionSize.put(new Integer(tm.timeRemaining), new Integer(tm.lastSize));
            return;
        } else if (OPENED.equals(what)) {
            tm.opened = true;
            return;
        } else if (STARTED.equals(what)) {
            tm.started = true;
            return;
        } else if (PAUSED.equals(what)) {
            tm.paused = true;
            tm.resumed = false;
            return;
        } else if (RESUMED.equals(what)) {
            tm.paused = false;
            tm.resumed = true;
            return;
        } else if (FINISHED.equals(what)) {
            tm.finished = true;
            return;
        } else {
            if (!CLOSED.equals(what)) throw new IOException("State : Invalid value : '" + what + "'");
            tm.closed = true;
        }
    }

    protected synchronized void writeLine(String round, String team, String what, String score) {
        this.myBuffer.add(round + ";" + team + ";" + what + ";" + score + "\n");
    }

    @Override
    public String[] getKnownRoundNames() {
        return this.knownRounds.toArray(new String[this.knownRounds.size()]);
    }

    @Override
    public String[] getKnownTeams() {
        return this.knownTeams.toArray(new String[this.knownTeams.size()]);
    }

    @Override
    public int getScore(Round rnd, Team team) {
        return this.getScore(rnd.getAssignment().getName(), team.getName());
    }

    @Override
    public int getScore(String round, String team) {
        RoundData rd = this.getRoundData(round);
        TeamData tm = rd.getTeam(team);
        if (tm.submitted) {
            return tm.score;
        }
        return -1;
    }

    @Override
    public int getSubmitTime(Round round, Team team) {
        RoundData rd = this.getRoundData(round.getAssignment().getName());
        TeamData tm = rd.getTeam(team.getName());
        if (tm.submitted) {
            return tm.submitTime;
        }
        return -1;
    }

    @Override
    public int getTimeRemaining(Round rnd, Team tm) {
        RoundData rd = this.getRoundData(rnd.getAssignment().getName());
        TeamData td = rd.getTeam(tm.getName());
        return td.timeRemaining;
    }

    @Override
    public boolean isComplete(Round rnd, Team team) {
        RoundData rd = this.getRoundData(rnd.getAssignment().getName());
        TeamData tm = rd.getTeam(team.getName());
        return tm.submitted;
    }

    @Override
    public boolean isFinished(Round rnd, Team tm) {
        RoundData rd = this.getRoundData(rnd.getAssignment().getName());
        TeamData td = rd.getTeam(tm.getName());
        return td.finished;
    }

    @Override
    public boolean isStarted(Round rnd, Team tm) {
        RoundData rd = this.getRoundData(rnd.getAssignment().getName());
        TeamData td = rd.getTeam(tm.getName());
        return td.started;
    }

    @Override
    public String getRoundWinner(String rnd) {
        RoundData rd = this.getRoundData(rnd);
        int hi = 0;
        String nameHi = null;
        for (String name : rd.teamData.keySet()) {
            TeamData td = rd.getTeam(name);
            if (td.score < 0 || hi >= td.score) continue;
            nameHi = name;
            hi = td.score;
        }
        return nameHi;
    }

    @Override
    public int getNrOfKeystrokes(String round, String team) {
        RoundData rd = this.getRoundData(round);
        TeamData tm = rd.getTeam(team);
        return tm.nrOfKeyStrokes;
    }

    @Override
    public float getKeyStrokeFileSizeRatio(String round, String team) {
        RoundData rd = this.getRoundData(round);
        TeamData tm = rd.getTeam(team);
        if (tm.lastSize == 0) {
            return 999.0f;
        }
        return (float)tm.nrOfKeyStrokes / (float)tm.lastSize;
    }

    @Override
    public String[] getOperationNames(String round, String team) {
        RoundData rd = this.getRoundData(round);
        TeamData tm = rd.getTeam(team);
        return tm.operationCount.keySet().toArray(new String[tm.operationCount.size()]);
    }

    @Override
    public int getOperationCount(String round, String team, String op) {
        RoundData rd = this.getRoundData(round);
        TeamData tm = rd.getTeam(team);
        Integer i = (Integer)tm.operationCount.get(op);
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    public int getCompileFailures(String round, String team) {
        return this.getRoundData((String)round).getTeam((String)team).compileFailure;
    }

    @Override
    public int getTestFailures(String round, String team) {
        return this.getRoundData((String)round).getTeam((String)team).testFailure;
    }

    @Override
    public int getCompileSuccess(String round, String team) {
        return this.getRoundData((String)round).getTeam((String)team).compileSuccess;
    }

    @Override
    public int getTestSuccess(String round, String team) {
        return this.getRoundData((String)round).getTeam((String)team).testSuccess;
    }

    @Override
    public int getFileSizeForMinute(String round, String team, int minute) {
        Integer m = new Integer(1800 - minute * 60);
        Integer i = (Integer)this.getRoundData((String)round).getTeam((String)team).solutionSize.get(m);
        if (i == null) {
            if (minute == 0) {
                return 0;
            }
            return this.getFileSizeForMinute(round, team, minute - 1);
        }
        return i;
    }

    @Override
    public int getFinalFileSize(String round, String team) {
        return this.getRoundData((String)round).getTeam((String)team).lastSize;
    }

    @Override
    public void open(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), OPENED, "");
    }

    @Override
    public void start(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), STARTED, "");
    }

    @Override
    public void pause(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), PAUSED, "");
    }

    @Override
    public void resume(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), RESUMED, "");
    }

    @Override
    public void close(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), CLOSED, "");
    }

    @Override
    public void timeRemaining(Team tm, int time) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), TIME, String.valueOf(time));
    }

    @Override
    public void score(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), SCORE, String.valueOf(tm.getFinalScore()));
    }

    @Override
    public void finish(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), FINISHED, "");
    }

    @Override
    public void submit(Team tm, int time) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), SUBMITTED, String.valueOf(time));
    }

    @Override
    public void keyStrokes(Team tm, int strokes) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), KEYSTROKE, String.valueOf(strokes));
    }

    @Override
    public void operation(Team tm, String name) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), OPERATION, name);
    }

    @Override
    public void solutionSize(Team tm, int size) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), SOLUTIONSIZE, String.valueOf(size));
    }

    @Override
    public void compileFailure(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), COMPILEFAILURE, "");
    }

    @Override
    public void compileSuccess(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), COMPILESUCCESS, "");
    }

    @Override
    public void testFailure(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), TESTFAILURE, "");
    }

    @Override
    public void testSuccess(Team tm) {
        this.writeLine(tm.getAssignment().getName(), tm.getName(), TESTSUCCESS, "");
    }

    @Override
    public String getLastHost(String workspaceName) {
        String host = (String)this.workspaceHosts.get(workspaceName);
        if (host == null) {
            return null;
        }
        return host.substring(0, host.indexOf(":"));
    }

    @Override
    public int getLastPort(String workspaceName) {
        String host = (String)this.workspaceHosts.get(workspaceName);
        if (host == null) {
            return -1;
        }
        return Integer.parseInt(host.substring(host.indexOf(":") + 1));
    }

    @Override
    public void workspaceHost(String workspaceName, String host, int port) {
        this.writeLine(workspaceName, host, LASTHOST, String.valueOf(port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        String[] lines = null;
        List list = this.myBuffer;
        synchronized (list) {
            lines = this.myBuffer.toArray(new String[this.myBuffer.size()]);
            this.myBuffer.clear();
        }
        for (int t = 0; t < lines.length; ++t) {
            this.myWriter.write(lines[t]);
        }
        this.myWriter.flush();
    }

    @Override
    public void closeFile() throws IOException {
        this.flush();
        this.myWriter.close();
    }

    private static class TeamData {
        int timeRemaining = -1;
        boolean opened;
        boolean started;
        boolean paused;
        boolean resumed;
        boolean finished;
        boolean closed;
        boolean submitted;
        int nrOfKeyStrokes;
        int submitTime;
        int score = -1;
        int compileFailure;
        int compileSuccess;
        int testFailure;
        int testSuccess;
        Map operationCount = new HashMap();
        Map solutionSize = new HashMap();
        int lastSize;
        String lastHost;

        private TeamData() {
        }
    }

    private class RoundData {
        Map teamData = new HashMap();

        private RoundData() {
        }

        public TeamData getTeam(String name) {
            TeamData tm = (TeamData)this.teamData.get(name);
            if (tm == null) {
                tm = new TeamData();
                this.teamData.put(name, tm);
                if (!StateImpl.this.knownTeams.contains(name)) {
                    StateImpl.this.knownTeams.add(name);
                }
            }
            return tm;
        }
    }
}

