/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.round;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.moj.model.Assignment;
import nl.moj.model.GameRules;
import nl.moj.model.Operation;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;
import nl.moj.round.TeamImpl;
import nl.moj.workspace.factory.WorkspaceFactory;

public class RoundImpl
implements Round {
    private static final Logger log = Logger.getLogger("Round");
    private List myTeams = new ArrayList();
    private Assignment myAssignment;
    private GameRules myRules;

    public RoundImpl(Assignment a, GameRules rules) {
        if (a == null) {
            throw new NullPointerException("Assignment is NULL.");
        }
        if (rules == null) {
            throw new NullPointerException("GameRules are NULL.");
        }
        Operation[] ops = a.getOperations();
        if (ops == null) {
            throw new NullPointerException("Operations are null.");
        }
        if (ops.length == 0) {
            throw new RuntimeException("There are no operations defined.");
        }
        this.myRules = rules;
        this.myAssignment = a;
    }

    @Override
    public void addTeam(Team t) {
        if (t == null) {
            throw new NullPointerException("Team is NULL.");
        }
        if (this.myTeams.contains(t)) {
            throw new RuntimeException("Team " + t + " is already in the Round list.");
        }
        log.log(Level.INFO, "Added Team : " + t.getName());
        this.myTeams.add(t);
    }

    @Override
    public void removeTeam(Team t) {
        if (t == null) {
            throw new NullPointerException("Team is NULL.");
        }
        if (!this.myTeams.contains(t)) {
            throw new RuntimeException("Team " + t + " is not in the round list.");
        }
        log.log(Level.INFO, "Removed Team : " + t.getName());
        this.myTeams.remove(t);
    }

    @Override
    public Team[] getAllTeams() {
        return this.myTeams.toArray(new Team[this.myTeams.size()]);
    }

    @Override
    public Team getTeamByName(String name) {
        Team[] all = this.getAllTeams();
        for (int t = 0; t < all.length; ++t) {
            if (!all[t].getName().equalsIgnoreCase(name)) continue;
            return all[t];
        }
        return null;
    }

    @Override
    public void start(WorkspaceFactory workspaceFactory, boolean resume) throws IOException {
        int t;
        if (this.isStarted()) {
            return;
        }
        Team[] tm = this.getAllTeams();
        for (t = 0; t < tm.length; ++t) {
            ((TeamImpl)tm[t]).initWorkspace(workspaceFactory);
        }
        this.loadAssignment(resume);
        for (t = 0; t < tm.length; ++t) {
            this.myRules.start(tm[t]);
        }
    }

    @Override
    public boolean isFinished() {
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            if (this.myRules.getState(tm[t]) == 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStarted() {
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            if (this.myRules.getState(tm[t]) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Assignment getAssignment() {
        return this.myAssignment;
    }

    @Override
    public GameRules getGameRules() {
        return this.myRules;
    }

    @Override
    public void logReport() {
        log.info("------ Round Report -------");
        if (this.isFinished()) {
            log.info("Round has finished.");
        } else {
            log.info("Round has not finished (!).");
        }
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            if (tm[t].isFinished()) {
                log.info("Team : " + tm[t].getName() + " scored " + tm[t].getFinalScore() + " points.");
                continue;
            }
            log.info("Team : " + tm[t].getName() + " was still working. Theoretical score : " + tm[t].getTheoreticalScore() + " points.");
        }
        log.info("------ ----- ------ -------");
    }

    @Override
    public int getTeamsOnline() {
        int cnt = 0;
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            if (!tm[t].isOnline()) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int getTeamCount() {
        return this.myTeams.size();
    }

    @Override
    public void dispose() {
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            tm[t].getWorkspace().dispose();
        }
    }

    @Override
    public void suspend() {
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            tm[t].getWorkspace().suspend();
        }
    }

    @Override
    public void load(State st) {
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            this.myRules.load(this, tm[t], st);
        }
    }

    @Override
    public void loadAssignment(boolean resume) throws IOException {
        Team[] tm = this.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            tm[t].getWorkspace().loadAssignment(this.getAssignment(), resume);
        }
    }
}

