/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ShellProcess
implements Runnable {
    private String command;
    private String[] env;
    private File work;
    private BufferedReader stdOut;
    private BufferedReader stdErr;
    private List results;
    private List errors;
    private int exitCode;

    public ShellProcess(String command, String[] env, File workDir) {
        if (command == null) {
            throw new NullPointerException("Null command.");
        }
        if (workDir == null) {
            throw new NullPointerException("Null WorkDir.");
        }
        if (!workDir.exists()) {
            throw new RuntimeException("WorkDir does not exist.");
        }
        if (env == null) {
            env = new String[]{};
        }
        this.command = command;
        this.env = env;
        this.work = workDir;
        this.results = new ArrayList();
        this.errors = new ArrayList();
    }

    @Override
    public void run() {
        try {
            boolean goOn;
            Process p = Runtime.getRuntime().exec(this.command, this.env, this.work);
            this.stdOut = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            do {
                goOn = false;
                if (this.stdOut.ready()) {
                    String out = this.stdOut.readLine();
                    if (out != null) {
                        this.results.add(out);
                    }
                    goOn = true;
                }
                if (this.stdErr.ready()) {
                    String err = this.stdErr.readLine();
                    if (err != null) {
                        this.errors.add(err);
                    }
                    goOn = true;
                }
                if (goOn) continue;
                try {
                    Thread.sleep(250L);
                    this.exitCode = p.exitValue();
                }
                catch (IllegalThreadStateException ex) {
                    goOn = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (goOn);
        }
        catch (Exception ex) {
            Logger.getLogger("shell").warning("Shell process failed : " + ex);
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String[] getResults() {
        return this.results.toArray(new String[this.results.size()]);
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[this.errors.size()]);
    }
}

