/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessPool {
    private static Logger myLog = Logger.getLogger("ProcessPool");
    private int maxProcesses;
    private List myQueueRunnables;
    private List myQueueCallbacks;
    private Map myActiveProcesses;

    public ProcessPool(int max) {
        this.maxProcesses = max;
        this.myQueueCallbacks = new ArrayList();
        this.myQueueRunnables = new ArrayList();
        this.myActiveProcesses = new HashMap();
    }

    public synchronized void execute(Runnable process, ProcessListener callback) {
        this.myQueueRunnables.add(process);
        this.myQueueCallbacks.add(callback);
        if (callback != null) {
            callback.queued(process);
        }
        if (process instanceof ProcessListener) {
            ((ProcessListener)((Object)process)).queued(process);
        }
        if (this.myActiveProcesses.size() < this.maxProcesses) {
            this.launchNext();
        }
    }

    synchronized void launchNext() {
        if (this.myQueueRunnables.size() == 0) {
            return;
        }
        ProcessListener lst = (ProcessListener)this.myQueueCallbacks.get(0);
        Runnable r = (Runnable)this.myQueueRunnables.get(0);
        this.myQueueCallbacks.remove(0);
        this.myQueueRunnables.remove(0);
        myLog.fine("Starting new Process.");
        Thread t = new Thread(new RunnableWrapper(r));
        t.setPriority(1);
        t.setDaemon(true);
        this.myActiveProcesses.put(r, lst);
        t.start();
    }

    synchronized void markExecuting(Runnable r) {
        try {
            ProcessListener pr = (ProcessListener)this.myActiveProcesses.get(r);
            if (pr != null) {
                pr.executing(r);
            }
            if (r instanceof ProcessListener) {
                ((ProcessListener)((Object)r)).executing(r);
            }
        }
        catch (Exception ex) {
            myLog.log(Level.WARNING, "Notification failed (Executing).", ex);
        }
    }

    synchronized void markFinished(Runnable r) {
        try {
            ProcessListener pr = (ProcessListener)this.myActiveProcesses.get(r);
            if (pr != null) {
                pr.complete(r);
            }
            if (r instanceof ProcessListener) {
                ((ProcessListener)((Object)r)).complete(r);
            }
        }
        catch (Exception ex) {
            myLog.log(Level.WARNING, "Notification failed (Finished) : " + ex.getMessage(), ex);
        }
        this.myActiveProcesses.remove(r);
        myLog.fine("Process finished.");
        if (this.myActiveProcesses.size() < this.maxProcesses) {
            this.launchNext();
        }
    }

    private final class RunnableWrapper
    implements Runnable {
        private Runnable myRunnable;

        public RunnableWrapper(Runnable r) {
            this.myRunnable = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProcessPool.this.markExecuting(this.myRunnable);
            try {
                this.myRunnable.run();
            }
            catch (Throwable ex) {
                myLog.log(Level.SEVERE, ex.getClass().getName() + " : " + ex.getMessage(), ex);
            }
            finally {
                ProcessPool.this.markFinished(this.myRunnable);
            }
        }
    }

    public static interface ProcessListener {
        public void queued(Runnable var1);

        public void executing(Runnable var1);

        public void complete(Runnable var1);
    }
}

