/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.operation;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.operation.AbstractOperation;
import nl.moj.operation.AbstractOperationRunnable;
import nl.moj.process.ProcessPool;
import nl.moj.test.TesterImpl;

public class Test
extends AbstractOperation {
    private Tester myTester;

    public Test(Assignment a, ProcessPool pool, Operation.Configuration cfg) throws Exception {
        super("Test", "Tests your implementation against unit tests.", false, pool);
        String testerClassName = cfg.getParameter(this, "CLASS");
        String testerJarFile = cfg.getParameter(this, "JAR");
        File base = cfg.getParentDir(this);
        int testerTimeout = Integer.parseInt(cfg.getParameter(this, "TIMEOUT"));
        File testerJar = new File(base, testerJarFile);
        if (!testerJar.exists() && !(testerJar = new File(testerJarFile)).exists()) {
            throw new IOException("The tester-jar file '" + testerJarFile + "' could not be found.");
        }
        this.myTester = new TesterImpl(a, testerClassName, testerJar, testerTimeout);
    }

    public Test(Assignment a, ProcessPool pool, File sourceJar) throws Exception {
        super("Test", "Tests your implementation against unit tests.", false, pool);
        this.myTester = new TesterImpl(a, a.getTestClass(), sourceJar, a.getTestClassTimeout());
    }

    public Test(Assignment a, ProcessPool pool, File[] classFiles) throws Exception {
        super("Test", "Tests your implementation against unit tests.", false, pool);
        this.myTester = new TesterImpl(a, a.getTestClass(), classFiles, a.getTestClassTimeout());
    }

    @Override
    public boolean isSubmit() {
        return false;
    }

    @Override
    public void perform(Workspace.Internal ws, ProcessPool.ProcessListener lst, Operation.Context ctx) {
        TestWrapper proc = new TestWrapper(this, this.myTester, ws, ctx);
        this.getPool().execute(proc, lst);
    }

    public Tester getTester() {
        return this.myTester;
    }

    public static class TestWrapper
    extends AbstractOperationRunnable
    implements Team.TestResults {
        private Tester myTst;
        private Tester.TestResult results;

        public TestWrapper(Operation op, Tester tst, Workspace.Internal ws, Operation.Context ctx) {
            super(op, ws, ctx);
            this.myTst = tst;
        }

        @Override
        public void run() {
            try {
                this.save();
                boolean ok = true;
                if (!this.getWorkspace().isCompiled()) {
                    this.getWorkspace().getTarget().append(null, "Compiling..\n");
                    ok = this.compile();
                }
                if (ok) {
                    this.getWorkspace().getTarget().append(null, "Testing..\n");
                    this.results = this.getContext().getIndex() < 0 ? this.myTst.performTest(this.getWorkspace()) : this.myTst.performTest(this.getWorkspace(), this.getContext().getIndex());
                } else {
                    this.getWorkspace().getTarget().append(null, "Compilation Failed.\n");
                }
            }
            catch (Throwable ex) {
                Logger.getLogger(this.getWorkspace().getName()).log(Level.SEVERE, "Test Failed.", ex);
            }
        }

        @Override
        public Tester.TestResult getTestResults() {
            return this.results;
        }

        @Override
        public void complete(Runnable r) {
            OutputRedirector.Target out = this.getWorkspace().getTarget();
            if (this.results == null) {
                out.append(null, "Failed Test : Illegal operation, timeout or compilation error.\n");
            } else {
                out.append(null, this.results.isOk() ? "Test : Pass.\n" : "Test : Failed.\n");
                StringBuffer sb = new StringBuffer();
                int[] b = this.results.getResults();
                for (int t = 0; t < b.length; ++t) {
                    if (b[t] == 0) {
                        sb.append(". ");
                    }
                    if (b[t] == 1) {
                        sb.append("V ");
                    }
                    if (b[t] != -1) continue;
                    sb.append("X ");
                }
                sb.append("\n");
                out.append(null, sb.toString());
            }
        }
    }
}

