/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.operation;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.operation.AbstractOperation;
import nl.moj.operation.AbstractOperationRunnable;
import nl.moj.process.ProcessPool;
import nl.moj.test.TesterImpl;

public class Submit
extends AbstractOperation {
    private Tester myTester;

    public Submit(Assignment a, ProcessPool pool, Operation.Configuration cfg) throws Exception {
        super("Submit", "Ends the game and evaluates your solution.", true, pool);
        String testerClassName = cfg.getParameter(this, "CLASS");
        String testerJarFile = cfg.getParameter(this, "JAR");
        File base = cfg.getParentDir(this);
        int testerTimeout = Integer.parseInt(cfg.getParameter(this, "TIMEOUT"));
        File testerJar = new File(base, testerJarFile);
        if (!testerJar.exists() && !(testerJar = new File(testerJarFile)).exists()) {
            throw new IOException("The submit-tester-jar file '" + testerJarFile + "' could not be found.");
        }
        this.myTester = new TesterImpl(a, testerClassName, testerJar, testerTimeout);
    }

    public Submit(Assignment a, ProcessPool pool, File sourceJar) throws Exception {
        super("Submit", "Ends the game and evaluates your solution.", true, pool);
        this.myTester = new TesterImpl(a, a.getSubmitClass(), sourceJar, a.getSubmitClassTimeout());
    }

    public Submit(Assignment a, ProcessPool pool, File[] classFiles) throws Exception {
        super("Submit", "Ends the game and evaluates your solution.", true, pool);
        this.myTester = new TesterImpl(a, a.getSubmitClass(), classFiles, a.getSubmitClassTimeout());
    }

    @Override
    public boolean isSubmit() {
        return true;
    }

    @Override
    public void perform(Workspace.Internal ws, ProcessPool.ProcessListener lst, Operation.Context ctx) {
        SubmitWrapper proc = new SubmitWrapper(this, ws, this.myTester, ctx);
        this.getPool().execute(proc, lst);
    }

    public static class SubmitWrapper
    extends AbstractOperationRunnable
    implements Team.TestResults {
        private Tester tester;
        private Tester.TestResult results;
        boolean compilationError;

        public SubmitWrapper(Operation parent, Workspace.Internal ws, Tester tst, Operation.Context ctx) {
            super(parent, ws, ctx);
            this.tester = tst;
            this.results = null;
        }

        @Override
        public void run() {
            int retries = 0;
            try {
                while (this.results == null) {
                    boolean ok = true;
                    this.save();
                    if (!this.getWorkspace().isCompiled()) {
                        Logger.getLogger(this.getWorkspace().getName()).info("Compiling for Submit.");
                        this.getWorkspace().getTarget().append(null, "Compiling..\n");
                        ok = this.compile();
                    }
                    if (ok) {
                        Logger.getLogger(this.getWorkspace().getName()).info("Testing for Submit.");
                        this.compilationError = false;
                        this.getWorkspace().getTarget().append(null, "Testing..\n");
                        this.results = this.tester.performTest(this.getWorkspace());
                        Logger.getLogger(this.getWorkspace().getName()).info("Testing completed: " + (this.results != null ? (this.results.isOk() ? "Ok" : "Failed") : "Null"));
                        continue;
                    }
                    this.compilationError = true;
                    if (retries++ < 2) {
                        Logger.getLogger(this.getWorkspace().getName()).warning("Compilation for Submit failed. Retry.");
                        this.getWorkspace().getTarget().append(null, "Compilation Failed. Trying again.. \n");
                        continue;
                    }
                    this.getWorkspace().getTarget().append(null, "Compilation Failed.\n");
                    throw new RuntimeException("Compilation Failed.");
                }
            }
            catch (Throwable ex) {
                Logger.getLogger(this.getWorkspace().getName()).log(Level.SEVERE, "Test Failed.", ex);
            }
        }

        @Override
        public Tester.TestResult getTestResults() {
            return this.results;
        }

        @Override
        public void complete(Runnable r) {
            OutputRedirector.Target out = this.getWorkspace().getTarget();
            if (this.results == null) {
                if (this.compilationError) {
                    out.append(null, "Submit Rejected because of compilation error.");
                } else {
                    out.append(null, "Submit Rejected : Illegal operation or timeout.");
                }
            } else {
                out.append(null, this.results.isOk() ? "Submit : Accepted.\n" : "Submit : Rejected.\n");
                StringBuffer sb = new StringBuffer();
                boolean[] b = this.results.getScore();
                for (int t = 0; t < b.length; ++t) {
                    sb.append(b[t] ? "V " : "X ");
                }
                sb.append("\n");
                out.append(null, sb.toString());
            }
        }
    }
}

