/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.mgmt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nl.ctrlaltdev.ui.Build;
import nl.ctrlaltdev.util.Tool;
import nl.moj.mgmt.TeamProfileList;

public class TeamProfileListManager
extends JPanel {
    private static final int WHAT_NAME = 0;
    private static final int WHAT_PWD = 1;
    private static final int WHAT_DISPLAY = 2;
    private static final int WHAT_ASSIGNMENT = 3;
    private static final Color ODD = new Color(240, 240, 240);
    private static final Color EVEN = new Color(220, 220, 220);
    private TeamProfileList myTPL;
    private File mySourceFile;
    private JScrollPane list;
    private JButton saveButton = new JButton("Save");
    private JButton addButton = new JButton("Add");
    private JButton formButton = new JButton("Generate Login Forms");
    private JButton csvButton = new JButton("Save as CSV");
    private JCheckBox encodePwd = new JCheckBox("Encode passwords");
    private String[] roundLineup;
    private String[] assignmentModel;
    private boolean skipMode;

    public TeamProfileListManager() {
        super(new BorderLayout());
        this.myTPL = new TeamProfileList();
        this.init(null);
    }

    public File getFile() {
        return this.mySourceFile;
    }

    public Color getOddColor() {
        return ODD;
    }

    public Color getEvenColor() {
        return EVEN;
    }

    public TeamProfileListManager(File src) throws IOException {
        super(new BorderLayout());
        this.mySourceFile = src;
        this.myTPL = new TeamProfileList(src);
        this.init(null);
    }

    public TeamProfileListManager(File src, String lineup) throws IOException {
        super(new BorderLayout());
        this.mySourceFile = src;
        this.myTPL = new TeamProfileList(src);
        this.init(Tool.cut(lineup, ","));
    }

    protected void init(String[] lineup) {
        this.findAssignments(new File("./data/cases/"));
        if (lineup != null) {
            this.setLineup(lineup);
        }
        this.rebuildTeamList(this.myTPL);
        this.add((Component)this.buildButtonBar(), "South");
    }

    protected void setLineup(String[] assignments) {
        this.roundLineup = assignments;
        this.skipMode = true;
    }

    protected void findAssignments(File dir) {
        ArrayList<String> cb = new ArrayList<String>();
        cb.add("");
        this.findAssignments(dir, cb);
        this.assignmentModel = cb.toArray(new String[cb.size()]);
        this.skipMode = false;
    }

    protected void findAssignments(File f, List cb) {
        File[] jars = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.getName().startsWith(".")) {
                    return true;
                }
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        });
        for (int t = 0; t < jars.length; ++t) {
            if (jars[t].isDirectory()) {
                this.findAssignments(jars[t], cb);
                continue;
            }
            cb.add(jars[t].getName().substring(0, jars[t].getName().length() - 4));
        }
    }

    protected TeamProfileList getTeamProfileList() {
        return this.myTPL;
    }

    protected JComponent buildButtonBar() {
        this.addButton.addActionListener(new AddAction());
        this.saveButton.addActionListener(new SaveAction());
        this.formButton.addActionListener(new GenerateFormsAction());
        this.csvButton.addActionListener(new SaveAsCSVAction());
        return new Build.RFP(new Build.BOXX(new JComponent[]{this.formButton, null, this.encodePwd, null, this.addButton, null, this.csvButton, this.saveButton}));
    }

    protected void rebuildTeamList(TeamProfileList l) {
        if (this.list != null) {
            this.remove(this.list);
        }
        this.list = new JScrollPane(new Build.NBOXY(new JComponent[]{this.buildTeamList(this.myTPL)}));
        this.add((Component)this.list, "Center");
        this.invalidate();
        this.repaint();
        this.validate();
    }

    protected JComponent buildTeamList(TeamProfileList l) {
        JPanel result = new JPanel(new GridLayout(0, 5));
        result.add(new Build.CFP(new JLabel("TeamName")));
        result.add(new Build.CFP(new JLabel("Password")));
        result.add(new Build.CFP(new JLabel("Display Name")));
        result.add(new Build.CFP(new JLabel("Exclude")));
        result.add(new Build.CFP(new JLabel("")));
        int[] seq = l.getRegistrationSequence();
        for (int t = 0; t < l.getNumberOfTeams(); ++t) {
            int idx = seq[t];
            JTextField nameField = new JTextField(l.getTeamName(idx), 12);
            JTextField pwdField = new JTextField(l.getPassword(idx), 12);
            JTextField displayField = new JTextField(l.getDisplayName(idx), 12);
            JComboBox<String> excludedField = new JComboBox<String>();
            excludedField.setModel(new DefaultComboBoxModel<String>(this.assignmentModel));
            excludedField.setEditable(true);
            excludedField.setSelectedItem(l.getExcludeAssignment(idx));
            JButton removeButton = new JButton("Del");
            JButton pwdButton = new JButton("Pwd");
            removeButton.setVerifyInputWhenFocusTarget(false);
            removeButton.addActionListener(new RemoveAction(idx));
            pwdButton.addActionListener(new ClearPwdAction(pwdButton, pwdField));
            nameField.setInputVerifier(new FieldInputVerifier(nameField, idx, 0));
            pwdField.setInputVerifier(new FieldInputVerifier(pwdField, idx, 1));
            pwdField.setEnabled(!this.myTPL.isEncodedPassword(idx));
            pwdButton.setEnabled(!pwdField.isEnabled());
            displayField.setInputVerifier(new FieldInputVerifier(displayField, idx, 2));
            excludedField.addActionListener(new FieldInputVerifier(excludedField, idx, 3));
            pwdField.setCaretPosition(0);
            Color c = t % 2 == 0 ? this.getOddColor() : this.getEvenColor();
            JLabel lidx = new JLabel(String.valueOf(l.getRegistrationIndex(idx)));
            lidx.setMinimumSize(new Dimension(24, 24));
            lidx.setPreferredSize(new Dimension(24, 24));
            result.add(new Build.LFP(new JComponent[]{lidx, nameField}, c));
            result.add(new Build.LFP((JComponent)pwdField, c));
            result.add(new Build.LFP((JComponent)displayField, c));
            result.add(new Build.LFP(excludedField, c));
            result.add(new Build.LFP(new JComponent[]{removeButton, pwdButton}, c));
        }
        return result;
    }

    public boolean canClose() {
        return true;
    }

    public static void main(String[] args) throws IOException {
        final TeamProfileListManager tpm = (args = Tool.parseArgs(args)).length == 2 ? new TeamProfileListManager(new File(args[0]), args[1]) : (args.length == 1 ? new TeamProfileListManager(new File(args[0])) : new TeamProfileListManager());
        JFrame f = new JFrame("Team Profile Manager (" + tpm.getFile() + ")");
        f.setSize(640, 480);
        f.getContentPane().add(tpm);
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (tpm.canClose()) {
                    System.exit(0);
                }
            }
        });
    }

    private class GenerateFormsAction
    implements ActionListener {
        private String[] TIMES = new String[]{"09:00 - 09:30 uur", "09:30 - 10:00 uur", "10:15 - 10:45 uur", "11:00 - 11:30 uur", "11:45 - 12:15 uur", "12:15 - 13:30 uur", "13:30 - 14:00 uur", "14:15 - 14:45 uur", "15:15 - 15:45 uur", "16:00 uur"};
        private int[] ROUNDS = new int[]{-3, -4, 1, 2, 3, -1, 4, 5, 6, -2};

        private GenerateFormsAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (TeamProfileListManager.this.skipMode && TeamProfileListManager.this.roundLineup.length < 6) {
                throw new RuntimeException("6 Lined up Rounds are required for generating these forms in skip mode.");
            }
            int year = Calendar.getInstance().get(1);
            File root = new File("./data/teams/");
            if (!root.exists()) {
                root.mkdirs();
            }
            for (int t = 0; t < TeamProfileListManager.this.myTPL.getNumberOfTeams(); ++t) {
                String displayName = TeamProfileListManager.this.myTPL.getDisplayName(t);
                String loginName = TeamProfileListManager.this.myTPL.getTeamName(t);
                String password = TeamProfileListManager.this.myTPL.getPassword(t);
                Integer regIdx = TeamProfileListManager.this.myTPL.getRegistrationIndex(t);
                String exclude = TeamProfileListManager.this.myTPL.getExcludeAssignment(t);
                StringBuffer sb = new StringBuffer();
                sb.append("<html><body><center>");
                sb.append("<h1>Masters of Java " + year + "</h1>");
                sb.append("</br></br>");
                sb.append("<table border=0 width=512>\n");
                sb.append("<tr><th style=\"border-bottom:1px solid black;\" colspan=2><B>Team gegevens</B></th></tr>\n");
                sb.append("<tr><td width=\"50%\" align=right>Team Naam :</td><td width=\"50%\">");
                sb.append(displayName);
                sb.append("</td></tr>\n");
                sb.append("<tr><td align=right>Inschrijving :</td><td>");
                sb.append(regIdx + 1 + "/" + TeamProfileListManager.this.myTPL.getNumberOfTeams());
                sb.append("</td></tr>\n\n");
                sb.append("<tr><td align=right><B>Login :</B></td><td>");
                sb.append(loginName);
                sb.append("</td></tr>");
                sb.append("<tr><td align=right><B>Password :</B></td><td>");
                sb.append(password);
                sb.append("</td></tr>\n");
                sb.append("</table>\n");
                sb.append("<br/>Je Login is niet case-sensitive. Je Password is dat wel !");
                sb.append("<br/><br/><br/>");
                sb.append("<table border=0 width=512>\n");
                sb.append("<tr><th style=\"border-bottom:1px solid black;\" colspan=2><B>Agenda</B></th></tr>\n");
                boolean skip = false;
                for (int r = 0; r < this.ROUNDS.length; ++r) {
                    sb.append("<tr><td align=center>");
                    sb.append(this.TIMES[r]);
                    sb.append("</td><td>");
                    switch (this.ROUNDS[r]) {
                        case -4: {
                            sb.append("Proefronde");
                            break;
                        }
                        case -3: {
                            sb.append("Ontvangst en registratie");
                            break;
                        }
                        case -2: {
                            sb.append("Prijsuitreiking");
                            break;
                        }
                        case -1: {
                            sb.append("Lunch pauze");
                            break;
                        }
                        default: {
                            if (TeamProfileListManager.this.skipMode && exclude.equals(TeamProfileListManager.this.roundLineup[this.ROUNDS[r] - 1])) {
                                skip = true;
                                sb.append("Ronde " + this.ROUNDS[r] + " : Telt niet mee");
                                break;
                            }
                            sb.append("Ronde " + this.ROUNDS[r]);
                        }
                    }
                    sb.append("</td></tr>\n");
                }
                sb.append("</table>\n");
                sb.append("<p style=\"margin-left:10%;margin-right:10%;\" align=left>");
                if (skip) {
                    sb.append("Ieder team speelt <i>5 van de 6</i> rondes. De ronde die voor jouw team niet telt ");
                    sb.append("staat hierboven aangegeven. De winnaar van een ronde is diegene die als ");
                    sb.append("eerste zijn goede oplossing instuurt en scoort hiervoor <i>20</i> punten. Volgende ");
                    sb.append("succesvolle inzendingen krijgen respectievelijk : 18,16,14,12 en 10 punten. ");
                    sb.append("Inzendingen die daarna komen krijgen 1 punt voor de moeite. Lever je iets in ");
                    sb.append("dat niet goed werkt of je levert helemaal niets in dan krijg je 0 punten. ");
                } else {
                    sb.append("Ieder team speelt alle ronden. Een ronde duurt 30 minuten. Voor het insturen van een ");
                    sb.append("goede oplossing scoor je (400 + het aantal seconden dat je over hebt) punten. ");
                    sb.append("Lever je iets in dat niet goed werkt of je levert helemaal niets in dan krijg je 0 punten. ");
                    sb.append("Of iets een goede oplossing is wordt bepaald door de unit tests van die opgave. ");
                    sb.append("Sommige opgaven hebben een extra verborgen test(!). Welke opgaven dat zijn wordt vantevoren verteld. ");
                    sb.append("Winnaar is dat team dat over alle 6 de rondes de meeste punten weet te scoren. ");
                }
                sb.append("</p>");
                sb.append("</br><I>Heel veel plezier en succes met Masters of Java !</I>");
                sb.append("</center></body></html>\n");
                File fout = new File(root, "" + (regIdx + 1) + loginName + ".html");
                try {
                    FileWriter f = new FileWriter(fout);
                    try {
                        f.write(sb.toString());
                        continue;
                    }
                    finally {
                        f.close();
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(TeamProfileListManager.this.list, "Error writing '" + fout.getName() + "' : " + ex.getMessage());
                    return;
                }
            }
        }
    }

    private class SaveAsCSVAction
    implements ActionListener {
        private SaveAsCSVAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            File csvFile = null;
            JFileChooser fc = new JFileChooser(new File("."));
            int returnVal = fc.showSaveDialog(TeamProfileListManager.this);
            if (returnVal != 0) {
                return;
            }
            csvFile = fc.getSelectedFile();
            if (csvFile == null) {
                return;
            }
            try {
                FileOutputStream fout = new FileOutputStream(csvFile);
                try {
                    TeamProfileListManager.this.myTPL.saveAsCSV(fout, TeamProfileListManager.this.skipMode ? TeamProfileListManager.this.roundLineup : new String[]{});
                }
                finally {
                    fout.close();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(TeamProfileListManager.this, "Error saving file : " + ex);
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (TeamProfileListManager.this.mySourceFile == null) {
                JFileChooser fc = new JFileChooser(new File("."));
                int returnVal = fc.showSaveDialog(TeamProfileListManager.this);
                if (returnVal == 0) {
                    TeamProfileListManager.this.mySourceFile = fc.getSelectedFile();
                } else {
                    return;
                }
            }
            if (TeamProfileListManager.this.mySourceFile == null) {
                return;
            }
            try {
                FileOutputStream fout = new FileOutputStream(TeamProfileListManager.this.mySourceFile);
                try {
                    TeamProfileListManager.this.myTPL.save(fout, TeamProfileListManager.this.encodePwd.isSelected());
                }
                finally {
                    fout.close();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(TeamProfileListManager.this, "Error saving file : " + ex);
            }
            TeamProfileListManager.this.rebuildTeamList(TeamProfileListManager.this.myTPL);
        }
    }

    private class ClearPwdAction
    implements ActionListener {
        private JButton b;
        private JTextField f;

        public ClearPwdAction(JButton b, JTextField f) {
            this.b = b;
            this.f = f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.f.setEnabled(true);
            this.f.setText("");
            this.b.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClearPwdAction.this.f.requestFocus();
                }
            });
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tname = JOptionPane.showInputDialog(TeamProfileListManager.this, (Object)"Enter team name");
            if (tname == null) {
                return;
            }
            try {
                TeamProfileListManager.this.myTPL.addTeam(tname, "Welkom", "", null);
            }
            catch (RuntimeException ex) {
                JOptionPane.showMessageDialog(TeamProfileListManager.this, ex.getMessage());
                return;
            }
            TeamProfileListManager.this.rebuildTeamList(TeamProfileListManager.this.myTPL);
        }
    }

    private class RemoveAction
    implements ActionListener {
        private int idx;

        public RemoveAction(int idx) {
            this.idx = idx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(TeamProfileListManager.this, "Delete this team ?", "Sure", 0) == 0) {
                TeamProfileListManager.this.myTPL.deleteTeam(this.idx);
                TeamProfileListManager.this.rebuildTeamList(TeamProfileListManager.this.myTPL);
            }
        }
    }

    private class FieldInputVerifier
    extends InputVerifier
    implements ActionListener {
        private int idx;
        private int what;
        private JComponent txtField;
        private String msg;

        public FieldInputVerifier(JComponent txt, int idx, int what) {
            this.txtField = txt;
            this.idx = idx;
            this.what = what;
        }

        @Override
        public boolean verify(JComponent e) {
            try {
                switch (this.what) {
                    case 0: {
                        TeamProfileListManager.this.myTPL.setTeamName(this.idx, ((JTextField)this.txtField).getText());
                        break;
                    }
                    case 1: {
                        TeamProfileListManager.this.myTPL.setPassword(this.idx, ((JTextField)this.txtField).getText());
                        break;
                    }
                    case 2: {
                        TeamProfileListManager.this.myTPL.setDisplayName(this.idx, ((JTextField)this.txtField).getText());
                        break;
                    }
                    case 3: {
                        TeamProfileListManager.this.myTPL.setExcludedAssignment(this.idx, (String)((JComboBox)this.txtField).getModel().getSelectedItem());
                    }
                }
                return true;
            }
            catch (RuntimeException ex) {
                this.msg = ex.getMessage();
                return false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.verify((JComponent)e.getSource());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldYieldFocus(JComponent input) {
            this.msg = null;
            boolean result = super.shouldYieldFocus(input);
            if (!result && this.msg != null) {
                InputVerifier old = input.getInputVerifier();
                input.setInputVerifier(null);
                try {
                    JOptionPane.showMessageDialog(input, this.msg);
                }
                finally {
                    input.setInputVerifier(old);
                }
            }
            return result;
        }
    }
}

