/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.clock;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.moj.model.Clock;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;

public class SimpleClock
implements Clock,
Runnable {
    private static final Timer theTimer = new Timer();
    public static final Logger log = Logger.getLogger("Clock");
    public static final long DELTA_DIV = 1000L;
    private long referenceTime;
    private boolean isRunning;
    private int mins;
    private int secs;
    private int resetMins;
    private int resetSecs;
    private int lastMins;
    private List myNoti = new ArrayList();
    private int secondsPassed;
    private int durationInMinutes;
    private boolean wasStarted;

    public SimpleClock(int durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
        this.resetMins = 0;
        this.resetSecs = 0;
        this.reset();
        this.stop();
        theTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SimpleClock.this.run();
            }
        }, 250L, 250L);
    }

    @Override
    public void stop() {
        if (this.isRunning) {
            long delta = System.currentTimeMillis() - this.referenceTime;
            this.secs += (int)(delta /= 1000L) % 60;
            this.mins += (int)delta / 60;
            while (this.secs > 60) {
                ++this.mins;
                this.secs -= 60;
            }
            this.isRunning = false;
            this.fireClockStopped();
        }
    }

    @Override
    public void run() {
        int rmins = this.mins;
        int rsecs = this.secs;
        if (this.isRunning) {
            long delta = System.currentTimeMillis() - this.referenceTime;
            int dsecs = (int)(delta /= 1000L) % 60;
            int dmins = (int)delta / 60;
            rmins += dmins;
            rsecs += dsecs;
            while (rsecs >= 60) {
                ++rmins;
                rsecs -= 60;
            }
            if (rmins >= this.durationInMinutes) {
                rsecs = 0;
                rmins = this.durationInMinutes;
            }
            this.secondsPassed = rmins * 60 + rsecs;
            if (this.lastMins != rmins) {
                this.lastMins = rmins;
                this.fireMinutePassed(this.durationInMinutes - this.lastMins);
                if (this.durationInMinutes == this.lastMins) {
                    this.stop();
                }
            }
        }
        if (this.isFinished()) {
            this.secs = 0;
            this.mins = this.durationInMinutes;
        }
    }

    @Override
    public void addNotifier(Clock.Notification nf) {
        this.myNoti.add(nf);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void start() {
        if (!this.isFinished()) {
            this.isRunning = true;
            this.referenceTime = System.currentTimeMillis();
            this.fireClockStarted();
            this.wasStarted = true;
        }
    }

    @Override
    public boolean isStarted() {
        return this.wasStarted;
    }

    @Override
    public boolean isFinished() {
        return this.secondsPassed >= this.getDuration();
    }

    @Override
    public boolean isStartPosition() {
        return this.mins == 0 && this.secs == 0 && !this.wasStarted;
    }

    @Override
    public int getDuration() {
        return this.durationInMinutes * 60;
    }

    @Override
    public int getDurationInMinutes() {
        return this.durationInMinutes;
    }

    @Override
    public int getSecondsRemaining() {
        return this.durationInMinutes * 60 - this.secondsPassed;
    }

    @Override
    public int getSecondsPassed() {
        return this.secondsPassed;
    }

    @Override
    public void reset() {
        if (this.isRunning) {
            this.stop();
        }
        this.mins = this.resetMins;
        this.secs = this.resetSecs;
        this.lastMins = this.resetMins;
        this.wasStarted = false;
        this.fireClockReset();
    }

    private void fireClockReset() {
        for (int t = 0; t < this.myNoti.size(); ++t) {
            try {
                ((Clock.Notification)this.myNoti.get(t)).clockReset();
                continue;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Reset Notification failure", ex);
                ex.printStackTrace();
            }
        }
    }

    private void fireClockStarted() {
        for (int t = 0; t < this.myNoti.size(); ++t) {
            try {
                ((Clock.Notification)this.myNoti.get(t)).clockStarted();
                continue;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Start Notification failure", ex);
                ex.printStackTrace();
            }
        }
    }

    private void fireMinutePassed(int min) {
        for (int t = 0; t < this.myNoti.size(); ++t) {
            try {
                if (min == this.durationInMinutes) {
                    ((Clock.Notification)this.myNoti.get(t)).clockFinished();
                    continue;
                }
                ((Clock.Notification)this.myNoti.get(t)).minutePassed(min);
                continue;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Tick Notification failure", ex);
                ex.printStackTrace();
            }
        }
    }

    private void fireClockStopped() {
        for (int t = 0; t < this.myNoti.size(); ++t) {
            try {
                ((Clock.Notification)this.myNoti.get(t)).clockStopped();
                continue;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Stop Notification failure", ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void load(Round rnd, Team tm, State s) {
        if (s.isFinished(rnd, tm)) {
            this.secondsPassed = this.durationInMinutes * 60;
            this.mins = this.durationInMinutes;
            this.secs = 0;
            this.resetMins = this.mins;
            this.resetSecs = this.secs;
            this.lastMins = this.mins;
        } else {
            this.wasStarted = s.isStarted(rnd, tm);
            int remain = s.getTimeRemaining(rnd, tm);
            if (remain >= 0) {
                this.secondsPassed = this.getDuration() - remain;
                this.mins = this.secondsPassed / 60;
                this.secs = this.secondsPassed % 60;
                this.resetMins = this.mins;
                this.resetSecs = this.secs;
                this.lastMins = this.mins;
            }
        }
    }
}

