/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataInput;
import java.io.IOException;
import nl.moj.client.io.ActionMessageImpl;
import nl.moj.client.io.AddActionMessageImpl;
import nl.moj.client.io.AnimationMessageImpl;
import nl.moj.client.io.AssignmentMessageImpl;
import nl.moj.client.io.ConsoleMessageImpl;
import nl.moj.client.io.EditorMessageImpl;
import nl.moj.client.io.GoodbyeMessageImpl;
import nl.moj.client.io.HelloMessageImpl;
import nl.moj.client.io.LogonFailureMessageImpl;
import nl.moj.client.io.Message;
import nl.moj.client.io.NoOpMessageImpl;
import nl.moj.client.io.ProtocolVersionMismatchMessageImpl;
import nl.moj.client.io.TestSetMessageImpl;
import nl.moj.client.io.UpdateClientStatisticsMessageImpl;

public class MessageFactory {
    public Message createMessage(DataInput in) throws IOException {
        int type = in.readInt();
        switch (type) {
            case 0: {
                return new HelloMessageImpl(type, in);
            }
            case 3: {
                return new ActionMessageImpl(type, in);
            }
            case 6: {
                return new AddActionMessageImpl(type, in);
            }
            case 2: {
                return new ConsoleMessageImpl(type, in);
            }
            case 1: {
                return new EditorMessageImpl(type, in);
            }
            case 4: {
                return new UpdateClientStatisticsMessageImpl(type, in);
            }
            case 7: {
                return new LogonFailureMessageImpl(type, in);
            }
            case 8: {
                return new TestSetMessageImpl(type, in);
            }
            case 9: {
                return new ProtocolVersionMismatchMessageImpl(type, in);
            }
            case 10: {
                return new AnimationMessageImpl(type, in);
            }
            case 11: {
                return new NoOpMessageImpl(type, in);
            }
            case 12: {
                return new GoodbyeMessageImpl(type, in);
            }
            case 13: {
                return new AssignmentMessageImpl(type, in);
            }
        }
        throw new IOException("Unsupported Message type : " + type);
    }
}

