/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.anim.Anim;
import nl.moj.client.anim.LayeredAnim;
import nl.moj.client.io.AbstractMessage;
import nl.moj.client.io.Message;

public class AnimationMessageImpl
extends AbstractMessage
implements Message.Animation {
    private int testNr;
    private Anim animation;

    public AnimationMessageImpl(int testNr, Anim a) {
        super(10);
        if (a == null) {
            throw new NullPointerException("Cannot send a NULL animation.");
        }
        this.testNr = testNr;
        this.animation = a;
    }

    public AnimationMessageImpl(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 10) {
            throw new IOException("Incorrect Type");
        }
        this.testNr = in.readInt();
        this.animation = new LayeredAnim();
        this.animation.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.testNr);
        this.animation.write(out);
    }

    @Override
    public Anim getAnimation() {
        return this.animation;
    }

    @Override
    public int getTest() {
        return this.testNr;
    }
}

