/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.io.AbstractMessage;
import nl.moj.client.io.Message;

public class ActionMessageImpl
extends AbstractMessage
implements Message.Action {
    private String myFile;
    private String myContents;
    private String myAction;
    private int myIndex;
    private int myKeyStrokes;

    public ActionMessageImpl(String file, String contents, String action, int keyStrokes) {
        this(file, contents, action, -1, keyStrokes);
    }

    public ActionMessageImpl(String file, String contents, String action, int idx, int keyStrokes) {
        super(3);
        this.myFile = file;
        this.myContents = contents;
        this.myAction = action;
        this.myIndex = idx;
        this.myKeyStrokes = keyStrokes;
    }

    public ActionMessageImpl(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 3) {
            throw new IOException("Incorrect Type");
        }
        this.myFile = in.readUTF();
        this.myContents = in.readUTF();
        this.myAction = in.readUTF();
        this.myIndex = in.readInt();
        this.myKeyStrokes = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myFile);
        out.writeUTF(this.myContents);
        out.writeUTF(this.myAction);
        out.writeInt(this.myIndex);
        out.writeInt(this.myKeyStrokes);
    }

    @Override
    public String getFileName() {
        return this.myFile;
    }

    @Override
    public String getContents() {
        return this.myContents;
    }

    @Override
    public String getAction() {
        return this.myAction;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public int getKeyStrokes() {
        return this.myKeyStrokes;
    }
}

