/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import java.util.StringTokenizer;
import nl.moj.client.codecompletion.statement.Declaration;
import nl.moj.client.codecompletion.statement.DeclarationStatement;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.Statement;

public class MethodStatement
extends DeclarationStatement {
    private String myType;
    private String myName;
    private String myParams;
    private DeclarationStatement myParent;

    public MethodStatement(DeclarationStatement parent, int pos, String[] words) {
        super(words, pos);
        int cnt;
        for (cnt = 0; cnt < words.length && MethodStatement.isModifier(words[cnt]); ++cnt) {
        }
        this.myType = words[cnt];
        if (words[++cnt].equals("[]")) {
            this.myType = this.myType + "[]";
            ++cnt;
        }
        this.myName = words[cnt].substring(0, words[cnt].indexOf("("));
        this.myParams = words[cnt].substring(words[cnt].indexOf("(") + 1, words[cnt].indexOf(")"));
        this.myParent = parent;
    }

    public String getType() {
        return this.expandImport(this.myType);
    }

    public boolean isArray() {
        return this.myType.endsWith("[]");
    }

    protected String expandImport(String type) {
        Statement p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return ((JavaFile)p).expandImport(type);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public Declaration[] getParams() {
        StringTokenizer st = new StringTokenizer(this.myParams, ",");
        Declaration[] result = new Declaration[st.countTokens()];
        for (int t = 0; t < result.length; ++t) {
            String combined = st.nextToken();
            String tp = combined.substring(0, combined.indexOf(32));
            String nm = combined.substring(combined.indexOf(32) + 1);
            result[t] = new Declaration(this.expandImport(tp), nm, tp.endsWith("[]"));
        }
        return result;
    }

    public static boolean qualifies(String[] words) {
        String method;
        int cnt;
        for (cnt = 0; cnt < words.length && MethodStatement.isModifier(words[cnt]); ++cnt) {
        }
        if (cnt > words.length - 2) {
            return false;
        }
        if (words[cnt + 1].equals("[]")) {
            ++cnt;
        }
        if (cnt > words.length - 2) {
            return false;
        }
        if (!MethodStatement.isPrimitive(words[cnt])) {
            // empty if block
        }
        if ((method = words[cnt + 1]).indexOf("(") < 0) {
            return false;
        }
        return method.indexOf(")") >= 0;
    }

    public Declaration getDeclaration() {
        return new Declaration(this.getType(), this.getName(), this.isArray());
    }

    @Override
    public String toString() {
        return "Method(" + this.myName + " returns " + this.myType + " with args " + this.myParams + ")";
    }

    @Override
    public Statement getParent() {
        return this.myParent;
    }
}

