/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import java.util.ArrayList;
import java.util.List;
import nl.moj.client.codecompletion.statement.AbstractStatement;
import nl.moj.client.codecompletion.statement.ClassStatement;
import nl.moj.client.codecompletion.statement.CompoundStatement;
import nl.moj.client.codecompletion.statement.Declaration;
import nl.moj.client.codecompletion.statement.DeclarationStatement;
import nl.moj.client.codecompletion.statement.FieldStatement;
import nl.moj.client.codecompletion.statement.ImportStatement;
import nl.moj.client.codecompletion.statement.InterfaceStatement;
import nl.moj.client.codecompletion.statement.MethodStatement;
import nl.moj.client.codecompletion.statement.PackageStatement;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementVisitor;
import nl.moj.client.codecompletion.statement.VariableDeclarationStatement;

public class JavaFile
implements CompoundStatement {
    public static final PackageStatement DEFAULTPACKAGE = new PackageStatement(null, 0, new String[]{"package", ""});
    private List<Statement> sub = new ArrayList<Statement>();

    @Override
    public void visit(StatementVisitor v, int indent, boolean isLast) {
        v.begin();
        for (int t = 0; t < this.sub.size(); ++t) {
            ((AbstractStatement)this.sub.get(t)).visit(v, indent + 1, t == this.sub.size() - 1);
        }
        v.end();
    }

    @Override
    public void addStatement(AbstractStatement stm) {
        this.sub.add(stm);
    }

    public PackageStatement getPackage() {
        for (int t = 0; t < this.sub.size(); ++t) {
            if (!(this.sub.get(t) instanceof PackageStatement)) continue;
            return (PackageStatement)this.sub.get(t);
        }
        return DEFAULTPACKAGE;
    }

    public ImportStatement[] getImports() {
        ArrayList<ImportStatement> results = new ArrayList<ImportStatement>();
        for (int t = 0; t < this.sub.size(); ++t) {
            if (!(this.sub.get(t) instanceof ImportStatement)) continue;
            results.add((ImportStatement)this.sub.get(t));
        }
        return results.toArray(new ImportStatement[results.size()]);
    }

    public ClassStatement[] getClasses() {
        ArrayList<ClassStatement> results = new ArrayList<ClassStatement>();
        for (int t = 0; t < this.sub.size(); ++t) {
            if (!(this.sub.get(t) instanceof ClassStatement)) continue;
            results.add((ClassStatement)this.sub.get(t));
        }
        return results.toArray(new ClassStatement[results.size()]);
    }

    public boolean containsImport(String importType) {
        for (int t = 0; t < this.sub.size(); ++t) {
            int idx;
            if (!(this.sub.get(t) instanceof ImportStatement)) continue;
            ImportStatement stm = (ImportStatement)this.sub.get(t);
            if (stm.getImport().equals(importType)) {
                return true;
            }
            if (!stm.isWildcard() || (idx = importType.lastIndexOf(".")) < 0 || !stm.getImport().substring(0, stm.getImport().length() - 2).equals(importType.substring(0, idx))) continue;
            return true;
        }
        return false;
    }

    public String expandImport(String shortName) {
        if (shortName.endsWith("[]")) {
            shortName = shortName.substring(0, shortName.length() - 2);
        }
        for (int t = 0; t < this.sub.size(); ++t) {
            ImportStatement stm;
            int idx;
            if (!(this.sub.get(t) instanceof ImportStatement) || (idx = (stm = (ImportStatement)this.sub.get(t)).getImport().lastIndexOf(".")) < 0 || !stm.getImport().substring(idx + 1).equals(shortName)) continue;
            return stm.getImport();
        }
        if (shortName.indexOf(".") < 0) {
            String tmp = "java.lang." + shortName;
            try {
                return Class.forName(tmp).getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return shortName;
    }

    public void findAccessibleRoots(Statement start, List<DeclarationStatement> roots) {
        do {
            if (start instanceof ClassStatement) {
                roots.add((DeclarationStatement)start);
                continue;
            }
            if (!(start instanceof InterfaceStatement)) continue;
            roots.add((DeclarationStatement)start);
        } while ((start = start.getParent()) != null);
    }

    public void findAccessibleDeclarations(Statement start, List<Declaration> results) {
        CompoundStatement parent;
        int t;
        if (start instanceof MethodStatement) {
            MethodStatement ms = (MethodStatement)start;
            Declaration[] vr = ms.getParams();
            for (t = 0; t < vr.length; ++t) {
                results.add(vr[t]);
            }
        }
        if ((parent = (CompoundStatement)start.getParent()) == null) {
            return;
        }
        Statement[] sub = parent.getSubStatements();
        for (t = 0; t < sub.length; ++t) {
            if (sub[t].getPosition() >= start.getPosition()) continue;
            if (sub[t] instanceof FieldStatement) {
                results.add(((FieldStatement)sub[t]).getDeclaration());
            }
            if (!(sub[t] instanceof VariableDeclarationStatement)) continue;
            results.add(((VariableDeclarationStatement)sub[t]).getDeclaration());
        }
        this.findAccessibleDeclarations(parent, results);
    }

    public ClassStatement[] findClassDeclarations(Statement start) {
        ArrayList<ClassStatement> l = new ArrayList<ClassStatement>();
        while (start.getParent() != null) {
            if (start instanceof ClassStatement) {
                l.add((ClassStatement)start);
            }
            start = start.getParent();
        }
        return l.toArray(new ClassStatement[l.size()]);
    }

    @Override
    public Statement[] getSubStatements() {
        return this.sub.toArray(new Statement[this.sub.size()]);
    }

    @Override
    public Statement getParent() {
        return null;
    }

    @Override
    public DeclarationStatement getOwningDeclaration() {
        return null;
    }

    @Override
    public boolean isClassStatement() {
        return false;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public boolean isConstructorStatement() {
        return false;
    }

    @Override
    public boolean isFieldStatement() {
        return false;
    }

    @Override
    public boolean isImportStatement() {
        return false;
    }

    @Override
    public boolean isInterfaceStatement() {
        return false;
    }

    @Override
    public boolean isMethodStatement() {
        return false;
    }

    @Override
    public boolean isPackageStatement() {
        return false;
    }

    @Override
    public boolean isEnumStatement() {
        return false;
    }

    @Override
    public boolean isIfStatement() {
        return false;
    }

    @Override
    public int getPosition() {
        return 0;
    }
}

