/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import nl.moj.client.codecompletion.statement.Declaration;
import nl.moj.client.codecompletion.statement.DeclarationStatement;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.Statement;

public class FieldStatement
extends DeclarationStatement {
    private String myType;
    private String myName;
    private DeclarationStatement myParent;

    public FieldStatement(DeclarationStatement parent, int pos, String[] words) {
        super(words, pos);
        int cnt;
        for (cnt = 0; cnt < words.length && FieldStatement.isModifier(words[cnt]); ++cnt) {
        }
        this.myType = words[cnt];
        if (words[++cnt].equals("[]")) {
            this.myType = this.myType + "[]";
            ++cnt;
        }
        if (words[cnt].equals("<")) {
            this.myType = this.myType + "<" + words[cnt + 1] + ">";
            cnt += 3;
        }
        this.myName = words[cnt];
        this.myParent = parent;
    }

    public boolean isArray() {
        return this.myType.endsWith("[]");
    }

    public String getType() {
        Statement p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        if (this.isArray()) {
            return ((JavaFile)p).expandImport(this.myType.substring(0, this.myType.length() - 2)) + "[]";
        }
        return ((JavaFile)p).expandImport(this.myType);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public Declaration getDeclaration() {
        return new Declaration(this.getType(), this.getName(), this.isArray());
    }

    public static boolean qualifies(String[] words) {
        int cnt;
        for (cnt = 0; cnt < words.length && FieldStatement.isModifier(words[cnt]); ++cnt) {
        }
        if (cnt > words.length - 2) {
            return false;
        }
        if (!FieldStatement.isPrimitive(words[cnt])) {
            // empty if block
        }
        return words[cnt + 1].indexOf(40) < 0;
    }

    @Override
    public String toString() {
        return "Field(" + this.myName + " of " + this.myType + ")";
    }

    @Override
    public Statement getParent() {
        return this.myParent;
    }
}

