/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import nl.moj.client.codecompletion.statement.AbstractCompoundStatement;
import nl.moj.client.codecompletion.statement.ClassStatement;
import nl.moj.client.codecompletion.statement.ConstructorStatement;
import nl.moj.client.codecompletion.statement.DeclarationStatement;
import nl.moj.client.codecompletion.statement.EnumStatement;
import nl.moj.client.codecompletion.statement.FieldStatement;
import nl.moj.client.codecompletion.statement.IfStatement;
import nl.moj.client.codecompletion.statement.ImportStatement;
import nl.moj.client.codecompletion.statement.InterfaceStatement;
import nl.moj.client.codecompletion.statement.MethodStatement;
import nl.moj.client.codecompletion.statement.PackageStatement;
import nl.moj.client.codecompletion.statement.ReturnStatement;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementVisitor;
import nl.moj.client.codecompletion.statement.VariableDeclarationStatement;

public abstract class AbstractStatement
implements Statement {
    protected String[] myWords;
    protected int myPos;

    public AbstractStatement(String[] words, int pos) {
        this.myWords = words;
        this.myPos = pos;
    }

    @Override
    public int getPosition() {
        return this.myPos;
    }

    public String getStatement() {
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < this.myWords.length; ++t) {
            if (t > 0 && !AbstractStatement.contains(O_OPERATORS, this.myWords[t]) && !AbstractStatement.contains(O_OPERATORS, this.myWords[t - 1])) {
                sb.append(" ");
            }
            sb.append(this.myWords[t]);
        }
        return sb.toString();
    }

    protected boolean contains(String word) {
        return AbstractStatement.contains(this.myWords, word);
    }

    protected boolean containsAny(String[] anyOf) {
        for (int y = 0; y < anyOf.length; ++y) {
            for (int t = 0; t < this.myWords.length; ++t) {
                if (!this.myWords[t].equals(anyOf[y])) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isModifier(String word) {
        for (int t = 0; t < MODIFIERS.length; ++t) {
            if (!MODIFIERS[t].equals(word)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isPrimitive(String word) {
        for (int t = 0; t < PRIMITIVES.length; ++t) {
            if (!PRIMITIVES[t].equals(word)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isCommand(String word) {
        for (int t = 0; t < COMMANDS.length; ++t) {
            if (!COMMANDS[t].equals(word)) continue;
            return true;
        }
        return false;
    }

    protected static boolean contains(String[] words, String word) {
        for (int t = 0; t < words.length; ++t) {
            if (!words[t].equals(word)) continue;
            return true;
        }
        return false;
    }

    public abstract String getName();

    @Override
    public boolean isCompound() {
        return this instanceof AbstractCompoundStatement;
    }

    @Override
    public boolean isClassStatement() {
        return this instanceof ClassStatement;
    }

    @Override
    public boolean isInterfaceStatement() {
        return this instanceof InterfaceStatement;
    }

    @Override
    public boolean isConstructorStatement() {
        return this instanceof ConstructorStatement;
    }

    @Override
    public boolean isMethodStatement() {
        return this instanceof MethodStatement;
    }

    @Override
    public boolean isFieldStatement() {
        return this instanceof FieldStatement;
    }

    @Override
    public boolean isPackageStatement() {
        return this instanceof PackageStatement;
    }

    @Override
    public boolean isImportStatement() {
        return this instanceof ImportStatement;
    }

    public boolean isVariableDeclarationStatement() {
        return this instanceof VariableDeclarationStatement;
    }

    public boolean isReturnStatement() {
        return this instanceof ReturnStatement;
    }

    @Override
    public boolean isIfStatement() {
        return this instanceof IfStatement;
    }

    @Override
    public boolean isEnumStatement() {
        return this instanceof EnumStatement;
    }

    @Override
    public void visit(StatementVisitor v, int indent, boolean isLast) {
        v.onStatement(this, indent, isLast);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Statement(");
        for (int t = 0; t < this.myWords.length; ++t) {
            sb.append(this.myWords[t]);
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public DeclarationStatement getOwningDeclaration() {
        Statement st = this.getParent();
        if (st == null) {
            return null;
        }
        if (st.isMethodStatement()) {
            return (DeclarationStatement)st;
        }
        if (st.isClassStatement()) {
            return (DeclarationStatement)st;
        }
        if (st.isInterfaceStatement()) {
            return (DeclarationStatement)st;
        }
        return st.getOwningDeclaration();
    }
}

