/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import java.util.ArrayList;
import java.util.List;
import nl.moj.client.codecompletion.statement.AbstractStatement;
import nl.moj.client.codecompletion.statement.CompoundStatement;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementVisitor;

public abstract class AbstractCompoundStatement
extends AbstractStatement
implements CompoundStatement {
    protected List<Statement> sub;

    public AbstractCompoundStatement(String[] words, int pos) {
        super(words, pos);
    }

    @Override
    public void visit(StatementVisitor v, int indent, boolean isLast) {
        if (this.sub == null) {
            v.onStatement(this, indent, isLast);
        } else {
            v.beginStatement(this, indent, isLast);
            for (int t = 0; t < this.sub.size(); ++t) {
                ((AbstractStatement)this.sub.get(t)).visit(v, indent + 1, t == this.sub.size() - 1);
            }
            v.endStatement(this, indent, isLast);
        }
    }

    @Override
    public void addStatement(AbstractStatement stm) {
        if (this.sub == null) {
            this.sub = new ArrayList<Statement>();
        }
        this.sub.add(stm);
    }

    @Override
    public Statement[] getSubStatements() {
        if (this.sub == null) {
            return new Statement[0];
        }
        return this.sub.toArray(new Statement[this.sub.size()]);
    }

    protected void scan(List results, Class type) {
        for (int t = 0; t < this.sub.size(); ++t) {
            if (!type.isAssignableFrom(this.sub.get(t).getClass())) continue;
            results.add(this.sub.get(t));
        }
    }
}

