/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nl.moj.client.codecompletion.CodeNode;
import nl.moj.client.codecompletion.CodeNodeFactory;
import nl.moj.client.codecompletion.CompletionSource;

public class TypeCodeCompletion
implements CompletionSource {
    private Class myType;

    public TypeCodeCompletion(String type) {
        try {
            this.myType = Class.forName(type);
        }
        catch (ClassNotFoundException ex) {
            this.myType = null;
        }
    }

    public TypeCodeCompletion(Class type) {
        this.myType = type;
    }

    @Override
    public CodeNode addToCodeTree(CodeNodeFactory cng, CodeNode root) {
        if (this.myType == null) {
            return null;
        }
        root = cng.addDotSeparated(this.myType.getName(), root);
        Field[] f = this.myType.getFields();
        for (int t = 0; t < f.length; ++t) {
            cng.addReferenceIfNotExist(root, f[t].getName(), f[t].getType().getName(), Modifier.isStatic(f[t].getModifiers()), f[t].getType().isArray());
        }
        Method[] m = this.myType.getMethods();
        for (int t = 0; t < m.length; ++t) {
            cng.addReferenceIfNotExist(root, m[t].getName(), m[t].getReturnType().getName(), Modifier.isStatic(m[t].getModifiers()), m[t].getReturnType().isArray());
        }
        if (this.myType.equals(Enum.class)) {
            cng.addReferenceIfNotExist(root, "values", "java.lang.Object", true, false);
        }
        Constructor<?>[] c = this.myType.getConstructors();
        for (int t = 0; t < c.length; ++t) {
            String name = c[t].getName();
            if (name.lastIndexOf(46) >= 0) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            cng.addReferenceIfNotExist(root, name, this.myType.getName(), true, false);
        }
        return root;
    }
}

