/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion;

import java.util.ArrayList;
import nl.moj.client.codecompletion.statement.AbstractCompoundStatement;
import nl.moj.client.codecompletion.statement.AbstractStatement;
import nl.moj.client.codecompletion.statement.CompoundStatement;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementException;
import nl.moj.client.codecompletion.statement.StatementFactory;
import nl.moj.client.codecompletion.statement.StatementVisitor;

public class SourceCodeParser {
    private JavaFile root;

    public SourceCodeParser(String source) throws StatementException {
        this(source, false);
    }

    public SourceCodeParser(String source, boolean faultTolerant) throws StatementException {
        block2: {
            this.root = new JavaFile();
            try {
                this.makeStatements(this.root, source, faultTolerant, 0);
            }
            catch (StatementException ex) {
                if (faultTolerant) break block2;
                throw ex;
            }
        }
    }

    public void visit(StatementVisitor v) {
        this.root.visit(v, 0, false);
    }

    public JavaFile getJavaFile() {
        return this.root;
    }

    public Statement getStatementAt(final int position) {
        final ArrayList bestMatches = new ArrayList();
        this.visit(new StatementVisitor(){

            @Override
            public void begin() {
            }

            @Override
            public void end() {
            }

            @Override
            public void beginStatement(AbstractStatement st, int indent, boolean isLast) {
                if (st.getPosition() < position) {
                    bestMatches.add(st);
                }
            }

            @Override
            public void onStatement(AbstractStatement st, int indent, boolean isLast) {
                if (st.getPosition() < position) {
                    bestMatches.add(st);
                }
            }

            @Override
            public void endStatement(AbstractStatement st, int indent, boolean isLast) {
            }
        });
        if (bestMatches.size() == 0) {
            return null;
        }
        return (Statement)bestMatches.get(bestMatches.size() - 1);
    }

    protected int makeStatements(CompoundStatement parent, String s, boolean tolerant, int offset) {
        try {
            int startPos = 0;
            int roundBr = 0;
            char inString = '\u0000';
            StringBuffer sb = new StringBuffer();
            for (int t = 0; t < s.length(); ++t) {
                char c = s.charAt(t);
                if (c < ' ') {
                    c = ' ';
                }
                if (c == '/') {
                    if (s.substring(t, t + 2).equals("//")) {
                        int end = s.substring(t).indexOf("\n");
                        if (end < 0) {
                            throw new StatementException("Missing end of line.");
                        }
                        t += end;
                        continue;
                    }
                    if (s.substring(t, t + 2).equals("/*")) {
                        int end = s.substring(t).indexOf("*/") + 1;
                        if (end < 0) {
                            throw new StatementException("Missing end of comment.");
                        }
                        t += end;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == '\"' || c == '\'') {
                    if (inString == '\u0000') {
                        inString = c;
                    } else if (c == inString) {
                        inString = '\u0000';
                    }
                    sb.append(c);
                    continue;
                }
                if (c == '(' && inString == '\u0000') {
                    ++roundBr;
                    sb.append(c);
                    continue;
                }
                if (c == ')' && inString == '\u0000') {
                    --roundBr;
                    sb.append(c);
                    continue;
                }
                if (c == ';' && roundBr == 0 && inString == '\u0000') {
                    if (sb.length() == 0) continue;
                    AbstractStatement st = StatementFactory.createStatement(parent, offset + startPos, sb.toString().trim());
                    if (st != null) {
                        parent.addStatement(st);
                    }
                    sb.delete(0, sb.length());
                    startPos = t + 1;
                    continue;
                }
                if (c == '{' && inString == '\u0000') {
                    String tmp = sb.toString().trim();
                    if (tmp.length() > 0) {
                        AbstractCompoundStatement sub = (AbstractCompoundStatement)StatementFactory.createStatement(parent, offset + startPos, tmp);
                        parent.addStatement(sub);
                        t += this.makeStatements(sub, s.substring(t + 1), tolerant, offset + t + 1);
                    } else {
                        throw new StatementException("Cannot start a statement with a {");
                    }
                    startPos = t + 1;
                    sb.delete(0, sb.length());
                    continue;
                }
                if (c == '}' && inString == '\u0000') {
                    String tmp = sb.toString().trim();
                    if (tmp.length() > 0) {
                        parent.addStatement(StatementFactory.createStatement(parent, offset + startPos, tmp));
                    }
                    sb.delete(0, sb.length());
                    return t + 1;
                }
                sb.append(c);
            }
            if (sb.toString().trim().length() > 0) {
                parent.addStatement(StatementFactory.createStatement(parent, startPos, sb.toString().trim()));
            }
            return s.length();
        }
        catch (StatementException ex) {
            if (!tolerant) {
                throw ex;
            }
            int idx = s.indexOf("}");
            return idx > -1 ? idx : 1;
        }
    }
}

