/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion;

import java.util.TreeSet;
import nl.ctrlaltdev.util.Tool;
import nl.moj.client.codecompletion.CodeNode;
import nl.moj.client.codecompletion.statement.Declaration;
import nl.moj.client.codecompletion.statement.MethodStatement;
import nl.moj.client.codecompletion.statement.Statement;

public class PartialCode {
    private boolean newInstance;
    private boolean hasArrayBrackets;
    private boolean variable;
    private boolean inStaticMethod;
    private String codeToComplete;
    private String[] dotSeparated;
    private Declaration[] knownDeclarations;
    private CodeNode[] myRoots;
    private CodeNode foundRoot;

    public PartialCode(String codeToComplete, boolean newInstance, boolean hasArrayBrackets) {
        this.codeToComplete = codeToComplete;
        this.newInstance = newInstance;
        this.dotSeparated = Tool.cutForEach(codeToComplete, ".");
        this.hasArrayBrackets = hasArrayBrackets;
    }

    public void setContext(CodeNode[] roots, Declaration[] decl) {
        this.myRoots = roots;
        this.knownDeclarations = decl;
    }

    public int length() {
        return this.codeToComplete.length();
    }

    public String toString() {
        return this.codeToComplete;
    }

    public void checkStatic(Statement stm) {
        boolean st = true;
        while (stm != null) {
            if (stm.isMethodStatement()) {
                st = ((MethodStatement)stm).isStatic();
            }
            stm = stm.getParent();
        }
        this.inStaticMethod = st;
    }

    public void resolve() {
        if (this.dotSeparated.length <= 1) {
            return;
        }
        boolean sni = this.newInstance;
        boolean st = this.inStaticMethod;
        boolean sv = this.variable;
        for (int ridx = 0; ridx < this.myRoots.length; ++ridx) {
            this.newInstance = sni;
            this.inStaticMethod = st;
            this.variable = sv;
            CodeNode root = this.myRoots[ridx];
            for (int t = 0; t < this.dotSeparated.length - 1; ++t) {
                CodeNode newRoot = root.contains(this.dotSeparated[t]);
                if (newRoot == null) {
                    for (int y = 0; y < this.knownDeclarations.length; ++y) {
                        if (!this.dotSeparated[t].equals(this.knownDeclarations[y].getName())) continue;
                        this.variable = true;
                        String[] type = Tool.cutForEach(this.knownDeclarations[y].getType(), ".");
                        CodeNode troot = this.myRoots[ridx];
                        for (int z = 0; z < type.length && (troot = troot.contains(type[z])) != null; ++z) {
                        }
                        newRoot = troot;
                        if (!this.knownDeclarations[y].isArray()) continue;
                        if (newRoot instanceof CodeNode.ReferenceNode) {
                            newRoot = ((CodeNode.ReferenceNode)newRoot).asArrayNode();
                            continue;
                        }
                        if (!(newRoot instanceof CodeNode.BranchNode)) continue;
                        newRoot = ((CodeNode.BranchNode)newRoot).asArrayNode();
                    }
                } else {
                    this.inStaticMethod = newRoot.isStatic();
                    if (this.isStatic()) {
                        boolean mayBeClass = Character.isUpperCase(newRoot.getName().charAt(0));
                        boolean constant = newRoot.getName().toUpperCase().equals(newRoot.getName());
                        boolean bl = this.variable = !mayBeClass || constant;
                    }
                }
                if ((root = newRoot) == null) break;
                this.foundRoot = root;
            }
            if (this.foundRoot == null) continue;
            return;
        }
    }

    public String[] findCompletions() {
        TreeSet<String> result = new TreeSet<String>();
        TreeSet<CodeNode> tmp = new TreeSet<CodeNode>();
        if (this.getRoot().isArray()) {
            if (this.hasArrayBrackets) {
                this.getRoot().findChildren(this.getRemainderToComplete(), true, this.isStatic(), tmp);
            } else {
                tmp.add(new CodeNode.LeafNode(null, "length", false));
            }
        } else {
            this.getRoot().findChildren(this.getRemainderToComplete(), true, this.isStatic(), tmp);
        }
        CodeNode[] cna = tmp.toArray(new CodeNode[tmp.size()]);
        for (int t = 0; t < cna.length; ++t) {
            if (cna[t].getName().length() <= 0) continue;
            result.add(this.getPrefix() + cna[t].getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean isStatic() {
        return (this.newInstance || this.inStaticMethod) && !this.variable;
    }

    public CodeNode getRoot() {
        if (this.foundRoot == null) {
            return this.myRoots[0];
        }
        return this.foundRoot;
    }

    public String getRemainderToComplete() {
        return this.dotSeparated[this.dotSeparated.length - 1];
    }

    public String getPrefix() {
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < this.dotSeparated.length - 1; ++t) {
            sb.append(this.dotSeparated[t]);
            sb.append(".");
        }
        return sb.toString();
    }
}

