/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion;

import java.util.ArrayList;
import java.util.List;
import nl.ctrlaltdev.util.Tool;
import nl.moj.client.codecompletion.CodeNode;
import nl.moj.client.codecompletion.CodeNodeFactory;
import nl.moj.client.codecompletion.PartialCode;
import nl.moj.client.codecompletion.SourceCodeCompletion;
import nl.moj.client.codecompletion.SourceCodeParser;
import nl.moj.client.codecompletion.statement.Declaration;
import nl.moj.client.codecompletion.statement.DeclarationStatement;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementException;

public class CodeCompletion {
    private List<SourceCodeCompletion> mySources = new ArrayList<SourceCodeCompletion>();
    private CodeNodeFactory myCNF = new CodeNodeFactory();

    public void addStaticSource(String source) throws StatementException {
        this.mySources.add(new SourceCodeCompletion(source));
    }

    public String removeCorresponding(String l, String start, String end) {
        int sx = l.indexOf(start);
        int ex = l.indexOf(end);
        if (sx >= 0 && ex == -1 || sx >= 0 && ex >= 0 && sx < ex) {
            String first = l.substring(0, sx);
            String tmp = l.substring(sx + 1);
            int se = (tmp = this.removeCorresponding(tmp, start, end)).indexOf(end);
            if (se >= 0) {
                String tmp2 = tmp.substring(se + 1);
                l = first + this.removeCorresponding(tmp2, start, end);
            }
        }
        return l;
    }

    public PartialCode getPartToComplete(String line) {
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        if (line.length() == 0) {
            return new PartialCode("", false, false);
        }
        int idx2 = line.lastIndexOf(",");
        if (idx2 >= 0) {
            line = line.substring(idx2 + 1);
        }
        if ((idx3 = line.lastIndexOf("=")) >= 0) {
            line = line.substring(idx3 + 1);
        }
        if ((idx4 = line.lastIndexOf("<")) >= 0) {
            line = line.substring(idx4 + 1);
        }
        if ((idx5 = line.lastIndexOf(">")) >= 0) {
            line = line.substring(idx5 + 1);
        }
        if ((idx6 = line.lastIndexOf(";")) >= 0) {
            line = line.substring(idx6 + 1);
        }
        line = this.removePadding(line.trim(), " ");
        boolean hasArrayBrackets = (line = this.removeCorresponding(line, "(", ")")).indexOf(91) >= 0 && line.indexOf(93) >= 0;
        String[] words = Tool.cut(line = this.removeCorresponding(line, "[", "]"), " ");
        if (words.length == 0) {
            return new PartialCode("", false, false);
        }
        boolean isNewInstance = words.length > 1 && words[words.length - 2].equals("new");
        return new PartialCode(words[words.length - 1], isNewInstance, hasArrayBrackets);
    }

    public String removePadding(String l, String p) {
        while (l.indexOf(p) >= 0) {
            l = l.substring(0, l.indexOf(p)) + l.substring(l.indexOf(p) + p.length());
        }
        return l;
    }

    public String[] getCompletions(String contextSource, int contextPosition, PartialCode wordToComplete) {
        CodeNode root = this.myCNF.createRoot();
        SourceCodeParser parse = null;
        CodeNode sourceRoot = null;
        try {
            parse = new SourceCodeParser(contextSource);
            sourceRoot = new SourceCodeCompletion(parse).addToCodeTree(this.myCNF, root);
        }
        catch (StatementException ex) {
            // empty catch block
        }
        for (int t = 0; t < this.mySources.size(); ++t) {
            SourceCodeCompletion scc = this.mySources.get(t);
            scc.addToCodeTree(this.myCNF, root);
        }
        if (parse != null) {
            Statement stm = parse.getStatementAt(contextPosition);
            wordToComplete.checkStatic(stm);
            ArrayList<Declaration> varList = new ArrayList<Declaration>();
            ArrayList<DeclarationStatement> rootList = new ArrayList<DeclarationStatement>();
            parse.getJavaFile().findAccessibleDeclarations(stm, varList);
            parse.getJavaFile().findAccessibleRoots(stm, rootList);
            Declaration[] vars = varList.toArray(new Declaration[varList.size()]);
            CodeNode[] roots = new CodeNode[rootList.size() + 1];
            for (int t = 0; t < rootList.size(); ++t) {
                roots[t] = this.toCodeNode(root, (DeclarationStatement)rootList.get(t));
            }
            roots[rootList.size()] = root;
            wordToComplete.setContext(roots, vars);
            wordToComplete.resolve();
        } else {
            wordToComplete.setContext(new CodeNode[]{root}, new Declaration[0]);
        }
        return wordToComplete.findCompletions();
    }

    public CodeNode toCodeNode(CodeNode root, DeclarationStatement st) {
        String[] parts = Tool.cut(st.getFullyQualifiedName(), ".");
        for (int t = 0; t < parts.length; ++t) {
            if ((root = root.contains(parts[t])) != null) continue;
            return null;
        }
        return root;
    }
}

