/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.anim;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.moj.client.anim.Anim;
import nl.moj.client.anim.Persistable;

public class LayeredAnim
implements Anim {
    public static final double ROTATIONSCALE = 57.29578;
    public static final short RES_BMP = 0;
    public static final short RES_SPRITE = 1;
    public static final short RES_SHAPE = 2;
    public static final short RES_MAP = 3;
    public static final short LAYER = 10;
    public static final short FRAME = 20;
    public static final double AREA_WIDTH = 100.0;
    public static final double AREA_HEIGHT = 100.0;
    private List frames = new ArrayList();
    private List resources = new ArrayList();
    private List layers = new ArrayList();
    private int current;
    private short idCnt;

    public Persistable instantiate(DataInput in) throws IOException {
        short type = in.readShort();
        short id = in.readShort();
        switch (type) {
            case 0: {
                return new BitMapResource(id);
            }
            case 1: {
                return new SpriteResource(id, this);
            }
            case 2: {
                return new ShapeResource(id);
            }
            case 3: {
                return new MapResource(id, this);
            }
            case 20: {
                return new AnimFrame(id, this);
            }
        }
        throw new IOException("Unknown type " + type + " in Animation.");
    }

    @Override
    public void read(DataInput in) throws IOException {
        int rsize = in.readInt();
        for (int t = 0; t < rsize; ++t) {
            Persistable p = this.instantiate(in);
            p.read(in);
            this.resources.add(p);
        }
        int lsize = in.readInt();
        for (int t = 0; t < lsize; ++t) {
            Persistable p = this.instantiate(in);
            p.read(in);
            this.layers.add(p);
        }
        int fsize = in.readInt();
        for (int t = 0; t < fsize; ++t) {
            Persistable p = this.instantiate(in);
            p.read(in);
            this.frames.add(p);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int t;
        out.writeInt(this.resources.size());
        for (t = 0; t < this.resources.size(); ++t) {
            ((Persistable)this.resources.get(t)).write(out);
        }
        out.writeInt(this.layers.size());
        for (t = 0; t < this.layers.size(); ++t) {
            ((Persistable)this.layers.get(t)).write(out);
        }
        out.writeInt(this.frames.size());
        for (t = 0; t < this.frames.size(); ++t) {
            ((Persistable)this.frames.get(t)).write(out);
        }
    }

    protected Resource getResource(short id) {
        for (int t = 0; t < this.resources.size(); ++t) {
            if (((Resource)this.resources.get(t)).getId() != id) continue;
            return (Resource)this.resources.get(t);
        }
        throw new NullPointerException("Missing resource with id '" + id + "'");
    }

    public synchronized BitMapResource createBitmapResource() {
        short s = this.idCnt;
        this.idCnt = (short)(s + 1);
        BitMapResource res = new BitMapResource(s);
        this.resources.add(res);
        return res;
    }

    public synchronized ShapeResource createShapeResource() {
        short s = this.idCnt;
        this.idCnt = (short)(s + 1);
        ShapeResource res = new ShapeResource(s);
        this.resources.add(res);
        return res;
    }

    public synchronized SpriteResource createSpriteResource(Resource target) {
        short s = this.idCnt;
        this.idCnt = (short)(s + 1);
        SpriteResource res = new SpriteResource(s, this);
        this.resources.add(res);
        res.setResource(target.getId());
        return res;
    }

    public synchronized MapResource createMapResource() {
        short s = this.idCnt;
        this.idCnt = (short)(s + 1);
        MapResource res = new MapResource(s, this);
        this.resources.add(res);
        return res;
    }

    public synchronized AnimFrame createNewFrame() {
        short s = this.idCnt;
        this.idCnt = (short)(s + 1);
        AnimFrame f = new AnimFrame(s, this);
        this.frames.add(f);
        return f;
    }

    @Override
    public Anim.Frame current() {
        return (Anim.Frame)this.frames.get(this.current);
    }

    @Override
    public boolean next() {
        if (this.current + 1 < this.getFrameCount()) {
            ++this.current;
        }
        return this.current < this.getFrameCount() - 1;
    }

    @Override
    public void prev() {
        if (this.current - 1 >= 0) {
            --this.current;
        }
    }

    @Override
    public void first() {
        this.current = 0;
    }

    @Override
    public void last() {
        this.current = this.getFrameCount() - 1;
    }

    @Override
    public int currentFrame() {
        return this.current;
    }

    @Override
    public int getFrameCount() {
        return this.frames.size();
    }

    @Override
    public void setCurrentFrame(int f) {
        if (f < 0) {
            return;
        }
        if (f >= this.getFrameCount()) {
            return;
        }
        this.current = f;
    }

    public static final class MapResource
    implements Persistable,
    Resource {
        private short id;
        private short tileSize;
        private String[] map;
        private Map charToTiles = new HashMap();
        private LayeredAnim owner;

        public MapResource(short id, LayeredAnim owner) {
            this.owner = owner;
            this.id = id;
        }

        @Override
        public short getId() {
            return this.id;
        }

        public void setMap(int tileSize, String[] map, Map charToTiles) {
            this.tileSize = (short)tileSize;
            this.map = map;
            this.charToTiles = charToTiles;
        }

        @Override
        public void draw(Graphics2D g, int x, int y, int rot) {
            for (int yy = 0; yy < this.map.length; ++yy) {
                for (int xx = 0; xx < this.map[yy].length(); ++xx) {
                    int tx = x + xx * this.tileSize;
                    int ty = y + yy * this.tileSize;
                    Character c = new Character(this.map[yy].charAt(xx));
                    if (!this.charToTiles.containsKey(c)) continue;
                    short id = (Short)this.charToTiles.get(c);
                    Resource r = this.owner.getResource(id);
                    r.draw(g, tx, ty, rot);
                }
            }
        }

        @Override
        public void read(DataInput in) throws IOException {
            this.tileSize = in.readShort();
            int mapHeight = in.readShort();
            int mapWidth = in.readShort();
            this.map = new String[mapHeight];
            for (int y = 0; y < mapHeight; ++y) {
                StringBuffer sb = new StringBuffer();
                for (int x = 0; x < mapWidth; ++x) {
                    char c = (char)in.readByte();
                    sb.append(c);
                }
                this.map[y] = sb.toString();
            }
            this.charToTiles = new HashMap();
            int tiles = in.readShort();
            for (int t = 0; t < tiles; ++t) {
                char c = (char)in.readByte();
                short id = in.readShort();
                this.charToTiles.put(new Character(c), new Short(id));
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeShort(3);
            out.writeShort(this.id);
            out.writeShort(this.tileSize);
            out.writeShort(this.map.length);
            out.writeShort(this.map[0].length());
            for (int y = 0; y < this.map.length; ++y) {
                for (int x = 0; x < this.map[0].length(); ++x) {
                    out.writeByte((byte)this.map[y].charAt(x));
                }
            }
            out.writeShort(this.charToTiles.size());
            for (Character c : this.charToTiles.keySet()) {
                Short id = (Short)this.charToTiles.get(c);
                out.writeByte((byte)c.charValue());
                out.writeShort(id.shortValue());
            }
        }
    }

    public static final class AnimFrame
    implements Anim.Frame,
    Persistable {
        private static final int STATE_ID = 0;
        private static final int STATE_X = 1;
        private static final int STATE_Y = 2;
        private static final int STATE_ROT = 3;
        private LayeredAnim owner;
        private List states;

        public AnimFrame(short id, LayeredAnim owner) {
            this.owner = owner;
            this.states = new ArrayList();
        }

        public void add(Resource r, int x, int y, int rot) {
            this.states.add(new short[]{r.getId(), (short)x, (short)y, (short)rot});
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeShort(20);
            out.writeShort(0);
            out.writeInt(this.states.size());
            for (int t = 0; t < this.states.size(); ++t) {
                short[] state = (short[])this.states.get(t);
                out.writeShort(state[0]);
                out.writeShort(state[1]);
                out.writeShort(state[2]);
                out.writeShort(state[3]);
            }
        }

        @Override
        public void read(DataInput in) throws IOException {
            int cnt = in.readInt();
            for (int t = 0; t < cnt; ++t) {
                short[] state = new short[]{in.readShort(), in.readShort(), in.readShort(), in.readShort()};
                this.states.add(state);
            }
        }

        @Override
        public void draw(Graphics g, int w, int h) {
            AffineTransform tf = ((Graphics2D)g).getTransform();
            tf.scale((double)w / 100.0, (double)h / 100.0);
            ((Graphics2D)g).setTransform(tf);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, 100, 100);
            for (int t = 0; t < this.states.size(); ++t) {
                short[] state = (short[])this.states.get(t);
                Resource res = this.owner.getResource(state[0]);
                res.draw((Graphics2D)g, state[1], state[2], state[3]);
            }
        }
    }

    public static final class SpriteResource
    implements Persistable,
    Resource {
        private short id;
        private short sid;
        private LayeredAnim owner;

        public SpriteResource(short id, LayeredAnim owner) {
            this.owner = owner;
            this.id = id;
        }

        @Override
        public short getId() {
            return this.id;
        }

        public void setResource(short rid) {
            this.sid = rid;
        }

        public short getResource() {
            return this.sid;
        }

        @Override
        public void draw(Graphics2D g, int x, int y, int rot) {
            Resource r = this.owner.getResource(this.sid);
            r.draw(g, x, y, rot);
        }

        @Override
        public void read(DataInput in) throws IOException {
            this.sid = in.readShort();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeShort(1);
            out.writeShort(this.id);
            out.writeShort(this.sid);
        }
    }

    public static final class ShapeResource
    implements Persistable,
    Resource {
        public static final short SHAPE_RECT = 0;
        public static final short SHAPE_CIRCLE = 1;
        public static final short SHAPE_LINE = 2;
        public static final short SHAPE_TRIANGLE = 3;
        private short shape;
        private short w;
        private short h;
        private short id;
        private Color col;

        public ShapeResource(short id) {
            this.id = id;
        }

        public ShapeResource set(short shape, Color color, short w, short h) {
            this.shape = shape;
            this.col = color;
            this.w = w;
            this.h = h;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void draw(Graphics2D g, int x, int y, int rot) {
            Graphics2D local = (Graphics2D)g.create();
            try {
                local.translate(x, y);
                if (rot != 0) {
                    AffineTransform at = local.getTransform();
                    at.rotate((double)rot / 57.29578);
                    local.setTransform(at);
                }
                local.setColor(this.col);
                switch (this.shape) {
                    case 0: {
                        local.fillRect(-this.w / 2, -this.h / 2, this.w, this.h);
                        return;
                    }
                    case 1: {
                        local.fillOval(-this.w / 2, -this.h / 2, this.w, this.h);
                        return;
                    }
                    case 2: {
                        local.drawLine(0, 0, this.w, this.h);
                        return;
                    }
                    case 3: {
                        local.drawPolygon(new int[]{0, this.w / 2, -this.w / 2}, new int[]{-this.h / 2, this.h / 2, this.h / 2}, 3);
                        return;
                    }
                    default: {
                        throw new RuntimeException("Unknown shape.");
                    }
                }
            }
            finally {
                local.dispose();
            }
        }

        @Override
        public short getId() {
            return this.id;
        }

        @Override
        public void read(DataInput in) throws IOException {
            this.shape = in.readShort();
            this.col = new Color(in.readInt());
            this.w = in.readShort();
            this.h = in.readShort();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeShort(2);
            out.writeShort(this.id);
            out.writeShort(this.shape);
            out.writeInt(this.col.getRGB());
            out.writeShort(this.w);
            out.writeShort(this.h);
        }
    }

    public static final class BitMapResource
    implements Persistable,
    Resource {
        private short id;
        private Color[] colors;
        private byte[][] pixels;

        public BitMapResource(short id) {
            this.id = id;
        }

        @Override
        public short getId() {
            return this.id;
        }

        public BitMapResource setImageData(Color[] c, byte[][] pixels) {
            this.colors = c;
            this.pixels = pixels;
            return this;
        }

        @Override
        public void read(DataInput in) throws IOException {
            int csize = in.readInt();
            this.colors = new Color[csize];
            for (int t = 0; t < csize; ++t) {
                int c = in.readInt();
                this.colors[t] = c >= 0 ? new Color(c) : null;
            }
            int width = in.readInt();
            int height = in.readInt();
            this.pixels = new byte[height][width];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.pixels[y][x] = in.readByte();
                }
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeShort(0);
            out.writeShort(this.id);
            out.writeInt(this.colors.length);
            for (int t = 0; t < this.colors.length; ++t) {
                out.writeInt(this.colors[t] == null ? -1 : this.colors[t].getRGB() & 0xFFFFFF);
            }
            out.writeInt(this.pixels[0].length);
            out.writeInt(this.pixels.length);
            for (int y = 0; y < this.pixels.length; ++y) {
                for (int x = 0; x < this.pixels[0].length; ++x) {
                    out.writeByte(this.pixels[y][x]);
                }
            }
        }

        public int getHeight() {
            return this.pixels.length;
        }

        public int getWidth() {
            if (this.pixels.length == 0) {
                return 0;
            }
            return this.pixels[0].length;
        }

        public Color getPixelAt(int x, int y) {
            return this.colors[this.pixels[y][x]];
        }

        @Override
        public void draw(Graphics2D g, int x, int y, int rot) {
            int h = this.getHeight();
            int h2 = h / 2;
            int w = this.getWidth();
            int w2 = w / 2;
            Graphics2D local = (Graphics2D)g.create();
            local.translate(x + w / 2, y + h / 2);
            if (rot != 0) {
                AffineTransform at = local.getTransform();
                at.rotate((double)rot / 57.29578);
                local.setTransform(at);
            }
            for (int cy = 0; cy < h; ++cy) {
                for (int cx = 0; cx < w; ++cx) {
                    Color c = this.getPixelAt(cx, cy);
                    if (c == null) continue;
                    local.setColor(c);
                    local.fillRect(cx - w2, cy - h2, 1, 1);
                }
            }
            local.dispose();
        }
    }

    public static interface Resource {
        public short getId();

        public void draw(Graphics2D var1, int var2, int var3, int var4);
    }
}

