/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.anim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.ctrlaltdev.ui.Build;
import nl.moj.client.anim.Anim;

public class AnimPlayer
extends JPanel {
    private JSlider frameSelector = new JSlider(0);
    private JButton playButton = new JButton(">");
    private JButton stopButton = new JButton("[]");
    private JPanel display = new DisplayPanel();
    private static Timer timer = new Timer();
    private Anim currentAnimation;

    public AnimPlayer() {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(128, 160));
        this.display.setPreferredSize(new Dimension(128, 128));
        this.display.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.display, "Center");
        this.add((Component)new Build.BOXX(new JComponent[]{this.playButton, this.stopButton, this.frameSelector}), "South");
        this.frameSelector.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AnimPlayer.this.currentAnimation != null) {
                    AnimPlayer.this.currentAnimation.setCurrentFrame(((JSlider)e.getSource()).getValue());
                }
                AnimPlayer.this.display.repaint();
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimPlayer.this.playButton.setEnabled(true);
                AnimPlayer.this.stopButton.setEnabled(false);
            }
        });
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimPlayer.this.currentAnimation.first();
                AnimPlayer.this.display.repaint();
                AnimPlayer.this.playButton.setEnabled(false);
                AnimPlayer.this.stopButton.setEnabled(true);
                timer.schedule((TimerTask)new Updater(), 100L);
            }
        });
        this.setAnimation(null);
    }

    public void setAnimation(Anim a) {
        this.currentAnimation = a;
        if (this.currentAnimation != null) {
            this.currentAnimation.first();
            this.frameSelector.getModel().setMinimum(0);
            this.frameSelector.getModel().setMaximum(a.getFrameCount() - 1);
            this.frameSelector.getModel().setValue(0);
            this.frameSelector.setEnabled(true);
            this.playButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        } else {
            this.frameSelector.getModel().setMinimum(0);
            this.frameSelector.getModel().setMaximum(0);
            this.frameSelector.getModel().setValue(0);
            this.frameSelector.setEnabled(false);
            this.playButton.setEnabled(false);
            this.stopButton.setEnabled(false);
        }
    }

    private Anim.Frame getCurrentFrame() {
        if (this.currentAnimation == null) {
            return null;
        }
        if (this.currentAnimation.getFrameCount() == 0) {
            return null;
        }
        return this.currentAnimation.current();
    }

    private class DisplayPanel
    extends JPanel {
        private DisplayPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Anim.Frame af = AnimPlayer.this.getCurrentFrame();
            if (af != null) {
                Graphics2D tmp = (Graphics2D)g.create();
                try {
                    tmp.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    af.draw(tmp, this.getWidth(), this.getHeight());
                }
                finally {
                    tmp.dispose();
                }
            } else {
                g.setColor(Color.LIGHT_GRAY);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintBorder(g);
        }
    }

    private class Updater
    extends TimerTask {
        private Updater() {
        }

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                if (AnimPlayer.this.currentAnimation == null) {
                    return;
                }
                if (AnimPlayer.this.currentAnimation.next() && !AnimPlayer.this.playButton.isEnabled()) {
                    timer.schedule((TimerTask)new Updater(), 100L);
                } else {
                    AnimPlayer.this.playButton.setEnabled(true);
                    AnimPlayer.this.stopButton.setEnabled(false);
                }
                AnimPlayer.this.display.repaint();
                AnimPlayer.this.frameSelector.setValue(AnimPlayer.this.currentAnimation.currentFrame());
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

