/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.security.Permission;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotUndoException;
import nl.ctrlaltdev.ui.Build;
import nl.ctrlaltdev.ui.FocusablePopup;
import nl.ctrlaltdev.ui.ImagePanel;
import nl.ctrlaltdev.util.Encoder;
import nl.moj.client.AssignmentSponsorPanel;
import nl.moj.client.ConfirmingActionListener;
import nl.moj.client.DoubleClickListener;
import nl.moj.client.ErrorHighlightingCellRenderer;
import nl.moj.client.InsertTabAction;
import nl.moj.client.JavaDocument;
import nl.moj.client.JavaUndoManager;
import nl.moj.client.JavaWordAction;
import nl.moj.client.StacktraceHighlightingCellRenderer;
import nl.moj.client.anim.Anim;
import nl.moj.client.anim.AnimPlayer;
import nl.moj.client.codecompletion.CodeCompletion;
import nl.moj.client.codecompletion.PartialCode;
import nl.moj.client.io.ActionMessageImpl;
import nl.moj.client.io.GoodbyeMessageImpl;
import nl.moj.client.io.HelloMessageImpl;
import nl.moj.client.io.Message;
import nl.moj.client.io.MessageFactory;
import nl.moj.util.InetAddressUtil;

public class ClientApplet
extends JPanel
implements ActionListener,
Runnable,
StacktraceHighlightingCellRenderer.FileNameSource {
    public static final long MAX_CHARS = 600000L;
    public static final long MAX_LINES = 3000L;
    private static final String COMPILE = "Compile";
    private static final String TEST = "Test";
    private static final Font BIG = new Font("Verdana", 0, 64);
    private static final Font MEDIUM = new Font("Verdana", 0, 32);
    private static final Font SMALL = new Font("Verdana", 0, 16);
    private static final Font MONOSPACEFONT = new Font("Monospaced", 0, 11);
    private static final Font CODECOMPLETIONFONT = new Font("Monospaced", 0, 10);
    private static final Color HI = new Color(220, 220, 220);
    private static final Color LO = new Color(192, 192, 192);
    private static final Color READONLYEDITOR = new Color(240, 240, 240);
    private static final Color COLORKEYBOARD = new Color(4873068);
    private static final Color DARKGREEN = new Color(0, 32, 0);
    private static final Color NLJUGORANGE = new Color(15839361);
    private static EditorKit javaEditorKit = new StyledEditorKit(){

        @Override
        public Document createDefaultDocument() {
            return new JavaDocument();
        }
    };
    private DividerSyncer theDividerSyncer = new DividerSyncer();
    private static final String TABCHARS = "    ";
    private static final int TAB_LOGON = 0;
    private static final int TAB_WAIT = 1;
    private static final int TAB_EDIT = 2;
    private static final int TAB_FINISHED = 3;
    private String teamName;
    private String password;
    private boolean loggedIn;
    private String server;
    private int serverPort;
    private String selectedServer;
    private boolean shouldRun;
    private Socket mySocket;
    private DataInput myDataInput;
    private DataOutput myDataOutput;
    private MessageFactory myFactory = new MessageFactory();
    private JTabbedPane editorTab;
    private JTabbedPane consoleTab;
    private JComponent[] myStatsPanel = new JComponent[4];
    private JLabel[] myMessagePanel = new JLabel[4];
    private AssignmentSponsorPanel waitSponsorPanel;
    private AssignmentSponsorPanel finishedSponsorPanel;
    private TestPanel[] myTestPanels;
    private JButton loginButton;
    private Box buttonBar;
    private JTextField userNameField;
    private JTextField passwordField;
    private JComboBox serverCB;
    private JLabel myLineLabel;
    private JLabel myClockLabel;
    private JCheckBox myClearDisplaysBeforeTest = new JCheckBox("Clear Displays");
    private int myActiveTab;
    private Message.UpdateClientStatistics remoteStats;
    private Set<String> knownFileNames = new HashSet<String>();
    private int myKeyStrokes;
    private CodeCompletion myCC;
    private String[] names = new String[]{"/client/duke_hi.jpg", "/client/duke_winner2.jpg", "/client/duke_loser.jpg", "/client/duke_winner1.jpg", "/client/mojLogo.gif", "/client/icons/compile_icon.gif", "/client/icons/test_icon.gif", "/client/icons/submit_icon.gif", "/client/copyright.gif", "/client/keyboard.jpg", "/client/trix-top.jpg", "/client/trix-bottom.jpg", "/client/icons/save_icon.gif", "/client/icons/test-success.png", "/client/icons/test-failed.png", "/client/icons/test-unknown.png"};
    private Image[] images;
    private Icon testSuccess;
    private Icon testFailed;
    private Icon testUnknown;
    private JFrame parentFrame;

    static Image loadImage(String fileName) throws IOException {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL myURL = ClientApplet.class.getResource(fileName);
        if (myURL == null) {
            throw new IOException("Resource " + fileName + " not found. Does it start with / ?");
        }
        return tk.createImage(myURL);
    }

    public ClientApplet(JFrame parent, String server) {
        this(parent, server, "8080");
    }

    public ClientApplet(JFrame parent, String server, String serverPort) {
        if (server == null || serverPort == null) {
            throw new NullPointerException("server parameter(s) missing.");
        }
        this.server = server;
        this.serverPort = Integer.parseInt(serverPort);
        this.parentFrame = parent;
        this.makeTitle();
    }

    protected void makeTitle() {
        if (this.teamName == null) {
            this.parentFrame.setTitle("Masters of Java - Client - (2007111001)");
        } else {
            this.parentFrame.setTitle("Masters of Java - Team '" + this.teamName + "'");
        }
    }

    public void init() {
        this.loadImages();
        this.setLayout(new CardLayout());
        this.add((Component)this.createLoginPanel(), "-");
        this.add((Component)this.createWaitPanel(), "0");
        this.add((Component)this.createEditorPanel(), "1");
        this.add((Component)this.createFinishedPanel(), "2");
        this.myCC = new CodeCompletion();
    }

    protected void loadImages() {
        this.images = new Image[this.names.length];
        for (int t = 0; t < this.images.length; ++t) {
            try {
                InputStream in = this.getClass().getResourceAsStream(this.names[t]);
                if (in == null) {
                    throw new IOException("Image not found " + this.names[t]);
                }
                this.images[t] = ImageIO.read(in);
                continue;
            }
            catch (IOException ex) {
                System.out.println("Failed loading image : " + this.names[t]);
                this.images[t] = this.createImage(1, 1);
            }
        }
        this.testSuccess = new ImageIcon(this.images[13]);
        this.testFailed = new ImageIcon(this.images[14]);
        this.testUnknown = new ImageIcon(this.images[15]);
    }

    protected JPanel createWaitPanel() {
        JLabel waitText = new JLabel("Please Wait...");
        waitText.setFont(MEDIUM);
        this.myStatsPanel[1] = new PlayerCountPanel(this.images[1], this.images[2]);
        this.myMessagePanel[1] = new JLabel("", 0);
        this.myMessagePanel[1].setPreferredSize(new Dimension(512, 24));
        this.waitSponsorPanel = new AssignmentSponsorPanel();
        this.waitSponsorPanel.setPreferredSize(new Dimension(321, 128));
        Build.BOXY tmp = new Build.BOXY(new JComponent[]{new Build.Spacer(320, 32), new Build.CFP((JComponent)waitText, new ImagePanel(this.images[0], 32, 32, Color.GRAY)), new Build.CFP(this.myStatsPanel[1]), new Build.CFP(this.myMessagePanel[1])});
        Build.NCS p = new Build.NCS(new Build.CFP(this.waitSponsorPanel), tmp, new Build.CP(null, new BarPanel(24, 191, COLORKEYBOARD, 16, Color.white), new ImagePanel(this.images[9], 799, 191, COLORKEYBOARD), new BarPanel(9, 191, COLORKEYBOARD, 16, Color.white), null));
        p.setBackground(Color.white);
        this.makeWhite(tmp);
        return p;
    }

    protected JPanel createEditorPanel() {
        JPanel topLevel = new JPanel(new BorderLayout());
        this.editorTab = new JTabbedPane();
        this.consoleTab = new JTabbedPane();
        this.buttonBar = new Box(0);
        this.buttonBar.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.myLineLabel = new JLabel("Line : 1", 4);
        this.myLineLabel.setPreferredSize(new Dimension(64, 16));
        this.myClockLabel = new JLabel("29:59", 4);
        this.myClockLabel.setPreferredSize(new Dimension(64, 16));
        this.myClearDisplaysBeforeTest.setToolTipText("Clear consoles before each test.");
        this.myClearDisplaysBeforeTest.setSelected(true);
        JPanel right = new JPanel(new FlowLayout(2));
        right.add(this.myClearDisplaysBeforeTest);
        right.add(this.myClockLabel);
        right.add(this.myLineLabel);
        JPanel lrPanel = new JPanel(new BorderLayout());
        JPanel controlPage = new JPanel(new BorderLayout());
        controlPage.add((Component)lrPanel, "North");
        lrPanel.add((Component)this.buttonBar, "Center");
        lrPanel.add((Component)right, "East");
        controlPage.add((Component)this.consoleTab, "Center");
        JSplitPane splitPane = new JSplitPane(0, this.editorTab, controlPage);
        topLevel.add((Component)splitPane, "Center");
        this.addConsoleTab(this.consoleTab, "Output", true);
        splitPane.setDividerLocation(368);
        splitPane.setResizeWeight(0.75);
        Build.RFP tmp = new Build.RFP(new ImagePanel(this.images[8], 498, 32, Color.white));
        tmp.setBackground(Color.white);
        topLevel.add((Component)tmp, "South");
        return topLevel;
    }

    protected JPanel createFinishedPanel() {
        JLabel resultLabel = new JLabel("Your Score");
        resultLabel.setFont(MEDIUM);
        ResultPanel score = new ResultPanel(this.images[3], this.images[2]);
        this.myStatsPanel[3] = score;
        this.myMessagePanel[3] = new JLabel("", 0);
        this.myMessagePanel[3].setPreferredSize(new Dimension(512, 24));
        this.finishedSponsorPanel = new AssignmentSponsorPanel();
        Build.BOXY tmp = new Build.BOXY(new JComponent[]{new Build.CFP(this.finishedSponsorPanel), new Build.CFP(resultLabel), new Build.CFP(score), new Build.CFP(this.myMessagePanel[3])});
        Build.NCS p = new Build.NCS(new ImagePanel(this.images[10], 800, 128, DARKGREEN), tmp, new ImagePanel(this.images[11], 800, 128, DARKGREEN));
        this.makeWhite(tmp);
        return p;
    }

    protected JPanel createLoginPanel() {
        this.userNameField = new JTextField(10);
        this.passwordField = new JPasswordField(10);
        this.serverCB = new JComboBox<Object>(new Object[]{this.server});
        final JLabel serverCBLabel = new JLabel("Server :  ", 4);
        this.serverCB.setVisible(false);
        serverCBLabel.setVisible(false);
        JLabel advancedLabel = new JLabel("Advanced :  ", 4);
        final JCheckBox advanced = new JCheckBox();
        advancedLabel.setLabelFor(advanced);
        advanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientApplet.this.serverCB.setVisible(advanced.getModel().isSelected());
                serverCBLabel.setVisible(advanced.getModel().isSelected());
            }
        });
        this.serverCB.setEditable(true);
        this.loginButton = new JButton("Login");
        JLabel msg = new JLabel("", 0);
        msg.setPreferredSize(new Dimension(400, 12));
        this.myMessagePanel[0] = msg;
        Build.NWCES p = new Build.NWCES(new Build.Spacer(32, 32), null, new Build.NBOXY(new JComponent[]{new Build.CP(null, new BarPanel(116, 22, NLJUGORANGE, 400), new ImagePanel(this.images[4], 320, 138, Color.white), new BarPanel(116, 22, NLJUGORANGE, 400), null), new Build.Spacer(8, 8), new Build.Grid(0, 5, new JComponent[]{null, new JLabel("TeamName :  ", 4), this.userNameField, null, null, null, new JLabel("Password :  ", 4), this.passwordField, null, null}), new Build.Grid(0, 5, new JComponent[]{null, advancedLabel, advanced, null, null, null, serverCBLabel, this.serverCB, null}), new Build.CFP(msg), new Build.Grid(0, 10, new JComponent[]{null, null, null, null, null, this.loginButton})}), null, new Build.RFP(new ImagePanel(this.images[8], 498, 32, Color.white)));
        this.makeWhite(p);
        ActionListener logonAction = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ClientApplet.this.serverCB && "comboBoxChanged".equals(e.getActionCommand())) {
                    return;
                }
                try {
                    if (!ClientApplet.this.loginButton.isEnabled()) {
                        return;
                    }
                    ClientApplet.this.teamName = ClientApplet.this.userNameField.getText();
                    ClientApplet.this.password = Encoder.hash(ClientApplet.this.passwordField.getText());
                    ClientApplet.this.selectedServer = ClientApplet.this.server;
                    if (advanced.getModel().isSelected()) {
                        ClientApplet.this.selectedServer = ClientApplet.this.serverCB.getModel().getSelectedItem().toString();
                    }
                    ClientApplet.this.userNameField.setEnabled(false);
                    ClientApplet.this.passwordField.setEnabled(false);
                    ClientApplet.this.loginButton.setEnabled(false);
                    ClientApplet.this.serverCB.setEnabled(false);
                    ClientApplet.this.makeTitle();
                    if (!ClientApplet.this.shouldRun) {
                        new Thread(ClientApplet.this).start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(ClientApplet.this.loginButton, "Error encoding password : " + ex);
                }
                finally {
                    ClientApplet.this.passwordField.setText("");
                }
            }
        };
        this.loginButton.addActionListener(logonAction);
        this.passwordField.addActionListener(logonAction);
        this.serverCB.addActionListener(logonAction);
        return p;
    }

    private void makeWhite(JComponent c) {
        Build.visit(c, new Build.Visitor(){

            @Override
            public void visit(JComponent c) {
                if (c instanceof JButton) {
                    c.setBackground(new Color(16426615));
                } else {
                    c.setBackground(Color.white);
                }
            }
        });
    }

    protected JPanel createTestSetPanel(Message.TestSet tst) {
        JPanel p = new JPanel(new BorderLayout());
        JPanel bx = new JPanel(new GridLayout(0, 1));
        BoxLayout bl = new BoxLayout(bx, 1);
        bx.setLayout(bl);
        JScrollPane sp = new JScrollPane(bx);
        sp.getVerticalScrollBar().setUnitIncrement(32);
        p.add((Component)sp, "Center");
        int cnt = 0;
        this.myTestPanels = new TestPanel[tst.getCount()];
        for (int t = 0; t < this.myTestPanels.length; ++t) {
            this.myTestPanels[t] = new TestPanel(tst.getName(t), tst.getDescription(t), t, cnt % 2 == 0);
            bx.add(this.myTestPanels[t]);
            ++cnt;
        }
        JPanel tmp = new JPanel(new BorderLayout());
        JPanel tmp2 = new JPanel(new FlowLayout(2));
        JButton testAllButton = new JButton("Test All");
        testAllButton.setMnemonic('A');
        testAllButton.setActionCommand(TEST);
        testAllButton.addActionListener(this);
        tmp2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        tmp2.add(testAllButton);
        tmp.add((Component)tmp2, "South");
        bx.add(tmp);
        return p;
    }

    protected String translateConsoleTab(int testIdx) {
        return "Test " + (testIdx + 1);
    }

    protected String translateConsoleTab(String name) {
        if ("Output".equals(name)) {
            return name;
        }
        try {
            return "Test " + (Integer.parseInt(name) + 1);
        }
        catch (Exception ex) {
            return name;
        }
    }

    protected void updateTestSet(Message.TestSet tst) {
        int idx = this.editorTab.indexOfTab("Test-Set");
        if (idx < 0) {
            this.editorTab.addTab("Test-Set", this.createTestSetPanel(tst));
            idx = this.editorTab.indexOfTab("Test-Set");
            this.editorTab.setMnemonicAt(idx, 49 + idx);
            int nr = tst.getCount();
            for (int t = 0; t < nr; ++t) {
                this.addConsoleTab(this.consoleTab, this.translateConsoleTab(t), true);
            }
        }
    }

    public boolean canClose() {
        return JOptionPane.showConfirmDialog(this, "Exit Client", "Exit Client : Sure ?", 2) == 0;
    }

    public void start() {
        if (this.canRun()) {
            new Thread(this).start();
        } else {
            this.setState(0);
        }
        this.userNameField.requestFocus();
    }

    public void stop() {
        this.shouldRun = false;
        if (this.canRun()) {
            try {
                DataOutput out = this.getDataOutput();
                new GoodbyeMessageImpl().write(out);
                ((DataOutputStream)out).flush();
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }

    public void destroy() {
    }

    @Override
    public boolean fileNameExists(String name) {
        return this.knownFileNames.contains(name);
    }

    protected boolean canRun() {
        return this.teamName != null && this.password != null;
    }

    protected void updateStats(Message.UpdateClientStatistics msg) {
        int s = this.myActiveTab;
        this.remoteStats = msg;
        if (this.myStatsPanel[s] != null) {
            this.myStatsPanel[s].repaint();
        }
        int[] tst = msg.getTestResults();
        this.updateTestResults(tst);
        int sec = msg.getSecondsRemaining();
        int min = sec / 60;
        sec %= 60;
        if (min < 5) {
            this.myClockLabel.setForeground(sec % 2 == 0 ? Color.RED : Color.black);
        } else {
            this.myClockLabel.setForeground(Color.black);
        }
        this.myClockLabel.setText((min < 10 ? "0" + min : "" + min) + ":" + (sec < 10 ? "0" + sec : "" + sec));
    }

    protected void clearTestResults() {
        if (this.myTestPanels == null) {
            return;
        }
        for (int t = 0; t < this.myTestPanels.length; ++t) {
            TestPanel tp = this.myTestPanels[t];
            this.consoleTab.setIconAt(t + 1, this.testUnknown);
            tp.clearResult();
        }
    }

    protected void updateTestResults(int[] r) {
        if (this.myTestPanels == null) {
            return;
        }
        if (r == null) {
            return;
        }
        for (int t = 0; t < this.myTestPanels.length; ++t) {
            TestPanel tp = this.myTestPanels[t];
            int ti = tp.getTestIndex();
            if (ti < r.length) {
                switch (r[ti]) {
                    case -1: {
                        this.consoleTab.setIconAt(t + 1, this.testFailed);
                        tp.setResult(false);
                        break;
                    }
                    case 0: {
                        this.consoleTab.setIconAt(t + 1, this.testUnknown);
                        tp.clearResult();
                        break;
                    }
                    case 1: {
                        this.consoleTab.setIconAt(t + 1, this.testSuccess);
                        tp.setResult(true);
                    }
                }
                continue;
            }
            this.consoleTab.setIconAt(t + 1, this.testFailed);
            tp.setResult(false);
        }
    }

    protected void setAnimation(int test, Anim a) {
        this.getAnimPlayer(this.consoleTab, test).setAnimation(a);
    }

    protected void addMessage(String tab, String msg) {
        int s = this.myActiveTab;
        if (s == 2) {
            int idx = this.consoleTab.indexOfTab(tab);
            if (idx < 0) {
                JList tmp = this.addConsoleTab(this.consoleTab, tab, true);
                ((DefaultListModel)tmp.getModel()).addElement(msg);
            } else {
                JList tmp = this.getConsoleTab(this.consoleTab, tab);
                DefaultListModel dlm = (DefaultListModel)tmp.getModel();
                dlm.addElement(msg);
                tmp.setSelectedIndex(dlm.getSize() - 1);
                while (dlm.size() > 512) {
                    dlm.remove(0);
                }
                final JScrollPane p = this.getScrollPane(this.consoleTab, tab);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int mx = p.getVerticalScrollBar().getMaximum();
                        p.getVerticalScrollBar().setValue(mx);
                    }
                });
                if (this.isImportant(msg) && idx == 0) {
                    this.consoleTab.setSelectedComponent(this.consoleTab.getComponent(idx));
                }
            }
        } else if (this.myMessagePanel[s] != null) {
            this.myMessagePanel[s].setText(msg);
        }
    }

    private boolean isImportant(String msg) {
        if (msg == null) {
            return false;
        }
        return msg.toLowerCase().indexOf("error") >= 0;
    }

    protected void setText(String editor, String text, boolean isJava, boolean readOnly, boolean isMonospaced) {
        int idx = this.editorTab.indexOfTab(editor);
        if (idx < 0) {
            this.addSourceEditor(this.editorTab, editor, isJava, readOnly, isMonospaced, text);
            if (readOnly && isJava) {
                try {
                    this.myCC.addStaticSource(text);
                }
                catch (Exception ex) {
                    System.err.println("** Failed parsing : " + editor + " ** : " + ex);
                }
            }
        } else {
            JEditorPane tmp = this.getSourceEditor(this.editorTab, editor);
            tmp.setText(text);
        }
    }

    protected JList addConsoleTab(JTabbedPane tab, String name, boolean readOnly) {
        final JList<Object> ta = new JList<Object>();
        ta.setFont(MONOSPACEFONT);
        ta.setModel(new DefaultListModel());
        JScrollPane sp = new JScrollPane(ta);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem clear = new JMenuItem("clear");
        clear.addActionListener(new JListClearListener(ta));
        JMenuItem clearAll = new JMenuItem("clear All");
        clearAll.addActionListener(new ConsoleClearListener(tab));
        popup.add(clear);
        popup.add(clearAll);
        ta.addMouseListener(new PopupShower(popup));
        if (name.startsWith(TEST)) {
            AnimPlayer ap = new AnimPlayer();
            JSplitPane splitPane = new JSplitPane(1, sp, ap);
            tab.addTab(name, this.testUnknown, splitPane);
            int idx = tab.indexOfTab(name);
            JMenuItem test = new JMenuItem("run Test-case");
            test.setActionCommand(TEST);
            JMenuItem testAll = new JMenuItem("run all Test-cases");
            testAll.setActionCommand(TEST);
            test.addActionListener(new IndexActionListener(idx - 1));
            testAll.addActionListener(this);
            popup.add(test);
            popup.add(testAll);
            splitPane.setDividerLocation(640);
            splitPane.addPropertyChangeListener("dividerLocation", this.theDividerSyncer);
            ta.setCellRenderer(new StacktraceHighlightingCellRenderer(this));
            final JMenuItem gotoError = new JMenuItem("goto Error");
            popup.add(gotoError);
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = ta.getSelectedIndex();
                    if (idx >= 0) {
                        JEditorPane tmp;
                        int lnr = StacktraceHighlightingCellRenderer.getErrorLineNr(String.valueOf(ta.getModel().getElementAt(idx)));
                        String file = StacktraceHighlightingCellRenderer.getErrorFile(String.valueOf(ta.getModel().getElementAt(idx)), ClientApplet.this);
                        if (lnr >= 0 && file != null && (tmp = ClientApplet.this.getSourceEditor(ClientApplet.this.editorTab, file)) != null) {
                            ClientApplet.this.scrollToLine(tmp, lnr);
                            ClientApplet.this.editorTab.setSelectedComponent(tmp.getParent().getParent());
                        }
                    }
                }
            };
            gotoError.addActionListener(al);
            ta.addMouseListener(new DoubleClickListener(al));
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    int idx = ta.getSelectedIndex();
                    if (idx >= 0) {
                        int lnr = StacktraceHighlightingCellRenderer.getErrorLineNr(String.valueOf(ta.getModel().getElementAt(idx)));
                        String file = StacktraceHighlightingCellRenderer.getErrorFile(String.valueOf(ta.getModel().getElementAt(idx)), ClientApplet.this);
                        gotoError.setEnabled(lnr >= 0 && file != null);
                    } else {
                        gotoError.setEnabled(false);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }
            });
        } else {
            tab.addTab(name, sp);
            ta.setCellRenderer(new ErrorHighlightingCellRenderer());
            final JMenuItem gotoError = new JMenuItem("goto Error");
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = ta.getSelectedIndex();
                    if (idx >= 0) {
                        JEditorPane tmp;
                        int lnr = ErrorHighlightingCellRenderer.getErrorLineNr(String.valueOf(ta.getModel().getElementAt(idx)));
                        String file = ErrorHighlightingCellRenderer.getErrorFile(String.valueOf(ta.getModel().getElementAt(idx)));
                        if (lnr >= 0 && file != null && (tmp = ClientApplet.this.getSourceEditor(ClientApplet.this.editorTab, file)) != null) {
                            ClientApplet.this.scrollToLine(tmp, lnr);
                            ClientApplet.this.editorTab.setSelectedComponent(tmp.getParent().getParent());
                        }
                    }
                }
            };
            gotoError.addActionListener(al);
            ta.addMouseListener(new DoubleClickListener(al));
            popup.add(gotoError);
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    int idx = ta.getSelectedIndex();
                    if (idx >= 0) {
                        int lnr = ErrorHighlightingCellRenderer.getErrorLineNr(String.valueOf(ta.getModel().getElementAt(idx)));
                        String file = ErrorHighlightingCellRenderer.getErrorFile(String.valueOf(ta.getModel().getElementAt(idx)));
                        gotoError.setEnabled(lnr >= 0 && file != null);
                    } else {
                        gotoError.setEnabled(false);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }
            });
        }
        return ta;
    }

    protected void scrollToLine(JEditorPane pane, int line) {
        int pos = -1;
        String txt = pane.getText();
        for (int t = 0; t < txt.length(); ++t) {
            if (txt.charAt(t) != '\n' || --line != 0) continue;
            pos = t;
        }
        if (pos != -1) {
            Caret caret = pane.getCaret();
            caret.setDot(pos);
            pane.requestFocus();
        }
    }

    protected JList getConsoleTab(JTabbedPane tab, String name) {
        int idx = tab.indexOfTab(name);
        JComponent c = (JComponent)tab.getComponentAt(idx);
        if (idx == 0) {
            return (JList)((JScrollPane)c).getViewport().getComponents()[0];
        }
        JScrollPane sp = (JScrollPane)c.getComponent(0);
        return (JList)sp.getViewport().getComponents()[0];
    }

    protected void clearAllConsoles(JTabbedPane tab) {
        for (int t = 0; t < tab.getComponentCount(); ++t) {
            JList lst = null;
            JComponent c = (JComponent)tab.getComponentAt(t);
            if (t == 0) {
                lst = (JList)((JScrollPane)c).getViewport().getComponents()[0];
            } else {
                JScrollPane sp = (JScrollPane)c.getComponent(0);
                lst = (JList)sp.getViewport().getComponents()[0];
            }
            if (lst == null) continue;
            DefaultListModel lm = (DefaultListModel)lst.getModel();
            lm.clear();
        }
    }

    protected JScrollPane getScrollPane(JTabbedPane tab, String name) {
        int idx = tab.indexOfTab(name);
        JComponent c = (JComponent)tab.getComponentAt(idx);
        if (idx == 0) {
            return (JScrollPane)c;
        }
        return (JScrollPane)c.getComponent(0);
    }

    protected AnimPlayer getAnimPlayer(JTabbedPane tab, int testIdx) {
        int idx = testIdx + 1;
        JComponent c = (JComponent)tab.getComponentAt(idx);
        AnimPlayer ap = (AnimPlayer)c.getComponent(1);
        return ap;
    }

    protected JEditorPane addSourceEditor(JTabbedPane tab, String name, boolean isJava, boolean readOnly, boolean isMono, String text) {
        this.knownFileNames.add(name);
        final JEditorPane editor = new JEditorPane();
        editor.setEditorKitForContentType("text/java", javaEditorKit);
        if (isJava) {
            editor.setContentType("text/java");
        }
        editor.setEditable(!readOnly);
        if (readOnly) {
            editor.setBackground(READONLYEDITOR);
        }
        editor.getActionMap().put("insert-tab", new InsertTabAction(TABCHARS));
        editor.getActionMap().put("caret-next-word", new JavaWordAction("caret-next-word", false, true));
        editor.getActionMap().put("selection-next-word", new JavaWordAction("selection-next-word", true, true));
        editor.getActionMap().put("caret-previous-word", new JavaWordAction("caret-previous-word", false, false));
        editor.getActionMap().put("selection-previous-word", new JavaWordAction("selection-previous-word", true, false));
        JScrollPane sp = new JScrollPane(editor);
        tab.addTab(name, sp);
        int idx = this.editorTab.indexOfTab(name);
        this.editorTab.setMnemonicAt(idx, 49 + idx);
        if (isMono) {
            editor.setFont(MONOSPACEFONT);
        }
        editor.setText(text);
        editor.setCaretPosition(0);
        if (!readOnly) {
            final JavaUndoManager um = new JavaUndoManager();
            editor.getDocument().addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    um.addEdit(e.getEdit());
                }
            });
            editor.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    JavaDocument jd = (JavaDocument)editor.getDocument();
                    ClientApplet.this.myLineLabel.setText("Line : " + String.valueOf(jd.getLineNumber(e.getDot()) + 1));
                }
            });
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    ClientApplet.this.keyStroke();
                    if (e.getKeyCode() == 32 && (e.getModifiers() & 2) != 0) {
                        ClientApplet.this.autoCompleteTrigger(editor);
                    }
                    if (e.getKeyCode() == 90 && (e.getModifiers() & 2) != 0) {
                        try {
                            if (um.canUndo()) {
                                um.undo();
                            }
                            while (um.canUndo() && !um.isInsertOrDelete()) {
                                um.undo();
                            }
                        }
                        catch (CannotUndoException ex) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }
            });
        }
        return editor;
    }

    private void autoCompleteTrigger(final JEditorPane editor) {
        Point p = new Point(editor.getCaret().getMagicCaretPosition());
        for (Container c = editor; c != null && !(c instanceof Window); c = c.getParent()) {
            p.x += c.getLocation().x;
            p.y += c.getLocation().y;
        }
        int len = 0;
        int pos = editor.getCaretPosition();
        String txt = "";
        while (pos > 0) {
            try {
                txt = editor.getDocument().getText(--pos, ++len);
                if (txt.charAt(0) != '\n') continue;
                txt = editor.getDocument().getText(pos + 1, len - 1);
                break;
            }
            catch (BadLocationException ex) {
                txt = "";
            }
        }
        txt = txt.trim();
        final PartialCode base = this.myCC.getPartToComplete(txt);
        final JList<String> cmp = new JList<String>(this.myCC.getCompletions(editor.getText(), editor.getCaretPosition(), base));
        cmp.setFont(CODECOMPLETIONFONT);
        cmp.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane sp = new JScrollPane(cmp);
        sp.setPreferredSize(new Dimension(256, 96));
        final FocusablePopup pop = FocusablePopup.getPopup(editor, sp, p.x, p.y);
        cmp.requestFocus();
        cmp.setSelectedIndex(0);
        cmp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                pop.closePopup();
            }
        });
        cmp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        String sel;
                        if (cmp.getSelectedIndex() >= 0 && cmp.getModel().getSize() != 0 && (sel = cmp.getSelectedValue().toString()).length() >= base.length()) {
                            editor.getDocument().insertString(editor.getCaretPosition(), sel.substring(base.length()), null);
                        }
                        pop.closePopup();
                        editor.requestFocus();
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (e.getKeyCode() == 27) {
                    pop.closePopup();
                    editor.requestFocus();
                }
            }
        });
        cmp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (cmp.getSelectedIndex() >= 0 && cmp.getModel().getSize() != 0) {
                        editor.getDocument().insertString(editor.getCaretPosition(), cmp.getSelectedValue().toString().substring(base.length()), null);
                    }
                    pop.closePopup();
                    editor.requestFocus();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private synchronized void keyStroke() {
        ++this.myKeyStrokes;
    }

    private synchronized int getKeyStrokes() {
        int r = this.myKeyStrokes;
        this.myKeyStrokes = 0;
        return r;
    }

    protected JEditorPane getSourceEditor(JTabbedPane tab, String name) {
        int idx = tab.indexOfTab(name);
        if (idx < 0) {
            return null;
        }
        JScrollPane sp = (JScrollPane)tab.getComponentAt(idx);
        return (JEditorPane)sp.getViewport().getComponents()[0];
    }

    protected void addOperation(String label, String tooltip, boolean confirm) {
        final JButton btn = new JButton(label);
        if (COMPILE.equalsIgnoreCase(label)) {
            btn.setMnemonic('C');
            btn.setIcon(new ImageIcon(this.images[5]));
        }
        if (TEST.equalsIgnoreCase(label)) {
            btn.setMnemonic('T');
            btn.setIcon(new ImageIcon(this.images[6]));
        }
        if ("Submit".equalsIgnoreCase(label)) {
            btn.setMnemonic('u');
            btn.setIcon(new ImageIcon(this.images[7]));
        }
        if ("Save".equalsIgnoreCase(label)) {
            btn.setActionCommand(label);
            btn.setMnemonic('S');
            btn.setIcon(new ImageIcon(this.images[12]));
            KeyStroke ks = KeyStroke.getKeyStroke("ctrl S");
            btn.getInputMap(2).put(ks, btn.getActionCommand());
            btn.getActionMap().put(btn.getActionCommand(), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    e = new ActionEvent(btn, 1001, btn.getActionCommand());
                    ClientApplet.this.actionPerformed(e);
                }
            });
        }
        btn.setToolTipText(tooltip);
        this.buttonBar.add(btn);
        this.buttonBar.add(Box.createHorizontalStrut(8));
        if (confirm) {
            btn.addActionListener(new ConfirmingActionListener(btn, this));
        } else {
            btn.addActionListener(this);
        }
    }

    protected void setState(int newState) {
        if (this.teamName == null || this.password == null || !this.loggedIn) {
            this.myActiveTab = 0;
            ((CardLayout)this.getLayout()).show(this, "-");
        } else {
            if (this.myActiveTab == newState + 1) {
                return;
            }
            switch (newState) {
                case 0: {
                    this.myActiveTab = 1;
                    break;
                }
                case 1: {
                    this.myActiveTab = 2;
                    break;
                }
                case 2: {
                    this.myActiveTab = 3;
                    break;
                }
                default: {
                    this.myActiveTab = 0;
                }
            }
            ((CardLayout)this.getLayout()).show(this, String.valueOf(this.myActiveTab - 1));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.indexedActionPerformed(e, -1);
    }

    protected void indexedActionPerformed(ActionEvent e, int idx) {
        String file = null;
        String data = null;
        int cnt = this.editorTab.getTabCount();
        for (int t = 0; t < cnt; ++t) {
            JScrollPane sp;
            JEditorPane p;
            Component c = this.editorTab.getComponent(t);
            if (!(c instanceof JScrollPane) || !(p = (JEditorPane)(sp = (JScrollPane)c).getViewport().getComponents()[0]).isEditable()) continue;
            file = this.editorTab.getTitleAt(t);
            data = p.getText();
        }
        if (COMPILE.equals(e.getActionCommand())) {
            this.consoleTab.setSelectedIndex(0);
        }
        if (TEST.equals(e.getActionCommand())) {
            this.clearTestResults();
            if (this.myClearDisplaysBeforeTest.isSelected()) {
                this.clearAllConsoles(this.consoleTab);
            }
        }
        try {
            if (file == null || data == null) {
                throw new IOException("No editable source.");
            }
            DataOutput out = this.getDataOutput();
            new ActionMessageImpl(file, data, e.getActionCommand(), idx, this.getKeyStrokes()).write(out);
            ((DataOutputStream)out).flush();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Action Failed. Please try again.\nReason : " + ex.getMessage());
        }
    }

    public void setLogin(String username, String password) {
        this.userNameField.setText(username);
        this.passwordField.setText(password);
    }

    protected void forceLogout(String reason) {
        this.editorTab.removeAll();
        this.consoleTab.removeAll();
        this.knownFileNames.clear();
        this.addConsoleTab(this.consoleTab, "Output", true);
        this.buttonBar.removeAll();
        this.teamName = null;
        this.password = null;
        this.loggedIn = false;
        this.setState(0);
        this.addMessage("Output", reason);
        this.userNameField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.loginButton.setEnabled(true);
        this.serverCB.setEnabled(true);
        this.userNameField.requestFocus();
        this.makeTitle();
    }

    protected synchronized void newConnection() throws IOException {
        this.mySocket = new Socket(InetAddressUtil.makeInetAddress(this.selectedServer), this.serverPort);
        this.myDataInput = new DataInputStream(this.mySocket.getInputStream());
        this.myDataOutput = new DataOutputStream(this.mySocket.getOutputStream());
        new HelloMessageImpl(this.teamName, this.password).write(this.myDataOutput);
    }

    protected synchronized DataInput getDataInput() throws IOException {
        if (this.mySocket == null || !this.mySocket.isConnected()) {
            this.newConnection();
        }
        return this.myDataInput;
    }

    protected synchronized DataOutput getDataOutput() throws IOException {
        if (this.mySocket == null || !this.mySocket.isConnected()) {
            this.newConnection();
        }
        return this.myDataOutput;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 19[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            if (args.length == 1) {
                args = new String[]{args[0], "8080"};
            } else {
                System.out.println("Usage : ClientApplet <server ip address> <port>");
                args = new String[]{"127.0.0.1", "8080"};
            }
        }
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }

            @Override
            public void checkPermission(Permission perm, Object context) {
            }

            public void checkSystemClipboardAccess() {
                throw new SecurityException();
            }
        });
        JFrame f = new JFrame();
        f.setSize(800, 600);
        final ClientApplet ca = new ClientApplet(f, args[0], args[1]);
        f.getContentPane().add(ca);
        f.setVisible(true);
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ca.canClose()) {
                    ca.stop();
                    ca.destroy();
                    System.exit(0);
                }
            }
        });
        ca.init();
        ca.start();
    }

    private class IndexActionListener
    implements ActionListener {
        private int idx;

        public IndexActionListener(int idx) {
            this.idx = idx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClientApplet.this.indexedActionPerformed(e, this.idx);
        }
    }

    private class DividerSyncer
    implements PropertyChangeListener {
        private boolean changing;

        private DividerSyncer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.changing) {
                return;
            }
            this.changing = true;
            try {
                Component[] c = ClientApplet.this.consoleTab.getComponents();
                for (int t = 0; t < c.length; ++t) {
                    if (c[t] == null || !(c[t] instanceof JSplitPane) || evt.getSource() == c[t]) continue;
                    ((JSplitPane)c[t]).setDividerLocation((Integer)evt.getNewValue());
                }
            }
            finally {
                this.changing = false;
            }
        }
    }

    private class ConsoleClearListener
    implements ActionListener {
        private JTabbedPane tab;

        public ConsoleClearListener(JTabbedPane tab) {
            this.tab = tab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClientApplet.this.clearAllConsoles(this.tab);
        }
    }

    private static class JListClearListener
    implements ActionListener {
        private JList list;

        public JListClearListener(JList l) {
            this.list = l;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel lm = (DefaultListModel)this.list.getModel();
            lm.clear();
        }
    }

    private static class PopupShower
    extends MouseAdapter {
        private JPopupMenu pm;

        public PopupShower(JPopupMenu pm) {
            this.pm = pm;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.pm.show((Component)e.getSource(), e.getX(), e.getY());
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.pm.show((Component)e.getSource(), e.getX(), e.getY());
                e.consume();
            }
        }
    }

    private static class BarPanel
    extends JPanel {
        private int y;
        private int dy;
        private Color c;

        public BarPanel(int y, int dy, Color c, int w) {
            this(y, dy, c, w, null);
        }

        public BarPanel(int y, int dy, Color c, int w, Color back) {
            this.y = y;
            this.dy = dy;
            this.c = c;
            this.setPreferredSize(new Dimension(w, 64));
            if (back != null) {
                this.setBackground(back);
            }
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.c);
            g.fillRect(0, this.y, this.getWidth(), this.dy);
        }
    }

    class TestPanel
    extends JPanel
    implements ActionListener {
        private JButton testButton;
        private JPanel testResult;
        private int myIndex;

        public TestPanel(String name, String description, int idx, boolean hi) {
            super(new BorderLayout());
            this.setBackground(hi ? HI : LO);
            this.myIndex = idx;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            JLabel lbl = new JLabel(idx + 1 + ": " + name, 4);
            lbl.setPreferredSize(new Dimension(160, 24));
            this.testResult = new JPanel();
            this.testResult.setPreferredSize(new Dimension(64, 24));
            this.testResult.setBorder(BorderFactory.createBevelBorder(1));
            this.testResult.setBackground(Color.yellow);
            this.testButton = new JButton(ClientApplet.TEST);
            this.testButton.addActionListener(this);
            Build.NBOXY top = new Build.NBOXY(new JComponent[]{new Build.RFP((JComponent)lbl, this.getBackground()), new Build.RFP((JComponent)this.testResult, this.getBackground()), new Build.RFP((JComponent)this.testButton, this.getBackground())});
            top.setBackground(this.getBackground());
            top.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.add((Component)top, "West");
            JTextArea txt = new JTextArea(description);
            txt.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            txt.setEditable(false);
            txt.setLineWrap(true);
            txt.setWrapStyleWord(true);
            txt.setFont(MONOSPACEFONT);
            this.add((Component)txt, "Center");
        }

        public void clearResult() {
            this.testResult.setBackground(Color.yellow);
            this.repaint();
        }

        public void setResult(boolean ok) {
            this.testResult.setBackground(ok ? Color.green : Color.red);
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClientApplet.this.indexedActionPerformed(e, this.myIndex);
        }

        public int getTestIndex() {
            return this.myIndex;
        }
    }

    private class ResultPanel
    extends JPanel {
        private Image win;
        private Image loose;

        public ResultPanel(Image win, Image loose) {
            this.setPreferredSize(new Dimension(256, 72));
            this.win = win;
            this.loose = loose;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ClientApplet.this.remoteStats == null) {
                return;
            }
            g.setColor(Color.black);
            int score = ClientApplet.this.remoteStats.getFinalScore();
            String sc = String.valueOf(score);
            g.setFont(BIG);
            int w = g.getFontMetrics().stringWidth(sc);
            g.drawString(sc, 160 - w, 64);
            g.setFont(SMALL);
            g.drawString("pts", 164, 64);
            if (score > 0) {
                g.drawImage(this.win, 200, 32, null);
            } else {
                g.drawImage(this.loose, 200, 32, null);
            }
        }
    }

    private class PlayerCountPanel
    extends JPanel {
        private Image myImgOn;
        private Image myImgOff;

        public PlayerCountPanel(Image on, Image off) {
            this.myImgOn = on;
            this.myImgOff = off;
            this.setPreferredSize(new Dimension(512, 72));
        }

        @Override
        public void paint(Graphics g) {
            int ih;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int iw = this.myImgOn.getWidth(null);
            if (iw == 0) {
                iw = 32;
            }
            if ((ih = this.myImgOn.getHeight(null)) == 0) {
                ih = 32;
            }
            int md = this.getWidth() / iw;
            if (ClientApplet.this.remoteStats == null) {
                return;
            }
            int rx = ClientApplet.this.remoteStats.getTeamCount() > md ? md : ClientApplet.this.remoteStats.getTeamCount();
            int cx = this.getWidth() / 2 - rx * iw / 2;
            for (int t = 0; t < ClientApplet.this.remoteStats.getTeamCount(); ++t) {
                if (t < ClientApplet.this.remoteStats.getTeamsOnline()) {
                    g.drawImage(this.myImgOn, cx + t % md * iw, t / md * ih, null);
                    continue;
                }
                g.drawImage(this.myImgOff, cx + t % md * iw, t / md * ih, null);
            }
        }
    }
}

