/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import nl.moj.client.io.Message;

public class AssignmentSponsorPanel
extends JPanel {
    private String name;
    private String author;
    private Image icon;
    private Image sponsor;
    private Font textFont = new Font("Verdana", 1, 22);
    private Font smallFont = new Font("Verdana", 0, 12);

    public AssignmentSponsorPanel() {
        this.setPreferredSize(new Dimension(321, 65));
    }

    public void setAssignmentData(Message.Assignment a) {
        this.name = a.getName();
        this.setPreferredSize(new Dimension(150 + this.name.length() * 16 > 321 ? 150 + this.name.length() * 16 : 321, 65));
        this.author = "by " + a.getAuthor();
        if (a.getIcon() != null) {
            try {
                this.icon = ImageIO.read(new ByteArrayInputStream(a.getIcon()));
            }
            catch (IOException ex) {
                this.icon = null;
            }
        }
        if (a.getSponsorImage() != null) {
            try {
                this.sponsor = ImageIO.read(new ByteArrayInputStream(a.getSponsorImage()));
            }
            catch (IOException ex) {
                this.sponsor = null;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintBorder(g);
        int left = 0;
        int width = this.getWidth();
        int top = this.getHeight() / 2 - 32;
        g.setColor(Color.white);
        g.fillRect(0, top, width, 64);
        g.setColor(Color.lightGray);
        if (this.icon != null) {
            g.drawImage(this.icon, left + 1, top, null);
            g.drawRect(left, top, 65, 64);
        }
        if (this.sponsor != null) {
            g.drawImage(this.sponsor, width - 97, top, null);
            g.drawRect(width - 98, top, 97, 64);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.name != null) {
            g.setColor(Color.black);
            g.setFont(this.textFont);
            g.drawString(this.name, left + 72, top + 22);
        }
        if (this.author != null) {
            g.setColor(Color.gray);
            g.setFont(this.smallFont);
            g.drawString(this.author, left + 73, top + 36);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(Color.lightGray);
        g.drawRect(left, top, width, 64);
    }
}

