/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.assignment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Manifest;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.moj.assignment.AbstractAssignment;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.operation.Compile;
import nl.moj.operation.Save;
import nl.moj.operation.Submit;
import nl.moj.operation.Test;
import nl.moj.process.ProcessPool;
import nl.moj.test.FileArrayClassLoader;

public class MoJEclipsePluginAssignment
extends AbstractAssignment
implements Assignment {
    private ProcessPool pool;
    private ApplicationBuilder builder;
    private File[] classFiles;
    private FileResource manifestResource;
    private FileResource[] resources;

    public MoJEclipsePluginAssignment(File f, ProcessPool p, ApplicationBuilder b) throws Exception {
        this.pool = p;
        this.builder = b;
        this.determineResources(f);
        this.parseManifest(this.getManifest());
    }

    @Override
    protected Operation[] createOperations() throws Exception {
        this.theOps = new Operation[4];
        this.theOps[0] = new Save(this.pool);
        this.theOps[1] = new Compile(this.pool);
        this.theOps[2] = new Test((Assignment)this, this.pool, this.classFiles);
        this.theOps[3] = new Submit((Assignment)this, this.pool, this.classFiles);
        return this.theOps;
    }

    @Override
    protected ClassLoader createSecurityDelegateClassLoader() {
        return new FileArrayClassLoader(this.classFiles, this.getClass().getClassLoader(), false);
    }

    @Override
    protected ApplicationBuilder getApplicationBuilder() {
        return this.builder;
    }

    @Override
    public InputStream getAssignmentFileData(String name) throws IOException {
        AbstractAssignment.Resource res = this.getResource(name);
        if (res == null) {
            return null;
        }
        return this.getInputStream(res);
    }

    @Override
    protected InputStream getInputStream(AbstractAssignment.Resource res) throws IOException {
        return ((FileResource)res).getInputStream();
    }

    @Override
    protected AbstractAssignment.Resource getResource(String name) {
        for (int t = 0; t < this.resources.length; ++t) {
            if (!this.resources[t].getName().equals(name)) continue;
            return this.resources[t];
        }
        return null;
    }

    @Override
    protected Enumeration getResources() {
        Vector<FileResource> v = new Vector<FileResource>();
        for (int t = 0; t < this.resources.length; ++t) {
            v.add(this.resources[t]);
        }
        return v.elements();
    }

    protected void determineResources(File root) throws IOException {
        FileResource fr;
        int t;
        File[] dirs = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.getName().startsWith(".") && f.isDirectory();
            }
        });
        String sourceFolderName = null;
        for (int t2 = 0; t2 < dirs.length; ++t2) {
            if (!dirs[t2].getName().endsWith("Test")) continue;
            sourceFolderName = dirs[t2].getName().substring(0, dirs[t2].getName().length() - 4);
        }
        if (sourceFolderName == null) {
            throw new IOException("xxxTest folder not found.");
        }
        File sourceFolder = null;
        File binFolder = null;
        for (int t3 = 0; t3 < dirs.length; ++t3) {
            if (dirs[t3].getName().equals(sourceFolderName)) {
                sourceFolder = dirs[t3];
            }
            if (!dirs[t3].getName().equals("bin")) continue;
            binFolder = dirs[t3];
        }
        if (sourceFolder == null) {
            throw new IOException("Missing source folder.");
        }
        if (binFolder == null) {
            throw new IOException("Missing bin folder");
        }
        File[] sourceFiles = sourceFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        });
        File[] binFiles = binFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        });
        ArrayList<FileResource> resources = new ArrayList<FileResource>();
        ArrayList<File> classFiles = new ArrayList<File>();
        for (t = 0; t < sourceFiles.length; ++t) {
            fr = new FileResource(sourceFiles[t]);
            resources.add(fr);
            if (!fr.getName().endsWith(".mf")) continue;
            this.manifestResource = fr;
        }
        for (t = 0; t < binFiles.length; ++t) {
            fr = new FileResource(binFiles[t]);
            if (binFiles[t].getName().endsWith(".class")) {
                String javaName = binFiles[t].getName();
                javaName = javaName.substring(0, javaName.length() - ".class".length()) + ".java";
                boolean found = false;
                for (int y = 0; y < resources.size(); ++y) {
                    if (!((AbstractAssignment.Resource)resources.get(y)).getName().equals(javaName)) continue;
                    found = true;
                }
                if (found) continue;
                classFiles.add(binFiles[t]);
                continue;
            }
            boolean found = false;
            for (int y = 0; y < resources.size(); ++y) {
                if (!((AbstractAssignment.Resource)resources.get(y)).getName().equals(fr.getName())) continue;
                found = true;
            }
            if (found) continue;
            resources.add(fr);
        }
        this.resources = resources.toArray(new FileResource[resources.size()]);
        this.classFiles = classFiles.toArray(new File[classFiles.size()]);
        if (this.manifestResource == null) {
            throw new IOException("No Manifest found.");
        }
    }

    protected Manifest getManifest() throws IOException {
        if (this.manifestResource == null) {
            throw new IOException("No Manifest found.");
        }
        return new Manifest(this.manifestResource.getInputStream());
    }

    private static class FileResource
    implements AbstractAssignment.Resource {
        private File f;

        public FileResource(File f) {
            this.f = f;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public long getSize() {
            return this.f.length();
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.f);
        }
    }
}

