/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.assignment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.util.Tool;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Tester;
import nl.moj.security.DefaultSecurityDelegate;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.JarClassLoader;

public class LegacyPropertyFileAssignment
implements Assignment {
    private static final String EXT_JAVA = ".java";
    private static final String EXT_TXT = ".txt";
    private static final String EXT_MF = ".mf";
    private ResourceBundle myAssignment;
    private JarFile mySourceJar;
    private Operation[] myOps;
    private String[] editableFiles;
    private boolean textFileIsMonospaced;
    private List textFiles = new ArrayList();
    private List javaFiles = new ArrayList();
    private ApplicationBuilder parent;
    protected Tester.SecurityDelegate delegate;
    private File base;

    public LegacyPropertyFileAssignment(File src, ApplicationBuilder bld) throws IOException {
        this(src.getParentFile(), new PropertyResourceBundle(new FileInputStream(src)), bld);
    }

    protected String getString(String name, String defaultValue) {
        try {
            return this.myAssignment.getString(name);
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public LegacyPropertyFileAssignment(File base, ResourceBundle assignment, ApplicationBuilder bld) throws IOException {
        this.base = base;
        this.myAssignment = assignment;
        File assignmentFile = new File(base, this.myAssignment.getString("ASSIGNMENT"));
        if (!assignmentFile.exists() && !(assignmentFile = new File(this.myAssignment.getString("ASSIGNMENT"))).exists()) {
            throw new IOException("Assignment file '" + assignmentFile + "' does not exist.");
        }
        this.mySourceJar = new JarFile(assignmentFile);
        this.parent = bld;
        Manifest mf = this.mySourceJar.getManifest();
        if (mf == null) {
            throw new IOException("Missing Manifest file.");
        }
        Attributes a = mf.getMainAttributes();
        if (a == null) {
            throw new IOException("Missing MainAttributes in Manifest File.");
        }
        String val = a.getValue("Editable");
        if (val == null && (val = this.getString("EDITABLE", null)) == null) {
            throw new IOException("'Editable' entry in MainAttributes is NULL - missing CRLF at the end ?");
        }
        this.editableFiles = Tool.cut(val, " ");
        String securityDelegate = this.getString("SECURITYDELEGATE", null);
        if (securityDelegate == null) {
            Logger.getLogger("Assignment").warning("'SECURITYDELEGATE' not set. Using default.");
            this.delegate = new DefaultSecurityDelegate();
        } else {
            try {
                ClassLoader cl = LegacyPropertyFileAssignment.class.getClassLoader();
                String securityDelegateJar = this.getString("SECURITYDELEGATE.JAR", null);
                if (securityDelegateJar != null) {
                    JarFile secJar = new JarFile(new File(base, securityDelegateJar));
                    cl = new JarClassLoader(secJar, cl);
                }
                ApplicationBuilder ab = new ApplicationBuilder(this.parent);
                ab.register(Manifest.class, mf);
                ab.build(new Class[]{cl.loadClass(securityDelegate)});
                this.delegate = (Tester.SecurityDelegate)ab.get(Tester.SecurityDelegate.class);
                if (this.delegate == null) {
                    throw new NullPointerException("Error getting '" + securityDelegate + "' as Tester.SecurityDelegate");
                }
            }
            catch (Exception ex) {
                throw new IOException("Failed instantiating '" + securityDelegate + "' : " + ex);
            }
        }
        this.registerAssignmentWithSecurityManager();
        String monospaced = a.getValue("Monospaced");
        if (monospaced == null) {
            monospaced = this.getString("MONOSPACED", "FALSE");
        }
        this.textFileIsMonospaced = "TRUE".equalsIgnoreCase(monospaced);
        Enumeration<JarEntry> entries = this.mySourceJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            String name = e.getName();
            if (name.endsWith(EXT_JAVA)) {
                this.javaFiles.add(name);
                continue;
            }
            if (name.endsWith(EXT_TXT)) {
                this.textFiles.add(name);
                continue;
            }
            if (name.endsWith(EXT_MF) || name.endsWith("/")) continue;
            throw new IOException("Unexpected file : " + name);
        }
    }

    protected void registerAssignmentWithSecurityManager() {
        SandboxSecurityManager ssm = (SandboxSecurityManager)System.getSecurityManager();
        ssm.registerAssignment(this);
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.myAssignment.getString("NAME");
    }

    @Override
    public String[] getDescriptionFileNames() {
        return this.textFiles.toArray(new String[this.textFiles.size()]);
    }

    @Override
    public String[] getEditableFileNames() {
        return (String[])Tool.copy(this.editableFiles);
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return this.javaFiles.toArray(new String[this.javaFiles.size()]);
    }

    @Override
    public boolean isDescriptionRenderedInMonospaceFont() {
        return this.textFileIsMonospaced;
    }

    @Override
    public InputStream getAssignmentFileData(String name) throws IOException {
        ZipEntry ze = this.mySourceJar.getEntry(name);
        if (ze == null) {
            throw new NullPointerException("ZipEntry not found for " + name);
        }
        return this.mySourceJar.getInputStream(ze);
    }

    @Override
    public Operation[] getOperations() {
        if (this.myOps == null) {
            String[] opNames = Tool.cut(this.myAssignment.getString("OPERATIONS"), ",");
            this.myOps = new Operation[opNames.length];
            for (int t = 0; t < this.myOps.length; ++t) {
                this.myOps[t] = this.buildOperation(this.myAssignment, opNames[t]);
            }
        }
        return (Operation[])Tool.copy(this.myOps);
    }

    private Operation buildOperation(ResourceBundle res, String name) {
        String type = res.getString("OPERATIONS." + name);
        Operation result = null;
        try {
            ResourceBundleConfiguration cfg = new ResourceBundleConfiguration(this.base, res, "OPERATIONS." + name);
            ApplicationBuilder ab = new ApplicationBuilder(this.parent);
            ab.register(Operation.Configuration.class, cfg);
            Class<?> c = Class.forName(type);
            ab.build(new Class[]{c});
            result = (Operation)ab.get(c);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create Operation " + name + ".", ex);
        }
        return result;
    }

    @Override
    public Tester.SecurityDelegate getSecurityDelegate() {
        return this.delegate;
    }

    @Override
    public String getAuthor() {
        return null;
    }

    @Override
    public byte[] getIcon() {
        return null;
    }

    @Override
    public byte[] getSponsorImage() {
        return null;
    }

    @Override
    public String getSubmitClass() {
        throw new RuntimeException("Not implemented/not used.");
    }

    @Override
    public int getSubmitClassTimeout() {
        throw new RuntimeException("Not implemented/not used.");
    }

    @Override
    public String getTestClass() {
        throw new RuntimeException("Not implemented/not used.");
    }

    @Override
    public int getTestClassTimeout() {
        throw new RuntimeException("Not implemented/not used.");
    }

    @Override
    public int getDuration() {
        return 30;
    }

    private static class ResourceBundleConfiguration
    implements Operation.Configuration {
        private ResourceBundle res;
        private String base;
        private File parent;

        public ResourceBundleConfiguration(File parent, ResourceBundle res, String base) {
            this.res = res;
            this.base = base;
            this.parent = parent;
        }

        @Override
        public String getParameter(Operation which, String name) {
            try {
                return this.res.getString(this.base + "." + name);
            }
            catch (MissingResourceException ex) {
                return null;
            }
        }

        @Override
        public File getParentDir(Operation which) {
            return this.parent;
        }
    }
}

