/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.assignment;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.util.Tool;
import nl.moj.assignment.AbstractAssignment;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.operation.Compile;
import nl.moj.operation.Save;
import nl.moj.operation.Submit;
import nl.moj.operation.Test;
import nl.moj.process.ProcessPool;
import nl.moj.test.JarClassLoader;

public class JarFileAssignment
extends AbstractAssignment
implements Assignment {
    private ProcessPool pool;
    private ApplicationBuilder builder;
    private File jarFile;
    private JarFile assignmentJar;
    private AbstractAssignment.Resource[] resources;

    public JarFileAssignment(File f, ProcessPool pool, ApplicationBuilder parent) throws Exception {
        this.pool = pool;
        this.builder = parent;
        this.jarFile = f;
        this.name = f.getName();
        if (this.name.indexOf(46) >= 0) {
            this.name = this.name.substring(0, this.name.indexOf(46));
        }
        this.assignmentJar = new JarFile(f);
        this.findResources(this.assignmentJar);
        this.parseManifest(this.getManifest());
    }

    protected void findResources(JarFile j) {
        ArrayList<JarResource> l = new ArrayList<JarResource>();
        Enumeration<JarEntry> e = j.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            l.add(new JarResource(je));
        }
        this.resources = l.toArray(new AbstractAssignment.Resource[l.size()]);
    }

    protected Manifest getManifest() throws IOException {
        Manifest mf = this.assignmentJar.getManifest();
        if (mf == null) {
            throw new IOException(this.jarFile.getName() + " does not contain a Manifest file.");
        }
        return mf;
    }

    public byte[] getJarFileData() throws IOException {
        return Tool.readBinary(new BufferedInputStream(new FileInputStream(this.jarFile)), (int)this.jarFile.length());
    }

    @Override
    public InputStream getAssignmentFileData(String name) throws IOException {
        ZipEntry ze = this.assignmentJar.getEntry(name);
        if (ze == null) {
            throw new NullPointerException("ZipEntry not found for " + name);
        }
        return this.assignmentJar.getInputStream(ze);
    }

    @Override
    protected InputStream getInputStream(AbstractAssignment.Resource res) throws IOException {
        return this.assignmentJar.getInputStream(((JarResource)res).getJarEntry());
    }

    @Override
    protected AbstractAssignment.Resource getResource(String name) {
        for (int t = 0; t < this.resources.length; ++t) {
            if (!this.resources[t].getName().equals(name)) continue;
            return this.resources[t];
        }
        return null;
    }

    @Override
    protected Enumeration getResources() {
        Vector<AbstractAssignment.Resource> v = new Vector<AbstractAssignment.Resource>();
        for (int t = 0; t < this.resources.length; ++t) {
            v.add(this.resources[t]);
        }
        return v.elements();
    }

    @Override
    protected ClassLoader createSecurityDelegateClassLoader() {
        return new JarClassLoader(this.assignmentJar, this.getClass().getClassLoader());
    }

    @Override
    protected Operation[] createOperations() throws Exception {
        this.theOps = new Operation[4];
        this.theOps[0] = new Save(this.pool);
        this.theOps[1] = new Compile(this.pool);
        this.theOps[2] = new Test((Assignment)this, this.pool, this.jarFile);
        this.theOps[3] = new Submit((Assignment)this, this.pool, this.jarFile);
        return this.theOps;
    }

    @Override
    protected ApplicationBuilder getApplicationBuilder() {
        return this.builder;
    }

    private static class JarResource
    implements AbstractAssignment.Resource {
        private JarEntry f;

        public JarResource(JarEntry f) {
            this.f = f;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public long getSize() {
            return this.f.getSize();
        }

        public JarEntry getJarEntry() {
            return this.f;
        }
    }
}

